/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.graph;

import org.psjava.ds.array.DynamicArray;
import org.psjava.ds.graph.Graph;
import org.psjava.ds.graph.GraphToString;
import org.psjava.ds.map.MutableMap;
import org.psjava.ds.set.MutableSet;
import org.psjava.ds.set.Set;
import org.psjava.goods.GoodMutableMapFactory;
import org.psjava.goods.GoodMutableSetFactory;
import org.psjava.util.AssertStatus;

public class MutableGraph<V, E>
implements Graph<V, E> {
    private MutableSet<V> vertices = GoodMutableSetFactory.getInstance().create();
    private MutableMap<V, DynamicArray<E>> edgeMap = GoodMutableMapFactory.getInstance().create();

    public static <V, E> MutableGraph<V, E> create() {
        return new MutableGraph<V, E>();
    }

    public void insertVertex(V v) {
        if (!this.vertices.contains(v)) {
            this.vertices.add(v);
            this.edgeMap.add(v, (DynamicArray<E>)new DynamicArray());
        }
    }

    public void addEdge(V from, E edge) {
        AssertStatus.assertTrue(this.edgeMap.containsKey(from), "Given vertex is not in the graph");
        ((DynamicArray)this.edgeMap.get(from)).addToLast(edge);
    }

    @Override
    public Set<V> getVertices() {
        return this.vertices;
    }

    @Override
    public Iterable<E> getEdges(V v) {
        return (Iterable)this.edgeMap.get(v);
    }

    public String toString() {
        return GraphToString.toString(this);
    }
}

