/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import com.google.common.primitives.Ints;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.caffinitas.ohc.OHCacheBuilder;
import org.caffinitas.ohc.Ticker;
import org.caffinitas.ohc.histo.EstimatedHistogram;
import org.caffinitas.ohc.linked.HashEntries;
import org.caffinitas.ohc.linked.KeyBuffer;
import org.caffinitas.ohc.linked.LongArrayList;
import org.caffinitas.ohc.linked.Timeouts;
import org.caffinitas.ohc.linked.Uns;
import org.caffinitas.ohc.linked.Util;

abstract class OffHeapLinkedMap {
    private static final int MAX_TABLE_SIZE = 0x40000000;
    long size;
    Table table;
    private long hitCount;
    private long missCount;
    private long putAddCount;
    private long putReplaceCount;
    private long removeCount;
    private long threshold;
    private final float loadFactor;
    private long rehashes;
    long evictedEntries;
    private long expiredEntries;
    private final boolean unlocked;
    private volatile long lock;
    private static final AtomicLongFieldUpdater<OffHeapLinkedMap> lockFieldUpdater = AtomicLongFieldUpdater.newUpdater(OffHeapLinkedMap.class, "lock");
    private final boolean throwOOME;
    private final Ticker ticker;
    private final Timeouts timeouts;
    private final Timeouts.TimeoutHandler timeoutsExpireHandler = hashEntryAdr -> this.removeEntry(hashEntryAdr, false);

    OffHeapLinkedMap(OHCacheBuilder builder) {
        this.throwOOME = builder.isThrowOOME();
        this.ticker = builder.getTicker();
        this.timeouts = builder.isTimeouts() ? new Timeouts(this.ticker, builder.getTimeoutsSlots(), builder.getTimeoutsPrecision()) : null;
        this.unlocked = builder.isUnlocked();
        int hts = builder.getHashTableSize();
        if (hts <= 0) {
            hts = 8192;
        }
        if (hts < 256) {
            hts = 256;
        }
        int msz = Ints.checkedCast((long)Util.roundUpToPowerOf2(hts, 0x40000000L));
        this.table = Table.create(msz, this.throwOOME);
        if (this.table == null) {
            throw new RuntimeException("unable to allocate off-heap memory for segment");
        }
        float lf = builder.getLoadFactor();
        if ((double)lf <= 0.0) {
            lf = 0.75f;
        }
        this.loadFactor = lf;
        this.threshold = (long)((double)this.table.size() * (double)this.loadFactor);
    }

    void release() {
        boolean wasFirst = this.lock();
        try {
            try {
                this.table.release();
                this.table = null;
            }
            finally {
                if (this.timeouts != null) {
                    this.timeouts.release();
                }
            }
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    long size() {
        return this.size;
    }

    long hitCount() {
        return this.hitCount;
    }

    long missCount() {
        return this.missCount;
    }

    long putAddCount() {
        return this.putAddCount;
    }

    long putReplaceCount() {
        return this.putReplaceCount;
    }

    long removeCount() {
        return this.removeCount;
    }

    void resetStatistics() {
        this.rehashes = 0L;
        this.evictedEntries = 0L;
        this.hitCount = 0L;
        this.missCount = 0L;
        this.putAddCount = 0L;
        this.putReplaceCount = 0L;
        this.removeCount = 0L;
    }

    long rehashes() {
        return this.rehashes;
    }

    abstract long freeCapacity();

    abstract void updateFreeCapacity(long var1);

    long evictedEntries() {
        return this.evictedEntries;
    }

    long expiredEntries() {
        return this.expiredEntries;
    }

    int usedTimeouts() {
        return this.timeouts != null ? this.timeouts.used() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getEntry(KeyBuffer key, boolean reference, boolean updateLRU) {
        boolean wasFirst = this.lock();
        try {
            long hashEntryAdr = this.table.getFirst(key.hash());
            while (hashEntryAdr != 0L) {
                if (key.sameKey(hashEntryAdr)) {
                    long expireAt = HashEntries.getExpireAt(hashEntryAdr);
                    if (expireAt > 0L && expireAt <= this.ticker.currentTimeMillis()) {
                        ++this.expiredEntries;
                        this.removeEntry(hashEntryAdr);
                        break;
                    }
                    if (updateLRU) {
                        this.touch(hashEntryAdr);
                    }
                    if (reference) {
                        HashEntries.reference(hashEntryAdr);
                    }
                    ++this.hitCount;
                    long l = hashEntryAdr;
                    return l;
                }
                hashEntryAdr = HashEntries.getNext(hashEntryAdr);
            }
            ++this.missCount;
            long l = 0L;
            return l;
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean putEntry(long newHashEntryAdr, long hash, long keyLen, long bytes, boolean ifAbsent, long expireAt, long oldValueAddr, long oldValueLen) {
        long removeHashEntryAdr = 0L;
        LongArrayList derefList = null;
        boolean wasFirst = this.lock();
        try {
            long oldHashEntryAdr = 0L;
            long prevEntryAdr = 0L;
            long hashEntryAdr = this.table.getFirst(hash);
            while (hashEntryAdr != 0L) {
                if (!OffHeapLinkedMap.notSameKey(newHashEntryAdr, hash, keyLen, hashEntryAdr)) {
                    long testExpireAt = HashEntries.getExpireAt(hashEntryAdr);
                    if (testExpireAt == 0L || testExpireAt > this.ticker.currentTimeMillis()) {
                        long valueLen;
                        if (ifAbsent) {
                            boolean bl = false;
                            return bl;
                        }
                        if (!(oldValueAddr == 0L || (valueLen = (long)HashEntries.getValueLen(hashEntryAdr)) == oldValueLen && Uns.memoryCompare(hashEntryAdr, 64L + Util.roundUpTo8(keyLen), oldValueAddr, 0L, oldValueLen))) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    this.removeInternal(hashEntryAdr, prevEntryAdr, true);
                    removeHashEntryAdr = hashEntryAdr;
                    oldHashEntryAdr = hashEntryAdr;
                    break;
                }
                prevEntryAdr = hashEntryAdr;
                hashEntryAdr = HashEntries.getNext(hashEntryAdr);
            }
            derefList = this.ensureFreeSpaceForNewEntry(bytes);
            if (!this.hasFreeSpaceForNewEntry(bytes)) {
                if (oldHashEntryAdr != 0L) {
                    --this.size;
                }
                boolean bl = false;
                return bl;
            }
            if (hashEntryAdr == 0L) {
                if (this.size >= this.threshold) {
                    this.rehash();
                }
                ++this.size;
            }
            this.add(newHashEntryAdr, hash, expireAt);
            if (hashEntryAdr == 0L) {
                ++this.putAddCount;
            } else {
                ++this.putReplaceCount;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlock(wasFirst);
            if (removeHashEntryAdr != 0L) {
                HashEntries.dereference(removeHashEntryAdr);
            }
            if (derefList != null) {
                for (int i = 0; i < derefList.size(); ++i) {
                    HashEntries.dereference(derefList.getLong(i));
                }
            }
        }
    }

    private static boolean notSameKey(long newHashEntryAdr, long newHash, long newKeyLen, long hashEntryAdr) {
        if (HashEntries.getHash(hashEntryAdr) != newHash) {
            return true;
        }
        long serKeyLen = HashEntries.getKeyLen(hashEntryAdr);
        return serKeyLen != newKeyLen || !Uns.memoryCompare(hashEntryAdr, 64L, newHashEntryAdr, 64L, serKeyLen);
    }

    abstract LongArrayList ensureFreeSpaceForNewEntry(long var1);

    abstract boolean hasFreeSpaceForNewEntry(long var1);

    void removeExpired() {
        if (this.timeouts != null) {
            this.expiredEntries += (long)this.timeouts.removeExpired(this.timeoutsExpireHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        boolean wasFirst = this.lock();
        try {
            this.size = 0L;
            for (int p = 0; p < this.table.size(); ++p) {
                long hashEntryAdr = this.table.getFirst(p);
                while (hashEntryAdr != 0L) {
                    long expireAt;
                    long next = HashEntries.getNext(hashEntryAdr);
                    if (this.timeouts != null && (expireAt = HashEntries.getExpireAt(hashEntryAdr)) > 0L) {
                        this.timeouts.remove(hashEntryAdr, expireAt);
                    }
                    HashEntries.dereference(hashEntryAdr);
                    hashEntryAdr = next;
                }
            }
            this.clearLruAndCapacity();
            this.table.clear();
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    void removeEntry(long removeHashEntryAdr) {
        this.removeEntry(removeHashEntryAdr, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntry(long removeHashEntryAdr, boolean removeFromTimeouts) {
        boolean wasFirst = this.lock();
        try {
            long hash = HashEntries.getHash(removeHashEntryAdr);
            long prevEntryAdr = 0L;
            long hashEntryAdr = this.table.getFirst(hash);
            while (hashEntryAdr != 0L) {
                if (hashEntryAdr == removeHashEntryAdr) {
                    this.removeInternal(hashEntryAdr, prevEntryAdr, removeFromTimeouts);
                    --this.size;
                    ++this.removeCount;
                    return;
                }
                prevEntryAdr = hashEntryAdr;
                hashEntryAdr = HashEntries.getNext(hashEntryAdr);
            }
            removeHashEntryAdr = 0L;
        }
        finally {
            this.unlock(wasFirst);
            if (removeHashEntryAdr != 0L) {
                HashEntries.dereference(removeHashEntryAdr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeEntry(KeyBuffer key) {
        long removeHashEntryAdr = 0L;
        boolean wasFirst = this.lock();
        try {
            long prevEntryAdr = 0L;
            long hashEntryAdr = this.table.getFirst(key.hash());
            while (hashEntryAdr != 0L) {
                if (key.sameKey(hashEntryAdr)) {
                    removeHashEntryAdr = hashEntryAdr;
                    this.removeInternal(hashEntryAdr, prevEntryAdr, true);
                    --this.size;
                    ++this.removeCount;
                    boolean bl = true;
                    return bl;
                }
                prevEntryAdr = hashEntryAdr;
                hashEntryAdr = HashEntries.getNext(hashEntryAdr);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock(wasFirst);
            if (removeHashEntryAdr != 0L) {
                HashEntries.dereference(removeHashEntryAdr);
            }
        }
    }

    private void rehash() {
        Table tab = this.table;
        int tableSize = tab.size();
        if (tableSize > 0x40000000) {
            return;
        }
        Table newTable = Table.create(tableSize * 2, this.throwOOME);
        if (newTable == null) {
            return;
        }
        for (int part = 0; part < tableSize; ++part) {
            long hashEntryAdr = tab.getFirst(part);
            while (hashEntryAdr != 0L) {
                long next = HashEntries.getNext(hashEntryAdr);
                HashEntries.setNext(hashEntryAdr, 0L);
                newTable.addAsHead(HashEntries.getHash(hashEntryAdr), hashEntryAdr);
                hashEntryAdr = next;
            }
        }
        this.threshold = (long)((float)newTable.size() * this.loadFactor);
        this.table.release();
        this.table = newTable;
        ++this.rehashes;
    }

    abstract long[] hotN(int var1);

    float loadFactor() {
        return this.loadFactor;
    }

    int hashTableSize() {
        return this.table.size();
    }

    void updateBucketHistogram(EstimatedHistogram hist) {
        boolean wasFirst = this.lock();
        try {
            this.table.updateBucketHistogram(hist);
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getEntryAddresses(int mapSegmentIndex, int nSegments, LongArrayList hashEntryAdrs) {
        boolean wasFirst = this.lock();
        try {
            long t = this.ticker.currentTimeMillis();
            while (nSegments-- > 0 && mapSegmentIndex < this.table.size()) {
                long hashEntryAdr = this.table.getFirst(mapSegmentIndex);
                while (hashEntryAdr != 0L) {
                    long expireAt = HashEntries.getExpireAt(hashEntryAdr);
                    if (expireAt > 0L && expireAt <= t) {
                        this.removeEntry(hashEntryAdr);
                        ++this.expiredEntries;
                    } else {
                        hashEntryAdrs.add(hashEntryAdr);
                        HashEntries.reference(hashEntryAdr);
                    }
                    hashEntryAdr = HashEntries.getNext(hashEntryAdr);
                }
                ++mapSegmentIndex;
            }
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    void removeInternal(long hashEntryAdr, long prevEntryAdr, boolean removeFromTimeouts) {
        long expireAt;
        long hash = HashEntries.getHash(hashEntryAdr);
        this.table.removeLink(hash, hashEntryAdr, prevEntryAdr);
        if (removeFromTimeouts && this.timeouts != null && (expireAt = HashEntries.getExpireAt(hashEntryAdr)) > 0L) {
            this.timeouts.remove(hashEntryAdr, expireAt);
        }
        this.removeFromLruAndUpdateCapacity(hashEntryAdr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean replaceSentinelEntry(long hash, long oldHashEntryAdr, long newHashEntryAdr, long bytes, long expireAt) {
        LongArrayList derefList = null;
        boolean wasFirst = this.lock();
        try {
            long prevEntryAdr = 0L;
            long hashEntryAdr = this.table.getFirst(hash);
            while (hashEntryAdr != 0L) {
                if (hashEntryAdr == oldHashEntryAdr) {
                    this.table.replaceSentinelLink(hash, oldHashEntryAdr, prevEntryAdr, newHashEntryAdr);
                    if (expireAt > 0L) {
                        if (this.timeouts != null) {
                            this.timeouts.add(newHashEntryAdr, expireAt);
                        } else {
                            throw new IllegalStateException("entry TTLs not enabled on this cache instance");
                        }
                    }
                    derefList = this.ensureFreeSpaceForNewEntry(bytes);
                    if (!this.hasFreeSpaceForNewEntry(bytes)) {
                        boolean bl = false;
                        return bl;
                    }
                    this.replaceSentinelInLruAndUpdateCapacity(oldHashEntryAdr, newHashEntryAdr, bytes);
                    boolean bl = true;
                    return bl;
                }
                prevEntryAdr = hashEntryAdr;
                hashEntryAdr = HashEntries.getNext(hashEntryAdr);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock(wasFirst);
            if (derefList != null) {
                for (int i = 0; i < derefList.size(); ++i) {
                    HashEntries.dereference(derefList.getLong(i));
                }
            }
        }
    }

    private void add(long hashEntryAdr, long hash, long expireAt) {
        this.table.addAsHead(hash, hashEntryAdr);
        this.addToLruAndUpdateCapacity(hashEntryAdr);
        if (expireAt > 0L) {
            if (this.timeouts != null) {
                this.timeouts.add(hashEntryAdr, expireAt);
            } else {
                throw new IllegalStateException("entry TTLs not enabled on this cache instance");
            }
        }
    }

    abstract void addToLruAndUpdateCapacity(long var1);

    abstract void removeFromLruAndUpdateCapacity(long var1);

    abstract void replaceSentinelInLruAndUpdateCapacity(long var1, long var3, long var5);

    abstract void clearLruAndCapacity();

    abstract void touch(long var1);

    boolean lock() {
        if (this.unlocked) {
            return false;
        }
        long t = Thread.currentThread().getId();
        if (t == lockFieldUpdater.get(this)) {
            return false;
        }
        block0: while (!lockFieldUpdater.compareAndSet(this, 0L, t)) {
            while (true) {
                if (lockFieldUpdater.get(this) == 0L) continue block0;
                Thread.yield();
            }
            break;
        }
        return true;
    }

    void unlock(boolean wasFirst) {
        if (this.unlocked || !wasFirst) {
            return;
        }
        long t = Thread.currentThread().getId();
        boolean r = lockFieldUpdater.compareAndSet(this, t, 0L);
        assert (r);
    }

    public String toString() {
        return String.valueOf(this.size);
    }

    static final class Table {
        final int mask;
        final long address;
        private boolean released;

        static Table create(int hashTableSize, boolean throwOOME) {
            int msz = Ints.checkedCast((long)(8L * (long)hashTableSize));
            long address = Uns.allocate(msz, throwOOME);
            return address != 0L ? new Table(address, hashTableSize) : null;
        }

        private Table(long address, int hashTableSize) {
            this.address = address;
            this.mask = hashTableSize - 1;
            this.clear();
        }

        void clear() {
            Uns.setMemory(this.address, 0L, 8L * (long)this.size(), (byte)0);
        }

        void release() {
            Uns.free(this.address);
            this.released = true;
        }

        protected void finalize() throws Throwable {
            if (!this.released) {
                Uns.free(this.address);
            }
            super.finalize();
        }

        long getFirst(long hash) {
            return Uns.getLong(this.address, this.bucketOffset(hash));
        }

        void setFirst(long hash, long hashEntryAdr) {
            Uns.putLong(this.address, this.bucketOffset(hash), hashEntryAdr);
        }

        private long bucketOffset(long hash) {
            return (long)this.bucketIndexForHash(hash) * 8L;
        }

        private int bucketIndexForHash(long hash) {
            return (int)(hash & (long)this.mask);
        }

        void removeLink(long hash, long hashEntryAdr, long prevEntryAdr) {
            long next = HashEntries.getNext(hashEntryAdr);
            this.removeLinkInternal(hash, hashEntryAdr, prevEntryAdr, next);
        }

        void replaceSentinelLink(long hash, long hashEntryAdr, long prevEntryAdr, long newHashEntryAdr) {
            HashEntries.setNext(newHashEntryAdr, HashEntries.getNext(hashEntryAdr));
            this.removeLinkInternal(hash, hashEntryAdr, prevEntryAdr, newHashEntryAdr);
        }

        private void removeLinkInternal(long hash, long hashEntryAdr, long prevEntryAdr, long next) {
            long head = this.getFirst(hash);
            if (head == hashEntryAdr) {
                this.setFirst(hash, next);
            } else if (prevEntryAdr != 0L) {
                if (prevEntryAdr == -1L) {
                    long adr = head;
                    while (adr != 0L && adr != hashEntryAdr) {
                        prevEntryAdr = adr;
                        adr = HashEntries.getNext(adr);
                    }
                }
                HashEntries.setNext(prevEntryAdr, next);
            }
        }

        void addAsHead(long hash, long hashEntryAdr) {
            long head = this.getFirst(hash);
            HashEntries.setNext(hashEntryAdr, head);
            this.setFirst(hash, hashEntryAdr);
        }

        int size() {
            return this.mask + 1;
        }

        void updateBucketHistogram(EstimatedHistogram h) {
            for (int i = 0; i < this.size(); ++i) {
                int len = 0;
                long adr = this.getFirst(i);
                while (adr != 0L) {
                    ++len;
                    adr = HashEntries.getNext(adr);
                }
                h.add(len + 1);
            }
        }
    }
}

