/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.memory.consumer.factory;

import java.util.UUID;
import org.apache.hugegraph.backend.cache.CachedBackendStore;
import org.apache.hugegraph.backend.id.EdgeId;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.serializer.BinaryBackendEntry;
import org.apache.hugegraph.memory.MemoryManager;
import org.apache.hugegraph.memory.consumer.OffHeapObject;
import org.apache.hugegraph.memory.consumer.impl.id.BinaryIdOffHeap;
import org.apache.hugegraph.memory.consumer.impl.id.EdgeIdOffHeap;
import org.apache.hugegraph.memory.consumer.impl.id.LongIdOffHeap;
import org.apache.hugegraph.memory.consumer.impl.id.ObjectIdOffHeap;
import org.apache.hugegraph.memory.consumer.impl.id.QueryIdOffHeap;
import org.apache.hugegraph.memory.consumer.impl.id.StringIdOffHeap;
import org.apache.hugegraph.memory.consumer.impl.id.UuidIdOffHeap;
import org.apache.hugegraph.memory.pool.impl.TaskMemoryPool;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.type.define.Directions;

public class IdFactory {
    private MemoryManager.MemoryMode memoryMode;

    private IdFactory() {
    }

    public BinaryBackendEntry.BinaryId newBinaryId(byte[] bytes, Id id) {
        switch (this.memoryMode) {
            case ENABLE_ON_HEAP_MANAGEMENT: 
            case ENABLE_OFF_HEAP_MANAGEMENT: {
                TaskMemoryPool taskMemoryPool = (TaskMemoryPool)MemoryManager.getInstance().getCorrespondingTaskMemoryPool(Thread.currentThread().getName());
                return new BinaryIdOffHeap(bytes, null, taskMemoryPool.getCurrentWorkingOperatorMemoryPool(), (OffHeapObject)((Object)id));
            }
        }
        return new BinaryBackendEntry.BinaryId(bytes, id);
    }

    public IdGenerator.LongId newLongId(long id) {
        switch (this.memoryMode) {
            case ENABLE_ON_HEAP_MANAGEMENT: 
            case ENABLE_OFF_HEAP_MANAGEMENT: {
                TaskMemoryPool taskMemoryPool = (TaskMemoryPool)MemoryManager.getInstance().getCorrespondingTaskMemoryPool(Thread.currentThread().getName());
                return new LongIdOffHeap(taskMemoryPool.getCurrentWorkingOperatorMemoryPool(), id);
            }
        }
        return new IdGenerator.LongId(id);
    }

    public IdGenerator.LongId newLongId(byte[] bytes) {
        switch (this.memoryMode) {
            case ENABLE_ON_HEAP_MANAGEMENT: 
            case ENABLE_OFF_HEAP_MANAGEMENT: {
                TaskMemoryPool taskMemoryPool = (TaskMemoryPool)MemoryManager.getInstance().getCorrespondingTaskMemoryPool(Thread.currentThread().getName());
                return new LongIdOffHeap(taskMemoryPool.getCurrentWorkingOperatorMemoryPool(), bytes);
            }
        }
        return new IdGenerator.LongId(bytes);
    }

    public IdGenerator.ObjectId newObjectId(Object object) {
        switch (this.memoryMode) {
            case ENABLE_ON_HEAP_MANAGEMENT: 
            case ENABLE_OFF_HEAP_MANAGEMENT: {
                TaskMemoryPool taskMemoryPool = (TaskMemoryPool)MemoryManager.getInstance().getCorrespondingTaskMemoryPool(Thread.currentThread().getName());
                return new ObjectIdOffHeap(taskMemoryPool.getCurrentWorkingOperatorMemoryPool(), object);
            }
        }
        return new IdGenerator.ObjectId(object);
    }

    public CachedBackendStore.QueryId newQueryId(Query q) {
        switch (this.memoryMode) {
            case ENABLE_ON_HEAP_MANAGEMENT: 
            case ENABLE_OFF_HEAP_MANAGEMENT: {
                TaskMemoryPool taskMemoryPool = (TaskMemoryPool)MemoryManager.getInstance().getCorrespondingTaskMemoryPool(Thread.currentThread().getName());
                return new QueryIdOffHeap(taskMemoryPool.getCurrentWorkingOperatorMemoryPool(), q);
            }
        }
        return new CachedBackendStore.QueryId(q);
    }

    public IdGenerator.StringId newStringId(String id) {
        switch (this.memoryMode) {
            case ENABLE_ON_HEAP_MANAGEMENT: 
            case ENABLE_OFF_HEAP_MANAGEMENT: {
                TaskMemoryPool taskMemoryPool = (TaskMemoryPool)MemoryManager.getInstance().getCorrespondingTaskMemoryPool(Thread.currentThread().getName());
                return new StringIdOffHeap(taskMemoryPool.getCurrentWorkingOperatorMemoryPool(), id);
            }
        }
        return new IdGenerator.StringId(id);
    }

    public IdGenerator.StringId newStringId(byte[] bytes) {
        switch (this.memoryMode) {
            case ENABLE_ON_HEAP_MANAGEMENT: 
            case ENABLE_OFF_HEAP_MANAGEMENT: {
                TaskMemoryPool taskMemoryPool = (TaskMemoryPool)MemoryManager.getInstance().getCorrespondingTaskMemoryPool(Thread.currentThread().getName());
                return new StringIdOffHeap(taskMemoryPool.getCurrentWorkingOperatorMemoryPool(), bytes);
            }
        }
        return new IdGenerator.StringId(bytes);
    }

    public IdGenerator.UuidId newUuidId(String id) {
        switch (this.memoryMode) {
            case ENABLE_ON_HEAP_MANAGEMENT: 
            case ENABLE_OFF_HEAP_MANAGEMENT: {
                TaskMemoryPool taskMemoryPool = (TaskMemoryPool)MemoryManager.getInstance().getCorrespondingTaskMemoryPool(Thread.currentThread().getName());
                return new UuidIdOffHeap(taskMemoryPool.getCurrentWorkingOperatorMemoryPool(), id);
            }
        }
        return new IdGenerator.UuidId(id);
    }

    public IdGenerator.UuidId newUuidId(byte[] bytes) {
        switch (this.memoryMode) {
            case ENABLE_ON_HEAP_MANAGEMENT: 
            case ENABLE_OFF_HEAP_MANAGEMENT: {
                TaskMemoryPool taskMemoryPool = (TaskMemoryPool)MemoryManager.getInstance().getCorrespondingTaskMemoryPool(Thread.currentThread().getName());
                return new UuidIdOffHeap(taskMemoryPool.getCurrentWorkingOperatorMemoryPool(), bytes);
            }
        }
        return new IdGenerator.UuidId(bytes);
    }

    public IdGenerator.UuidId newUuidId(UUID id) {
        switch (this.memoryMode) {
            case ENABLE_ON_HEAP_MANAGEMENT: 
            case ENABLE_OFF_HEAP_MANAGEMENT: {
                TaskMemoryPool taskMemoryPool = (TaskMemoryPool)MemoryManager.getInstance().getCorrespondingTaskMemoryPool(Thread.currentThread().getName());
                return new UuidIdOffHeap(taskMemoryPool.getCurrentWorkingOperatorMemoryPool(), id);
            }
        }
        return new IdGenerator.UuidId(id);
    }

    public EdgeId newEdgeId(HugeVertex ownerVertex, Directions direction, Id edgeLabelId, Id subLabelId, String sortValues, HugeVertex otherVertex) {
        switch (this.memoryMode) {
            case ENABLE_ON_HEAP_MANAGEMENT: 
            case ENABLE_OFF_HEAP_MANAGEMENT: {
                TaskMemoryPool taskMemoryPool = (TaskMemoryPool)MemoryManager.getInstance().getCorrespondingTaskMemoryPool(Thread.currentThread().getName());
                return new EdgeIdOffHeap(ownerVertex, direction, null, null, sortValues, otherVertex, taskMemoryPool.getCurrentWorkingOperatorMemoryPool(), (OffHeapObject)((Object)ownerVertex.id()), (OffHeapObject)((Object)edgeLabelId), (OffHeapObject)((Object)subLabelId), (OffHeapObject)((Object)otherVertex.id()));
            }
        }
        return new EdgeId(ownerVertex, direction, edgeLabelId, subLabelId, sortValues, otherVertex);
    }

    public EdgeId newEdgeId(Id ownerVertexId, Directions direction, Id edgeLabelId, Id subLabelId, String sortValues, Id otherVertexId) {
        switch (this.memoryMode) {
            case ENABLE_ON_HEAP_MANAGEMENT: 
            case ENABLE_OFF_HEAP_MANAGEMENT: {
                TaskMemoryPool taskMemoryPool = (TaskMemoryPool)MemoryManager.getInstance().getCorrespondingTaskMemoryPool(Thread.currentThread().getName());
                return new EdgeIdOffHeap((Id)null, direction, null, null, sortValues, null, taskMemoryPool.getCurrentWorkingOperatorMemoryPool(), (OffHeapObject)((Object)ownerVertexId), (OffHeapObject)((Object)edgeLabelId), (OffHeapObject)((Object)subLabelId), (OffHeapObject)((Object)otherVertexId));
            }
        }
        return new EdgeId(ownerVertexId, direction, edgeLabelId, subLabelId, sortValues, otherVertexId);
    }

    public EdgeId newEdgeId(Id ownerVertexId, Directions direction, Id edgeLabelId, Id subLabelId, String sortValues, Id otherVertexId, boolean directed) {
        switch (this.memoryMode) {
            case ENABLE_ON_HEAP_MANAGEMENT: 
            case ENABLE_OFF_HEAP_MANAGEMENT: {
                TaskMemoryPool taskMemoryPool = (TaskMemoryPool)MemoryManager.getInstance().getCorrespondingTaskMemoryPool(Thread.currentThread().getName());
                return new EdgeIdOffHeap(null, direction, null, null, sortValues, null, directed, taskMemoryPool.getCurrentWorkingOperatorMemoryPool(), (OffHeapObject)((Object)ownerVertexId), (OffHeapObject)((Object)edgeLabelId), (OffHeapObject)((Object)subLabelId), (OffHeapObject)((Object)otherVertexId));
            }
        }
        return new EdgeId(ownerVertexId, direction, edgeLabelId, subLabelId, sortValues, otherVertexId, directed);
    }

    public static IdFactory getInstance() {
        IdFactory instance = IdFactoryHolder.INSTANCE;
        if (instance.memoryMode == null) {
            instance.memoryMode = MemoryManager.getMemoryMode();
        }
        return IdFactoryHolder.INSTANCE;
    }

    private static class IdFactoryHolder {
        private static final IdFactory INSTANCE = new IdFactory();

        private IdFactoryHolder() {
        }
    }
}

