/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.tx;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.pd.client.PDClient;
import org.apache.hugegraph.pd.grpc.Pdpb;
import org.apache.hugegraph.store.term.HgPair;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.util.E;

public class IdCounter {
    private static final int TIMES = 10000;
    private static final int DELTA = 10000;
    private static final String DELIMITER = "/";
    private static final Map<String, HgPair<AtomicLong, AtomicLong>> ids = new ConcurrentHashMap<String, HgPair<AtomicLong, AtomicLong>>();
    private final PDClient pdClient;
    private final String graphName;

    public IdCounter(PDClient pdClient, String graphName) {
        this.graphName = graphName;
        this.pdClient = pdClient;
    }

    public Id nextId(HugeType type) {
        long counter = this.getCounter(type);
        E.checkState((counter != 0L ? 1 : 0) != 0, (String)"Please check whether '%s' is OK", (Object[])new Object[]{this.pdClient.toString()});
        return IdGenerator.of(counter);
    }

    public void setCounterLowest(HugeType type, long lowest) {
        long current = this.getCounter(type);
        if (current >= lowest) {
            return;
        }
        long increment = lowest - current;
        this.increaseCounter(type, increment);
    }

    public long getCounter(HugeType type) {
        return this.getCounterFromPd(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void increaseCounter(HugeType type, long lowest) {
        String key = this.toKey(this.graphName, type);
        this.getCounterFromPd(type);
        HgPair<AtomicLong, AtomicLong> idPair = ids.get(key);
        AtomicLong currentId = (AtomicLong)idPair.getKey();
        AtomicLong maxId = (AtomicLong)idPair.getValue();
        if (currentId.longValue() >= lowest) {
            return;
        }
        if (maxId.longValue() >= lowest) {
            currentId.set(lowest);
            return;
        }
        Map<String, HgPair<AtomicLong, AtomicLong>> map = ids;
        synchronized (map) {
            try {
                this.pdClient.getIdByKey(key, (int)(lowest - maxId.longValue()));
                ids.remove(key);
            }
            catch (Exception e) {
                throw new BackendException(e);
            }
        }
    }

    protected String toKey(String graphName, HugeType type) {
        return graphName + DELIMITER + type.code();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCounterFromPd(HugeType type) {
        AtomicLong maxId;
        AtomicLong currentId;
        String key = this.toKey(this.graphName, type);
        HgPair idPair = ids.get(key);
        if (idPair == null) {
            Map<String, HgPair<AtomicLong, AtomicLong>> map = ids;
            synchronized (map) {
                idPair = ids.get(key);
                if (idPair == null) {
                    try {
                        currentId = new AtomicLong(0L);
                        maxId = new AtomicLong(0L);
                        idPair = new HgPair((Object)currentId, (Object)maxId);
                        ids.put(key, (HgPair<AtomicLong, AtomicLong>)idPair);
                    }
                    catch (Exception e) {
                        throw new BackendException(String.format("Failed to get the ID from pd,%s", e));
                    }
                }
            }
        }
        currentId = (AtomicLong)idPair.getKey();
        maxId = (AtomicLong)idPair.getValue();
        for (int i = 0; i < 10000; ++i) {
            AtomicLong atomicLong = currentId;
            synchronized (atomicLong) {
                if (currentId.incrementAndGet() <= maxId.longValue()) {
                    return currentId.longValue();
                }
                if (currentId.longValue() > maxId.longValue()) {
                    try {
                        Pdpb.GetIdResponse idByKey = this.pdClient.getIdByKey(key, 10000);
                        ((AtomicLong)idPair.getValue()).getAndSet(idByKey.getId() + (long)idByKey.getDelta());
                        ((AtomicLong)idPair.getKey()).getAndSet(idByKey.getId());
                    }
                    catch (Exception e) {
                        throw new BackendException(String.format("Failed to get the ID from pd,%s", e));
                    }
                }
                continue;
            }
        }
        E.checkArgument((boolean)false, (String)"Having made too many attempts to get the ID for type '%s'", (Object[])new Object[]{type.name()});
        return 0L;
    }
}

