/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.serializer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.hugegraph.iterator.WrappedIterator;
import org.apache.hugegraph.util.E;

public class MergeIterator<T, R>
extends WrappedIterator<T> {
    private final Iterator<T> originIterator;
    private final BiFunction<T, R, Boolean> merger;
    private final List<Iterator<R>> iterators = new ArrayList<Iterator<R>>();
    private final List<R> headElements;

    public MergeIterator(Iterator<T> originIterator, List<Iterator<R>> iterators, BiFunction<T, R, Boolean> merger) {
        E.checkArgumentNotNull(originIterator, (String)"The origin iterator of MergeIterator can't be null", (Object[])new Object[0]);
        E.checkArgument((iterators != null && !iterators.isEmpty() ? 1 : 0) != 0, (String)"The iterators of MergeIterator can't be null or empty", (Object[])new Object[0]);
        E.checkArgumentNotNull(merger, (String)"The merger function of MergeIterator can't be null", (Object[])new Object[0]);
        this.originIterator = originIterator;
        this.headElements = new ArrayList<R>();
        for (Iterator<R> iterator : iterators) {
            if (!iterator.hasNext()) continue;
            this.iterators.add(iterator);
            this.headElements.add(iterator.next());
        }
        this.merger = merger;
    }

    public void close() throws Exception {
        for (Iterator<R> iter : this.iterators) {
            if (!(iter instanceof AutoCloseable)) continue;
            ((AutoCloseable)((Object)iter)).close();
        }
    }

    protected Iterator<T> originIterator() {
        return this.originIterator;
    }

    protected final boolean fetch() {
        if (!this.originIterator.hasNext()) {
            return false;
        }
        T next = this.originIterator.next();
        for (int i = 0; i < this.iterators.size(); ++i) {
            R element = this.headElements.get(i);
            if (element == MergeIterator.none() || !this.merger.apply(next, element).booleanValue()) continue;
            Iterator<R> iter = this.iterators.get(i);
            if (iter.hasNext()) {
                this.headElements.set(i, iter.next());
                continue;
            }
            this.headElements.set(i, MergeIterator.none());
            MergeIterator.close(iter);
        }
        assert (this.current == MergeIterator.none());
        this.current = next;
        return true;
    }
}

