/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.analyzer;

import com.google.common.collect.ImmutableList;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.analyzer.Analyzer;
import org.apache.hugegraph.config.ConfigException;
import org.apache.hugegraph.exception.HugeException;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.wltea.analyzer.core.IKSegmenter;
import org.wltea.analyzer.core.Lexeme;

public class IKAnalyzer
implements Analyzer {
    public static final List<String> SUPPORT_MODES = ImmutableList.of((Object)"smart", (Object)"max_word");
    private boolean smartSegMode;
    private final IKSegmenter ik;

    public IKAnalyzer(String mode) {
        if (!SUPPORT_MODES.contains(mode)) {
            throw new ConfigException("Unsupported segment mode '%s' for ikanalyzer, the available values are %s", new Object[]{mode, SUPPORT_MODES});
        }
        this.smartSegMode = SUPPORT_MODES.get(0).equals(mode);
        this.ik = new IKSegmenter((Reader)new StringReader(""), this.smartSegMode);
    }

    @Override
    public Set<String> segment(String text) {
        Set result = InsertionOrderUtil.newSet();
        this.ik.reset((Reader)new StringReader(text));
        try {
            Lexeme word = null;
            while ((word = this.ik.next()) != null) {
                result.add(word.getLexemeText());
            }
        }
        catch (Exception e) {
            throw new HugeException("IKAnalyzer segment text '%s' failed", (Throwable)e, text);
        }
        return result;
    }
}

