/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.gridkit.jvmtool.codec.stacktrace.ThreadSnapshotEvent;
import org.gridkit.jvmtool.event.CommonEvent;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.StackFrameList;
import org.gridkit.jvmtool.stacktrace.ThreadRecord;
import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadSnapshotFilter;
import org.gridkit.jvmtool.stacktrace.analytics.WeigthCalculator;
import org.gridkit.util.formating.TextTable;

public class StackHisto {
    public static Comparator<SiteInfo> BY_HITS = new HitComparator();
    public static Comparator<SiteInfo> BY_OCCURENCE = new OccurenceComparator();
    public static Comparator<SiteInfo> BY_TERMINAL = new TerminalComparator();
    private String[] conditionNames = new String[0];
    private ThreadSnapshotFilter[] conditionFilters = new ThreadSnapshotFilter[0];
    private Map<StackFrame, SiteInfo> histo = new HashMap<StackFrame, SiteInfo>();
    private long traceCount = 0L;
    private WeigthCalculator calc;
    private Comparator<SiteInfo> histoOrder = BY_OCCURENCE;

    public StackHisto(WeigthCalculator calc) {
        this.calc = calc;
    }

    public void addCondition(String name, ThreadSnapshotFilter filter) {
        int n = this.conditionNames.length;
        this.conditionNames = Arrays.copyOf(this.conditionNames, n + 1);
        this.conditionFilters = Arrays.copyOf(this.conditionFilters, n + 1);
        this.conditionNames[n] = name;
        this.conditionFilters[n] = filter;
    }

    public void feed(ThreadSnapshotEvent event) {
        long w = this.calc.getWeigth((CommonEvent)event);
        this.traceCount += w;
        StackFrameList trace = event.stackTrace();
        if (trace.depth() == 0) {
            return;
        }
        boolean[] matchVector = this.matchVector(trace);
        HashSet<StackFrame> seen = new HashSet<StackFrame>();
        for (StackFrame e : trace) {
            SiteInfo si = this.getSiteInfo(e);
            si.hitCount += w;
            if (!seen.add(si.site)) continue;
            si.occurences += w;
            for (int m = 0; m != matchVector.length; ++m) {
                if (!matchVector[m]) continue;
                int n = m;
                si.conditionalCounts[n] = si.conditionalCounts[n] + w;
            }
        }
        StackFrame last = trace.frameAt(0);
        this.getSiteInfo((StackFrame)last).terminalCount += w;
    }

    public void setHistoOrder(Comparator<SiteInfo> comparator) {
        this.histoOrder = comparator;
    }

    private boolean[] matchVector(StackFrameList trace) {
        boolean[] vec = new boolean[this.conditionNames.length];
        for (int i = 0; i != vec.length; ++i) {
            vec[i] = this.conditionFilters[i].evaluate((ThreadSnapshot)new ThreadRecord(trace));
        }
        return vec;
    }

    protected SiteInfo getSiteInfo(StackFrame e) {
        SiteInfo si = this.histo.get(e);
        if (si == null) {
            si = new SiteInfo();
            si.site = e;
            si.conditionNames = this.conditionNames;
            si.conditionalCounts = new long[this.conditionNames.length];
            this.histo.put(e, si);
        }
        return si;
    }

    public String formatHisto() {
        return this.formatHisto(Integer.MAX_VALUE);
    }

    public String formatHistoToCSV() {
        return this.formatHistoToCSV(Integer.MAX_VALUE);
    }

    public String formatHisto(int limit) {
        TextTable tt = new TextTable();
        ArrayList<String> row = new ArrayList<String>();
        row.add("Trc\t(%)");
        row.add("  Frm\t N  ");
        row.add("Term\t(%)");
        for (String name : this.conditionNames) {
            String cf = "  [\t" + name + "\t]";
            row.add(cf);
        }
        row.add("  Frame");
        tt.addRow(row);
        ArrayList<SiteInfo> h = new ArrayList<SiteInfo>(this.histo.values());
        Collections.sort(h, this.histoOrder);
        int n = 0;
        for (SiteInfo si : h) {
            row.clear();
            String traceN = "\t" + this.formatAbs(si.getOccurences()) + " " + this.formatPct(si.getOccurences(), this.traceCount);
            String frameN = "  \t" + this.formatAbs(si.getHitCount()) + "  ";
            String termN = "\t" + this.formatAbs(si.getTerminalCount()) + " " + this.formatPct(si.getTerminalCount(), this.traceCount);
            row.add(traceN);
            row.add(frameN);
            row.add(termN);
            for (String name : this.conditionNames) {
                String cf = "  \t" + si.getConditionalCount(name) + " " + this.formatPct(si.getConditionalCount(name), si.getOccurences());
                row.add(cf);
            }
            row.add("  " + si.getSite());
            tt.addRow(row);
            if (limit > ++n) continue;
            break;
        }
        return tt.formatTextTableUnbordered(200);
    }

    public String formatHistoToCSV(int limit) {
        TextTable tt = new TextTable();
        ArrayList<String> row = new ArrayList<String>();
        row.add("Trace N");
        row.add("Frame N");
        row.add("Terminal N");
        for (String name : this.conditionNames) {
            String cf = "[" + name + "]";
            row.add(cf);
        }
        row.add("Frame");
        tt.addRow(row);
        ArrayList<SiteInfo> h = new ArrayList<SiteInfo>(this.histo.values());
        Collections.sort(h, this.histoOrder);
        int n = 0;
        for (SiteInfo si : h) {
            row.clear();
            String traceN = "" + si.getOccurences();
            String frameN = "" + si.getHitCount();
            String termN = "" + si.getTerminalCount();
            row.add(traceN);
            row.add(frameN);
            row.add(termN);
            for (String name : this.conditionNames) {
                String cf = "" + si.getConditionalCount(name);
                row.add(cf);
            }
            row.add("" + si.getSite());
            tt.addRow(row);
            if (limit > ++n) continue;
            break;
        }
        return TextTable.formatCsv(tt);
    }

    private String formatPct(long num, long denom) {
        return String.format("%3d%%", 100L * num / denom);
    }

    private String formatAbs(long num) {
        return String.format("%d", num / this.calc.getDenominator());
    }

    private static class TerminalComparator
    implements Comparator<SiteInfo> {
        private TerminalComparator() {
        }

        @Override
        public int compare(SiteInfo o1, SiteInfo o2) {
            long term1 = o1.terminalCount;
            long term2 = o2.terminalCount;
            int c = Long.valueOf(term2).compareTo(term1);
            return c != 0 ? c : Long.valueOf(o2.occurences).compareTo(o1.occurences);
        }
    }

    private static class OccurenceComparator
    implements Comparator<SiteInfo> {
        private OccurenceComparator() {
        }

        @Override
        public int compare(SiteInfo o1, SiteInfo o2) {
            return Long.valueOf(o2.occurences).compareTo(o1.occurences);
        }
    }

    private static class HitComparator
    implements Comparator<SiteInfo> {
        private HitComparator() {
        }

        @Override
        public int compare(SiteInfo o1, SiteInfo o2) {
            return Long.valueOf(o2.hitCount).compareTo(o1.hitCount);
        }
    }

    public static class SiteInfo {
        StackFrame site;
        long hitCount;
        long occurences;
        long terminalCount;
        String[] conditionNames;
        long[] conditionalCounts;

        public StackFrame getSite() {
            return this.site;
        }

        public long getHitCount() {
            return this.hitCount;
        }

        public long getTerminalCount() {
            return this.terminalCount;
        }

        public long getOccurences() {
            return this.occurences;
        }

        public long getConditionalCount(String condition) {
            if (this.conditionNames == null) {
                return 0L;
            }
            for (int i = 0; i != this.conditionNames.length; ++i) {
                if (!condition.equals(this.conditionNames[i])) continue;
                return this.conditionalCounts[i];
            }
            return 0L;
        }
    }
}

