/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc.query;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hugegraph.HugeGraphSupplier;
import org.apache.hugegraph.backend.BackendColumn;
import org.apache.hugegraph.id.Id;
import org.apache.hugegraph.id.IdUtil;
import org.apache.hugegraph.rocksdb.access.RocksDBSession;
import org.apache.hugegraph.rocksdb.access.ScanIterator;
import org.apache.hugegraph.serializer.BinaryElementSerializer;
import org.apache.hugegraph.store.HgStoreEngine;
import org.apache.hugegraph.store.business.BusinessHandler;
import org.apache.hugegraph.store.business.BusinessHandlerImpl;
import org.apache.hugegraph.store.grpc.query.AggregateFunc;
import org.apache.hugegraph.store.grpc.query.AggregationType;
import org.apache.hugegraph.store.grpc.query.DeDupOption;
import org.apache.hugegraph.store.grpc.query.QueryRequest;
import org.apache.hugegraph.store.grpc.query.ScanType;
import org.apache.hugegraph.store.grpc.query.ScanTypeParam;
import org.apache.hugegraph.store.node.grpc.EmptyIterator;
import org.apache.hugegraph.store.node.grpc.query.QueryStage;
import org.apache.hugegraph.store.node.grpc.query.QueryStages;
import org.apache.hugegraph.store.node.grpc.query.QueryUtil;
import org.apache.hugegraph.store.node.grpc.query.model.QueryPlan;
import org.apache.hugegraph.store.query.QueryTypeParam;
import org.apache.hugegraph.store.query.Tuple2;
import org.apache.hugegraph.store.query.func.AggregationFunction;
import org.apache.hugegraph.store.query.func.AggregationFunctions;
import org.apache.hugegraph.structure.BaseElement;
import org.apache.hugegraph.structure.BaseVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class QueryUtil {
    private static final Logger log = LoggerFactory.getLogger(QueryUtil.class);
    public static final List<Object> EMPTY_AGG_KEY = new ArrayList();
    private static final Integer TOP_LIMIT = 10000;
    private static BusinessHandler handler;
    private static final BinaryElementSerializer serializer;
    private static final Set<String> vertexTables;

    public static QueryPlan buildPlan(QueryRequest request) {
        QueryPlan plan = new QueryPlan();
        if (request.getSampleFactor() == 0.0) {
            plan.addStage(QueryStages.ofStopStage());
            return plan;
        }
        if (request.getSampleFactor() < 1.0) {
            QueryStage sampleStage = QueryStages.ofSampleStage();
            sampleStage.init(new Object[]{request.getSampleFactor()});
            plan.addStage(sampleStage);
        }
        if (QueryUtil.isOnlyCountAggregationFunction((QueryRequest)request)) {
            QueryStage simple = QueryStages.ofSimpleCountStage();
            simple.init(new Object[]{request.getFunctionsList().size()});
            plan.addStage(simple);
        } else {
            if (request.getCheckTtl()) {
                QueryStage ttl = QueryStages.ofTtlCheckStage();
                ttl.init(new Object[]{QueryUtil.isVertex((String)request.getTable())});
                plan.addStage(ttl);
            }
            if (QueryUtil.needDeserialize((QueryRequest)request)) {
                QueryStage deserializeStage = QueryStages.ofDeserializationStage();
                deserializeStage.init(new Object[]{request.getTable(), BusinessHandlerImpl.getGraphSupplier((String)request.getGraph())});
                plan.addStage(deserializeStage);
            }
            if (!QueryUtil.isEmpty((Collection)request.getOlapPropertyList())) {
                QueryStage olap = QueryStages.ofOlapStage();
                olap.init(new Object[]{request.getGraph(), request.getTable(), request.getOlapPropertyList()});
                plan.addStage(olap);
            }
            if (!request.getCondition().isEmpty()) {
                QueryStage filterStage = QueryStages.ofFilterStage();
                filterStage.init(new Object[]{request.getCondition().toByteArray()});
                plan.addStage(filterStage);
            }
            if (!QueryUtil.isEmpty((Collection)request.getFunctionsList())) {
                QueryStage extractAggField = QueryStages.ofExtractAggFieldStage();
                ArrayList<ByteString> fields = new ArrayList<ByteString>();
                for (AggregateFunc func : request.getFunctionsList()) {
                    if (func.getFuncType() == AggregationType.COUNT) {
                        fields.add(null);
                        continue;
                    }
                    fields.add(func.getField());
                }
                extractAggField.init(new Object[]{request.getGroupByList(), fields, request.getGroupBySchemaLabel(), QueryUtil.isVertex((String)request.getTable())});
                plan.addStage(extractAggField);
            }
        }
        if (!QueryUtil.isEmpty((Collection)request.getFunctionsList())) {
            QueryStage agg = QueryStages.ofAggStage();
            ArrayList<Tuple2> funcMetas = new ArrayList<Tuple2>();
            for (AggregateFunc func : request.getFunctionsList()) {
                funcMetas.add(new Tuple2((Object)func.getFuncType(), (Object)func.getType()));
            }
            agg.init(new Object[]{funcMetas});
            plan.addStage(agg);
        }
        if (!QueryUtil.isEmpty((Collection)request.getPropertyList()) || request.getNullProperty()) {
            QueryStage selector = QueryStages.ofProjectionStage();
            selector.init(new Object[]{request.getPropertyList(), request.getNullProperty()});
            plan.addStage(selector);
        }
        if (QueryUtil.canOptimiseToTop((QueryRequest)request)) {
            QueryStage topStage = QueryStages.ofTopStage();
            topStage.init(new Object[]{request.getLimit(), request.getOrderByList(), request.getSortOrder()});
            plan.addStage(topStage);
        } else {
            if (!QueryUtil.isEmpty((Collection)request.getOrderByList())) {
                QueryStage order = QueryStages.ofOrderByStage();
                order.init(new Object[]{request.getOrderByList(), request.getGroupByList(), !QueryUtil.isEmpty((Collection)request.getFunctionsList()), request.getSortOrder()});
                plan.addStage(order);
            }
            if (request.getLimit() > 0) {
                QueryStage limit = QueryStages.ofLimitStage();
                limit.init(new Object[]{request.getLimit()});
                plan.addStage(limit);
            }
        }
        log.debug("query id: {} ,build plan result: {}", (Object)request.getQueryId(), (Object)plan);
        return plan;
    }

    private static boolean isOnlyCountAggregationFunction(QueryRequest request) {
        return !QueryUtil.isEmpty((Collection)request.getFunctionsList()) && request.getFunctionsList().stream().allMatch(f -> f.getFuncType() == AggregationType.COUNT) && QueryUtil.isEmpty((Collection)request.getGroupByList()) && request.getCondition().isEmpty() && !request.getGroupBySchemaLabel();
    }

    private static boolean canOptimiseToTop(QueryRequest request) {
        return !QueryUtil.isEmpty((Collection)request.getOrderByList()) && request.getLimit() < TOP_LIMIT && request.getLimit() > 0;
    }

    private static boolean needDeserialize(QueryRequest request) {
        return !QueryUtil.isEmpty((Collection)request.getOrderByList()) || !QueryUtil.isEmpty((Collection)request.getPropertyList()) || !request.getCondition().isEmpty() || !QueryUtil.isEmpty((Collection)request.getFunctionsList()) && !request.getGroupBySchemaLabel();
    }

    public static ScanIterator getIterator(QueryRequest request) {
        BusinessHandler handler = new QueryUtil().getHandler();
        switch (1.$SwitchMap$org$apache$hugegraph$store$grpc$query$ScanType[request.getScanType().ordinal()]) {
            case 1: {
                return handler.scanAll(request.getGraph(), request.getTable());
            }
            case 2: {
                return handler.scan(request.getGraph(), request.getTable(), QueryUtil.toQTP((List)request.getScanTypeParamList()), request.getDedupOption());
            }
            case 3: {
                return handler.scanIndex(request.getGraph(), request.getIndexesList().stream().map(x -> QueryUtil.toQTP((List)x.getParamsList())).collect(Collectors.toList()), request.getDedupOption(), request.getLoadPropertyFromIndex(), request.getCheckTtl());
            }
            case 4: {
                return handler.scanIndex(request.getGraph(), request.getTable(), request.getIndexesList().stream().map(x -> QueryUtil.toQTP((List)x.getParamsList())).collect(Collectors.toList()), request.getDedupOption(), true, QueryUtil.needIndexTransKey((QueryRequest)request), request.getCheckTtl(), request.getLimit());
            }
        }
        return new EmptyIterator();
    }

    private static boolean needIndexTransKey(QueryRequest request) {
        if (request.getScanType() == ScanType.NO_SCAN) {
            return !QueryUtil.isOnlyCountAggregationFunction((QueryRequest)request) && request.getDedupOption() == DeDupOption.NONE;
        }
        return true;
    }

    private static List<QueryTypeParam> toQTP(List<ScanTypeParam> range) {
        return range.stream().map(QueryUtil::fromScanTypeParam).collect(Collectors.toList());
    }

    private static QueryTypeParam fromScanTypeParam(ScanTypeParam param) {
        return new QueryTypeParam(param.getKeyStart().toByteArray(), param.getKeyEnd().toByteArray(), param.getScanBoundary(), param.getIsPrefix(), param.getIsSecondaryIndex(), param.getCode(), param.getIdPrefix().toByteArray());
    }

    public static <E> boolean isEmpty(Collection<E> c) {
        return c == null || c.size() == 0;
    }

    public static BaseElement parseEntry(HugeGraphSupplier graph, BackendColumn column, boolean isVertex) {
        if (isVertex) {
            return serializer.parseVertex(graph, column, null);
        }
        return serializer.parseEdge(graph, column, null, true);
    }

    public static BaseElement parseOlap(BackendColumn column, BaseVertex vertex) {
        return serializer.parseVertexOlap(null, column, vertex);
    }

    public static BackendColumn combineColumn(BackendColumn vertexColumn, List<BackendColumn> olap) {
        return serializer.mergeCols(vertexColumn, olap.toArray(new BackendColumn[0]));
    }

    public static AggregationFunction createFunc(AggregationType funcType, String genericType) {
        AggregationFunctions.CountFunction func = null;
        switch (1.$SwitchMap$org$apache$hugegraph$store$grpc$query$AggregationType[funcType.ordinal()]) {
            case 1: {
                func = new AggregationFunctions.AvgFunction(QueryUtil.getAggregationBufferSupplier((String)genericType));
                break;
            }
            case 2: {
                func = new AggregationFunctions.SumFunction(QueryUtil.getAggregationBufferSupplier((String)genericType));
                break;
            }
            case 3: {
                func = new AggregationFunctions.MaxFunction(QueryUtil.getAggregationBufferSupplier((String)genericType));
                break;
            }
            case 4: {
                func = new AggregationFunctions.MinFunction(QueryUtil.getAggregationBufferSupplier((String)genericType));
                break;
            }
            case 5: {
                func = new AggregationFunctions.CountFunction();
                break;
            }
        }
        return func;
    }

    public static Supplier getAggregationBufferSupplier(String genericType) {
        return AggregationFunctions.getAggregationBufferSupplier((String)genericType);
    }

    public static List<Id> fromStringBytes(List<ByteString> list) {
        return list.stream().map(id -> id == null ? null : IdUtil.fromBytes((byte[])id.toByteArray())).collect(Collectors.toList());
    }

    public static boolean isVertex(String table) {
        return vertexTables.contains(table);
    }

    public static Long getLabelId(RocksDBSession.BackendColumn column, boolean isVertex) {
        Id id = serializer.parseLabelFromCol(BackendColumn.of((byte[])column.name, (byte[])column.value), isVertex);
        return id.asLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BusinessHandler getHandler() {
        if (handler == null) {
            QueryUtil queryUtil = this;
            synchronized (queryUtil) {
                if (handler == null) {
                    handler = HgStoreEngine.getInstance().getBusinessHandler();
                }
            }
        }
        return handler;
    }

    static {
        serializer = new BinaryElementSerializer();
        vertexTables = new HashSet<String>(List.of("g+v", "g+olap", "g+task"));
    }
}

