/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.tagging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.SegmentationFactory;
import org.apdplat.word.segmentation.Word;
import org.apdplat.word.util.AutoDetector;
import org.apdplat.word.util.GenericTrie;
import org.apdplat.word.util.ResourceLoader;
import org.apdplat.word.util.WordConfTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynonymTagging {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynonymTagging.class);
    private static final GenericTrie<String[]> GENERIC_TRIE = new GenericTrie();

    private SynonymTagging() {
    }

    public static void reload() {
        AutoDetector.loadAndWatch(new ResourceLoader(){

            @Override
            public void clear() {
                GENERIC_TRIE.clear();
            }

            @Override
            public void load(List<String> list) {
                LOGGER.info("\u521d\u59cb\u5316Synonymy");
                int n = 0;
                for (String string : list) {
                    try {
                        String[] stringArray = string.split("\\s+");
                        if (stringArray != null && stringArray.length > 1) {
                            this.addWords(stringArray);
                            ++n;
                            continue;
                        }
                        LOGGER.error("\u9519\u8bef\u7684Synonymy\u6570\u636e\uff1a" + string);
                    }
                    catch (Exception exception) {
                        LOGGER.error("\u9519\u8bef\u7684Synonymy\u6570\u636e\uff1a" + string);
                    }
                }
                LOGGER.info("Synonymy\u521d\u59cb\u5316\u5b8c\u6bd5\uff0c\u6570\u636e\u6761\u6570\uff1a" + n);
            }

            @Override
            public void add(String string) {
                try {
                    String[] stringArray = string.split("\\s+");
                    if (stringArray != null && stringArray.length > 1) {
                        this.addWords(stringArray);
                    } else {
                        LOGGER.error("\u9519\u8bef\u7684Synonymy\u6570\u636e\uff1a" + string);
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("\u9519\u8bef\u7684Synonymy\u6570\u636e\uff1a" + string);
                }
            }

            @Override
            public void remove(String string) {
                try {
                    String[] stringArray = string.split("\\s+");
                    if (stringArray != null && stringArray.length > 1) {
                        for (String string2 : stringArray) {
                            GENERIC_TRIE.remove(string2.trim());
                        }
                    } else {
                        LOGGER.error("\u9519\u8bef\u7684Synonymy\u6570\u636e\uff1a" + string);
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("\u9519\u8bef\u7684Synonymy\u6570\u636e\uff1a" + string);
                }
            }

            private void addWords(String[] stringArray) {
                for (String string : stringArray) {
                    String[] stringArray2 = (String[])GENERIC_TRIE.get(string);
                    if (stringArray2 != null) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(string + " \u5df2\u7ecf\u6709\u5b58\u5728\u7684\u540c\u4e49\u8bcd\uff1a");
                            for (String string2 : stringArray2) {
                                LOGGER.debug("\t" + string2);
                            }
                        }
                        String[] stringArray3 = new HashSet();
                        stringArray3.addAll(Arrays.asList(stringArray2));
                        stringArray3.addAll(Arrays.asList(stringArray));
                        String[] stringArray4 = stringArray3.toArray(new String[0]);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("\u5408\u5e76\u65b0\u7684\u540c\u4e49\u8bcd\uff1a");
                            for (String string3 : stringArray) {
                                LOGGER.debug("\t" + string3);
                            }
                            LOGGER.debug("\u5408\u5e76\u7ed3\u679c\uff1a");
                            for (String string3 : stringArray4) {
                                LOGGER.debug("\t" + string3);
                            }
                        }
                        GENERIC_TRIE.put(string.trim(), stringArray4);
                        continue;
                    }
                    GENERIC_TRIE.put(string.trim(), stringArray);
                }
            }
        }, WordConfTools.get("word.synonym.path", "classpath:word_synonym.txt"));
    }

    public static void process(List<Word> list) {
        SynonymTagging.process(list, true);
    }

    public static void process(List<Word> list, boolean bl) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5bf9\u5206\u8bcd\u7ed3\u679c\u8fdb\u884c\u540c\u4e49\u6807\u6ce8\u4e4b\u524d\uff1a{}", list);
        }
        for (Word word : list) {
            if (bl) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("\u76f4\u63a5\u6a21\u5f0f");
                }
                SynonymTagging.processDirectSynonym(word);
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u95f4\u63a5\u63a5\u6a21\u5f0f");
            }
            SynonymTagging.processIndirectSynonym(word);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5bf9\u5206\u8bcd\u7ed3\u679c\u8fdb\u884c\u540c\u4e49\u6807\u6ce8\u4e4b\u540e\uff1a{}", list);
        }
    }

    private static void processDirectSynonym(Word word) {
        String[] stringArray = GENERIC_TRIE.get(word.getText());
        if (stringArray != null && stringArray.length > 1) {
            List<Word> list = SynonymTagging.toWord(stringArray);
            list.remove(word);
            word.setSynonym(list);
        }
    }

    private static void processIndirectSynonym(Word word) {
        ConcurrentSkipListSet<Word> concurrentSkipListSet = new ConcurrentSkipListSet<Word>();
        SynonymTagging.indirectSynonym(word, concurrentSkipListSet);
        if (!concurrentSkipListSet.isEmpty()) {
            concurrentSkipListSet.remove(word);
            word.setSynonym(new ArrayList<Word>(concurrentSkipListSet));
        }
    }

    private static void indirectSynonym(Word word, Set<Word> set) {
        String[] stringArray = GENERIC_TRIE.get(word.getText());
        if (stringArray != null && stringArray.length > 1) {
            int n = set.size();
            List<Word> list = SynonymTagging.toWord(stringArray);
            set.addAll(list);
            if (set.size() > n) {
                for (Word word2 : set) {
                    SynonymTagging.indirectSynonym(word2, set);
                }
            }
        }
    }

    private static List<Word> toWord(String[] stringArray) {
        ArrayList<Word> arrayList = new ArrayList<Word>(stringArray.length);
        for (String string : stringArray) {
            arrayList.add(new Word(string));
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        List<Word> list = SegmentationFactory.getSegmentation(SegmentationAlgorithm.BidirectionalMaximumMatching).seg("\u695a\u79bb\u964c\u5343\u65b9\u767e\u8ba1\u4e3a\u65e0\u60c5\u627e\u56de\u8bb0\u5fc6");
        System.out.println(list);
        SynonymTagging.process(list);
        System.out.println(list);
        SynonymTagging.process(list, false);
        System.out.println(list);
        list = SegmentationFactory.getSegmentation(SegmentationAlgorithm.BidirectionalMaximumMatching).seg("\u624b\u52b2\u5927\u7684\u8001\u4eba\u5f80\u5f80\u66f4\u957f\u5bff");
        System.out.println(list);
        SynonymTagging.process(list);
        System.out.println(list);
        SynonymTagging.process(list, false);
        System.out.println(list);
    }

    static {
        SynonymTagging.reload();
    }
}

