/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.StringJoiner;
import org.apache.baremaps.database.collection.DataMap;
import org.apache.baremaps.geocoder.GeocoderConstants;
import org.apache.baremaps.geocoderosm.GeocoderOsmConsumerEntity;
import org.apache.baremaps.openstreetmap.pbf.PbfEntityReader;
import org.apache.baremaps.openstreetmap.pbf.PbfReader;
import org.apache.baremaps.stream.StreamUtils;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.locationtech.jts.geom.Coordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateGeocoderOpenStreetMap
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(CreateGeocoderOpenStreetMap.class);
    private Path file;
    private Path indexDirectory;

    public CreateGeocoderOpenStreetMap() {
    }

    public CreateGeocoderOpenStreetMap(Path file, Path indexDirectory) {
        this.file = file;
        this.indexDirectory = indexDirectory;
    }

    @Override
    public void execute(WorkflowContext context) throws Exception {
        Path path = this.file.toAbsolutePath();
        DataMap<Long, Coordinate> coordinateMap = context.getCoordinateMap();
        DataMap<Long, List<Long>> referenceMap = context.getReferenceMap();
        FSDirectory directory = FSDirectory.open((Path)this.indexDirectory);
        IndexWriterConfig config = new IndexWriterConfig(GeocoderConstants.ANALYZER);
        try (IndexWriter indexWriter = new IndexWriter((Directory)directory, config);){
            GeocoderOsmConsumerEntity importer = new GeocoderOsmConsumerEntity(indexWriter);
            CreateGeocoderOpenStreetMap.execute(path, coordinateMap, referenceMap, importer);
        }
    }

    public static void execute(Path path, DataMap<Long, Coordinate> coordinateMap, DataMap<Long, List<Long>> referenceMap, GeocoderOsmConsumerEntity importer) throws IOException {
        PbfReader reader = ((PbfEntityReader)new PbfEntityReader().geometries(true).projection(4326).coordinateMap((DataMap)coordinateMap)).referenceMap((DataMap)referenceMap);
        try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
            StreamUtils.batch(((PbfEntityReader)reader).stream(input)).forEach(importer);
        }
    }

    public String toString() {
        return new StringJoiner(", ", CreateGeocoderOpenStreetMap.class.getSimpleName() + "[", "]").add("file=" + this.file).add("indexDirectory=" + this.indexDirectory).toString();
    }
}

