/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.annotation;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.server.ResponseConversionUtil;
import com.linecorp.armeria.internal.server.annotation.ClassUtil;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;

public final class StringResponseConverterFunction
implements ResponseConverterFunction {
    @Override
    public Boolean isResponseStreaming(Type resultType, @Nullable MediaType contentType) {
        if (contentType != null && contentType.is(MediaType.ANY_TEXT_TYPE)) {
            return false;
        }
        Class<?> clazz = ClassUtil.typeToClass(ClassUtil.unwrapUnaryAsyncType(resultType));
        if (clazz == null) {
            return null;
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return false;
        }
        return null;
    }

    @Override
    public HttpResponse convertResponse(ServiceRequestContext ctx, ResponseHeaders headers, @Nullable Object result, HttpHeaders trailers) throws Exception {
        MediaType mediaType = headers.contentType();
        if (mediaType != null) {
            if (mediaType.is(MediaType.ANY_TEXT_TYPE)) {
                Charset charset = mediaType.charset(ArmeriaHttpUtil.HTTP_DEFAULT_CONTENT_CHARSET);
                if (result instanceof Publisher) {
                    return ResponseConversionUtil.aggregateFrom((Publisher)result, headers, trailers, o -> StringResponseConverterFunction.toHttpData(o, charset), ctx);
                }
                if (result instanceof Stream) {
                    return ResponseConversionUtil.aggregateFrom((Stream)result, headers, trailers, o -> StringResponseConverterFunction.toHttpData(o, charset), ctx.blockingTaskExecutor());
                }
                return HttpResponse.of(headers, StringResponseConverterFunction.toHttpData(result, charset), trailers);
            }
        } else if (result instanceof CharSequence) {
            return HttpResponse.of(headers.toBuilder().contentType(MediaType.PLAIN_TEXT_UTF_8).build(), HttpData.ofUtf8(((CharSequence)result).toString()), trailers);
        }
        return (HttpResponse)ResponseConverterFunction.fallthrough();
    }

    private static HttpData toHttpData(@Nullable Object value, Charset charset) {
        if (value == null) {
            return HttpData.empty();
        }
        if (value instanceof Iterable) {
            StringBuilder sb = new StringBuilder();
            ((Iterable)value).forEach(v -> {
                if (v instanceof HttpData) {
                    sb.append(((HttpData)v).toString(charset));
                } else if (v instanceof byte[]) {
                    sb.append(new String((byte[])v, charset));
                } else {
                    sb.append(v);
                }
            });
            return HttpData.of(charset, sb);
        }
        if (value instanceof HttpData) {
            return (HttpData)value;
        }
        if (value instanceof byte[]) {
            return HttpData.wrap((byte[])value);
        }
        return HttpData.of(charset, String.valueOf(value));
    }
}

