/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.property;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GeoPackageJavaProperties {
    private static final Logger log = Logger.getLogger(GeoPackageJavaProperties.class.getName());
    private static Properties mProperties;

    public static String getProperty(String key) {
        return GeoPackageJavaProperties.getProperty(key, true);
    }

    public static synchronized String getProperty(String key, boolean required) {
        String value;
        if (mProperties == null) {
            mProperties = GeoPackageJavaProperties.initializeConfigurationProperties();
        }
        if ((value = mProperties.getProperty(key)) == null && required) {
            throw new RuntimeException("Property not found: " + key);
        }
        return value;
    }

    public static String getProperty(String base, String property) {
        return GeoPackageJavaProperties.getProperty(base, property, true);
    }

    public static synchronized String getProperty(String base, String property, boolean required) {
        return GeoPackageJavaProperties.getProperty(base + "." + property, required);
    }

    public static int getIntegerProperty(String key) {
        return GeoPackageJavaProperties.getIntegerProperty(key, true);
    }

    public static Integer getIntegerProperty(String key, boolean required) {
        Integer value = null;
        String stringValue = GeoPackageJavaProperties.getProperty(key, required);
        if (stringValue != null) {
            value = Integer.valueOf(stringValue);
        }
        return value;
    }

    public static int getIntegerProperty(String base, String property) {
        return GeoPackageJavaProperties.getIntegerProperty(base, property, true);
    }

    public static Integer getIntegerProperty(String base, String property, boolean required) {
        return GeoPackageJavaProperties.getIntegerProperty(base + "." + property, required);
    }

    public static float getFloatProperty(String key) {
        return GeoPackageJavaProperties.getFloatProperty(key, true).floatValue();
    }

    public static Float getFloatProperty(String key, boolean required) {
        Float value = null;
        String stringValue = GeoPackageJavaProperties.getProperty(key, required);
        if (stringValue != null) {
            value = Float.valueOf(stringValue);
        }
        return value;
    }

    public static float getFloatProperty(String base, String property) {
        return GeoPackageJavaProperties.getFloatProperty(base, property, true).floatValue();
    }

    public static Float getFloatProperty(String base, String property, boolean required) {
        return GeoPackageJavaProperties.getFloatProperty(base + "." + property, required);
    }

    public static boolean getBooleanProperty(String key) {
        return GeoPackageJavaProperties.getBooleanProperty(key, true);
    }

    public static Boolean getBooleanProperty(String key, boolean required) {
        Boolean value = null;
        String stringValue = GeoPackageJavaProperties.getProperty(key, required);
        if (stringValue != null) {
            value = Boolean.valueOf(stringValue);
        }
        return value;
    }

    public static boolean getBooleanProperty(String base, String property) {
        return GeoPackageJavaProperties.getBooleanProperty(base, property, true);
    }

    public static Boolean getBooleanProperty(String base, String property, boolean required) {
        return GeoPackageJavaProperties.getBooleanProperty(base + "." + property, required);
    }

    public static Color getColorProperty(String key) {
        return GeoPackageJavaProperties.getColorProperty(key, true);
    }

    public static Color getColorProperty(String key, boolean required) {
        Color value = null;
        String redProperty = key + ".red";
        String greenProperty = key + ".green";
        String blueProperty = key + ".blue";
        String alphaProperty = key + ".alpha";
        Integer red = GeoPackageJavaProperties.getIntegerProperty(redProperty, required);
        Integer green = GeoPackageJavaProperties.getIntegerProperty(greenProperty, required);
        Integer blue = GeoPackageJavaProperties.getIntegerProperty(blueProperty, required);
        Integer alpha = GeoPackageJavaProperties.getIntegerProperty(alphaProperty, required);
        if (red != null && green != null && blue != null && alpha != null) {
            value = new Color(red, green, blue, alpha);
        }
        return value;
    }

    public static Color getColorProperty(String base, String property) {
        return GeoPackageJavaProperties.getColorProperty(base, property, true);
    }

    public static Color getColorProperty(String base, String property, boolean required) {
        return GeoPackageJavaProperties.getColorProperty(base + "." + property, required);
    }

    private static Properties initializeConfigurationProperties() {
        Properties properties = new Properties();
        InputStream in = GeoPackageJavaProperties.class.getResourceAsStream("/geopackage-java.properties");
        if (in != null) {
            try {
                properties.load(in);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to load properties file: geopackage-java.properties", e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Failed to close properties file: geopackage-java.properties", e);
                }
            }
        } else {
            log.log(Level.SEVERE, "Failed to load properties, file not found: geopackage-java.properties");
        }
        return properties;
    }
}

