/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.optimizing.plan;

import java.util.Map;
import org.apache.amoro.ServerTableIdentifier;
import org.apache.amoro.config.OptimizingConfig;
import org.apache.amoro.optimizing.plan.AbstractOptimizingEvaluator;
import org.apache.amoro.optimizing.plan.MixedIcebergPartitionPlan;
import org.apache.amoro.optimizing.plan.PartitionEvaluator;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.TableSnapshot;
import org.apache.amoro.utils.TablePropertyUtil;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.util.Pair;

public class MixedIcebergOptimizingEvaluator
extends AbstractOptimizingEvaluator {
    public MixedIcebergOptimizingEvaluator(ServerTableIdentifier identifier, OptimizingConfig config, MixedTable table, TableSnapshot currentSnapshot, int maxPendingPartitions, long lastMinorOptimizingTime, long lastFullOptimizingTime) {
        super(identifier, config, table, currentSnapshot, maxPendingPartitions, lastMinorOptimizingTime, lastFullOptimizingTime);
    }

    protected Map<String, String> partitionProperties(Pair<Integer, StructLike> partition) {
        return TablePropertyUtil.getPartitionProperties(this.mixedTable, (StructLike)partition.second());
    }

    @Override
    protected PartitionEvaluator buildEvaluator(Pair<Integer, StructLike> partition) {
        Map<String, String> partitionProperties = this.partitionProperties(partition);
        return new MixedIcebergPartitionPlan.MixedIcebergPartitionEvaluator(this.identifier, this.config, partition, partitionProperties, System.currentTimeMillis(), this.mixedTable.isKeyedTable(), this.lastMinorOptimizingTime, this.lastFullOptimizingTime);
    }
}

