/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.manager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.amoro.resource.Resource;
import org.apache.amoro.resource.ResourceContainer;
import org.apache.amoro.resource.ResourceStatus;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.iceberg.util.PropertyUtil;

public abstract class AbstractResourceContainer
implements ResourceContainer {
    private String containerName;
    private Map<String, String> containerProperties;
    protected String amsHome;
    protected String amsOptimizingUrl;

    public String name() {
        return this.containerName;
    }

    public void init(String name, Map<String, String> containerProperties) {
        this.containerName = name;
        this.containerProperties = containerProperties;
        this.amsHome = containerProperties.get("ams-home");
        this.amsOptimizingUrl = containerProperties.get("ams-optimizing-uri");
        Preconditions.checkNotNull((Object)this.amsHome, (String)"Container Property: %s is required", (Object)"ams-home");
        Preconditions.checkNotNull((Object)this.amsOptimizingUrl, (String)"Container Property: %s is required", (Object)"ams-optimizing-uri");
    }

    public void requestResource(Resource resource) {
        Map<String, String> startupStats = this.doScaleOut(resource);
        resource.getProperties().putAll(startupStats);
    }

    protected abstract Map<String, String> doScaleOut(Resource var1);

    protected String getOptimizingUri(Map<String, String> resourceProperties) {
        String optimizingUrl = resourceProperties.getOrDefault("ams-optimizing-uri", null);
        if (StringUtils.isNotEmpty((CharSequence)optimizingUrl)) {
            return optimizingUrl;
        }
        return this.amsOptimizingUrl;
    }

    public Map<String, String> getContainerProperties() {
        return this.containerProperties;
    }

    protected String buildOptimizerStartupArgsString(Resource resource) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" -a ").append(this.getOptimizingUri(resource.getProperties())).append(" -p ").append(resource.getThreadCount()).append(" -g ").append(resource.getGroupName());
        if (resource.getProperties().containsKey("heart-beat-interval")) {
            stringBuilder.append(" -hb ").append((String)resource.getProperties().get("heart-beat-interval"));
        }
        if (PropertyUtil.propertyAsBoolean((Map)resource.getProperties(), (String)"extend-disk-storage", (boolean)false)) {
            stringBuilder.append(" -eds -dsp ").append(resource.getRequiredProperty("disk-storage-path"));
            if (resource.getProperties().containsKey("memory-storage-size")) {
                stringBuilder.append(" -msz ").append((String)resource.getProperties().get("memory-storage-size"));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)resource.getResourceId())) {
            stringBuilder.append(" -id ").append(resource.getResourceId());
        }
        return stringBuilder.toString();
    }

    protected List<String> exportSystemProperties() throws IOException {
        ArrayList<String> cmds = new ArrayList<String>();
        if (this.containerProperties != null) {
            for (Map.Entry<String, String> entry : this.containerProperties.entrySet()) {
                if (!entry.getKey().startsWith("export.")) continue;
                String exportPropertyName = entry.getKey().substring("export.".length());
                String exportValue = entry.getValue();
                cmds.add(String.format("export %s=%s", exportPropertyName, exportValue));
            }
        }
        return cmds;
    }

    public ResourceStatus getStatus(String resourceId) {
        return null;
    }
}

