/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.configuration;

import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.List;
import org.apache.ignite3.configuration.ConfigurationModule;
import org.apache.ignite3.configuration.SuperRootChange;
import org.apache.ignite3.configuration.annotation.ConfigurationType;
import org.apache.ignite3.internal.raft.configuration.DisruptorConfigurationSchema;
import org.apache.ignite3.internal.raft.configuration.EntryCountBudgetConfigurationSchema;
import org.apache.ignite3.internal.raft.configuration.RaftChange;
import org.apache.ignite3.internal.raft.configuration.RaftExtensionChange;
import org.apache.ignite3.internal.raft.configuration.RaftExtensionConfiguration;
import org.apache.ignite3.internal.raft.configuration.RaftExtensionConfigurationSchema;
import org.apache.ignite3.internal.raft.configuration.RaftExtensionView;
import org.apache.ignite3.internal.raft.configuration.RaftView;
import org.apache.ignite3.internal.raft.configuration.UnlimitedBudgetConfigurationSchema;

@AutoService(value={ConfigurationModule.class})
public class RaftConfigurationModule
implements ConfigurationModule {
    @Override
    public ConfigurationType type() {
        return ConfigurationType.LOCAL;
    }

    @Override
    public Collection<Class<?>> schemaExtensions() {
        return List.of(RaftExtensionConfigurationSchema.class);
    }

    @Override
    public Collection<Class<?>> polymorphicSchemaExtensions() {
        return List.of(UnlimitedBudgetConfigurationSchema.class, EntryCountBudgetConfigurationSchema.class);
    }

    @Override
    public void migrateDeprecatedConfigurations(SuperRootChange superRootChange) {
        RaftExtensionChange raftExtensionChange = superRootChange.changeRoot(RaftExtensionConfiguration.KEY);
        RaftExtensionView raftExtensionView = superRootChange.viewRoot(RaftExtensionConfiguration.KEY);
        RaftChange raftChange = raftExtensionChange.changeRaft();
        RaftView raftView = raftExtensionView.raft();
        RaftConfigurationModule.changeDisruptorStripesIfNeeded(raftView, raftChange);
        RaftConfigurationModule.changeDisruptorLogManagerStripesIfNeeded(raftView, raftChange);
    }

    private static void changeDisruptorStripesIfNeeded(RaftView view, RaftChange change) {
        int stripes = view.stripes();
        if (stripes != DisruptorConfigurationSchema.DEFAULT_STRIPES_COUNT) {
            change.changeDisruptor().changeStripes(stripes);
        }
    }

    private static void changeDisruptorLogManagerStripesIfNeeded(RaftView view, RaftChange change) {
        int logStripesCount = view.logStripesCount();
        if (logStripesCount != DisruptorConfigurationSchema.DEFAULT_LOG_MANAGER_STRIPES_COUNT) {
            change.changeDisruptor().changeLogManagerStripes(logStripesCount);
        }
    }
}

