/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.call.cluster.unit;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.ignite3.internal.cli.core.call.ProgressTracker;
import org.apache.ignite3.rest.client.invoker.ApiCallback;
import org.apache.ignite3.rest.client.invoker.ApiException;

public class TrackingCallback<T>
implements ApiCallback<T> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final ProgressTracker tracker;
    private Exception exception;

    TrackingCallback(ProgressTracker tracker) {
        this.tracker = tracker;
    }

    public void awaitDone() throws InterruptedException {
        this.latch.await();
    }

    public Exception exception() {
        return this.exception;
    }

    @Override
    public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
        this.exception = e;
        this.latch.countDown();
    }

    @Override
    public void onSuccess(T result, int statusCode, Map<String, List<String>> responseHeaders) {
        this.latch.countDown();
    }

    @Override
    public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
        if (done) {
            this.tracker.done();
        }
        this.tracker.maxSize(contentLength);
        this.tracker.track(bytesWritten);
    }

    @Override
    public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
    }
}

