/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.security.authentication;

import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.ignite.configuration.ConfigurationModule;
import org.apache.ignite.configuration.SuperRootChange;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.configuration.ClusterConfiguration;
import org.apache.ignite.internal.security.authentication.basic.BasicAuthenticationProviderChange;
import org.apache.ignite.internal.security.authentication.basic.BasicAuthenticationProviderConfigurationSchema;
import org.apache.ignite.internal.security.authentication.validator.AuthenticationProvidersValidatorImpl;
import org.apache.ignite.internal.security.configuration.SecurityExtensionChange;
import org.apache.ignite.internal.security.configuration.SecurityExtensionConfigurationSchema;

@AutoService(value={ConfigurationModule.class})
public class SecurityConfigurationModule
implements ConfigurationModule {
    static final String DEFAULT_PROVIDER_NAME = "default";
    static final String DEFAULT_USERNAME = "ignite";
    static final String DEFAULT_PASSWORD = "ignite";

    public ConfigurationType type() {
        return ConfigurationType.DISTRIBUTED;
    }

    public Set<Validator<?, ?>> validators() {
        return Set.of(AuthenticationProvidersValidatorImpl.INSTANCE);
    }

    public Collection<Class<?>> schemaExtensions() {
        return List.of(SecurityExtensionConfigurationSchema.class);
    }

    public Collection<Class<?>> polymorphicSchemaExtensions() {
        return Collections.singleton(BasicAuthenticationProviderConfigurationSchema.class);
    }

    public void patchConfigurationWithDynamicDefaults(SuperRootChange rootChange) {
        SecurityExtensionChange securityExtensionChange = (SecurityExtensionChange)rootChange.changeRoot(ClusterConfiguration.KEY);
        securityExtensionChange.changeSecurity().changeAuthentication().changeProviders(providersChange -> {
            if (providersChange.isEmpty()) {
                providersChange.create(DEFAULT_PROVIDER_NAME, change -> ((BasicAuthenticationProviderChange)change.convert(BasicAuthenticationProviderChange.class)).changeUsers().create("ignite", user -> user.changePassword("ignite")));
            }
        });
    }
}

