/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.replicator.message.TablePartitionIdMessage;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.message.TxStateMetaAbandonedMessage;
import org.apache.ignite.internal.tx.message.TxStateMetaAbandonedMessageBuilder;
import org.apache.ignite.internal.tx.message.TxStateMetaAbandonedMessageSerializer;

public class TxStateMetaAbandonedMessageImpl
implements TxStateMetaAbandonedMessage,
Cloneable {
    public static final short GROUP_TYPE = 5;
    public static final short TYPE = 16;
    @IgniteToStringInclude
    private final Long cleanupCompletionTimestamp;
    @IgniteToStringInclude
    private final TablePartitionIdMessage commitPartitionId;
    @IgniteToStringInclude
    private final HybridTimestamp commitTimestamp;
    @IgniteToStringInclude
    private final Long initialVacuumObservationTimestamp;
    @IgniteToStringInclude
    private final long lastAbandonedMarkerTs;
    @IgniteToStringInclude
    private final UUID txCoordinatorId;
    @IgniteToStringInclude
    private final TxState txState;

    private TxStateMetaAbandonedMessageImpl(Long cleanupCompletionTimestamp, TablePartitionIdMessage commitPartitionId, HybridTimestamp commitTimestamp, Long initialVacuumObservationTimestamp, long lastAbandonedMarkerTs, UUID txCoordinatorId, TxState txState) {
        this.cleanupCompletionTimestamp = cleanupCompletionTimestamp;
        this.commitPartitionId = commitPartitionId;
        this.commitTimestamp = commitTimestamp;
        this.initialVacuumObservationTimestamp = initialVacuumObservationTimestamp;
        this.lastAbandonedMarkerTs = lastAbandonedMarkerTs;
        this.txCoordinatorId = txCoordinatorId;
        this.txState = txState;
    }

    @Override
    public Long cleanupCompletionTimestamp() {
        return this.cleanupCompletionTimestamp;
    }

    @Override
    public TablePartitionIdMessage commitPartitionId() {
        return this.commitPartitionId;
    }

    @Override
    public HybridTimestamp commitTimestamp() {
        return this.commitTimestamp;
    }

    @Override
    public Long initialVacuumObservationTimestamp() {
        return this.initialVacuumObservationTimestamp;
    }

    @Override
    public long lastAbandonedMarkerTs() {
        return this.lastAbandonedMarkerTs;
    }

    @Override
    public UUID txCoordinatorId() {
        return this.txCoordinatorId;
    }

    @Override
    public TxState txState() {
        return this.txState;
    }

    public MessageSerializer serializer() {
        return TxStateMetaAbandonedMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 5;
    }

    public String toString() {
        return S.toString(TxStateMetaAbandonedMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 16;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TxStateMetaAbandonedMessageImpl otherMessage = (TxStateMetaAbandonedMessageImpl)other;
        return Objects.equals(this.cleanupCompletionTimestamp, otherMessage.cleanupCompletionTimestamp) && Objects.equals(this.commitPartitionId, otherMessage.commitPartitionId) && Objects.equals(this.commitTimestamp, otherMessage.commitTimestamp) && Objects.equals(this.initialVacuumObservationTimestamp, otherMessage.initialVacuumObservationTimestamp) && Objects.equals(this.txCoordinatorId, otherMessage.txCoordinatorId) && Objects.equals((Object)this.txState, (Object)otherMessage.txState) && this.lastAbandonedMarkerTs == otherMessage.lastAbandonedMarkerTs;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(new Object[]{this.lastAbandonedMarkerTs, this.cleanupCompletionTimestamp, this.commitPartitionId, this.commitTimestamp, this.initialVacuumObservationTimestamp, this.txCoordinatorId, this.txState});
        return result;
    }

    public TxStateMetaAbandonedMessageImpl clone() {
        try {
            return (TxStateMetaAbandonedMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static TxStateMetaAbandonedMessageBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.commitPartitionId != null) {
            this.commitPartitionId.prepareMarshal(usedDescriptors, (Object)marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.commitPartitionId != null) {
            this.commitPartitionId.unmarshal((Object)marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements TxStateMetaAbandonedMessageBuilder {
        private Long cleanupCompletionTimestamp;
        private TablePartitionIdMessage commitPartitionId;
        private HybridTimestamp commitTimestamp;
        private Long initialVacuumObservationTimestamp;
        private long lastAbandonedMarkerTs;
        private UUID txCoordinatorId;
        private TxState txState;

        private Builder() {
        }

        @Override
        public TxStateMetaAbandonedMessageBuilder cleanupCompletionTimestamp(Long cleanupCompletionTimestamp) {
            this.cleanupCompletionTimestamp = cleanupCompletionTimestamp;
            return this;
        }

        @Override
        public TxStateMetaAbandonedMessageBuilder commitPartitionId(TablePartitionIdMessage commitPartitionId) {
            this.commitPartitionId = commitPartitionId;
            return this;
        }

        @Override
        public TxStateMetaAbandonedMessageBuilder commitTimestamp(HybridTimestamp commitTimestamp) {
            this.commitTimestamp = commitTimestamp;
            return this;
        }

        @Override
        public TxStateMetaAbandonedMessageBuilder initialVacuumObservationTimestamp(Long initialVacuumObservationTimestamp) {
            this.initialVacuumObservationTimestamp = initialVacuumObservationTimestamp;
            return this;
        }

        @Override
        public TxStateMetaAbandonedMessageBuilder lastAbandonedMarkerTs(long lastAbandonedMarkerTs) {
            this.lastAbandonedMarkerTs = lastAbandonedMarkerTs;
            return this;
        }

        @Override
        public TxStateMetaAbandonedMessageBuilder txCoordinatorId(UUID txCoordinatorId) {
            this.txCoordinatorId = txCoordinatorId;
            return this;
        }

        @Override
        public TxStateMetaAbandonedMessageBuilder txState(TxState txState) {
            Objects.requireNonNull(txState, "txState is not marked @Nullable");
            this.txState = txState;
            return this;
        }

        @Override
        public Long cleanupCompletionTimestamp() {
            return this.cleanupCompletionTimestamp;
        }

        @Override
        public TablePartitionIdMessage commitPartitionId() {
            return this.commitPartitionId;
        }

        @Override
        public HybridTimestamp commitTimestamp() {
            return this.commitTimestamp;
        }

        @Override
        public Long initialVacuumObservationTimestamp() {
            return this.initialVacuumObservationTimestamp;
        }

        @Override
        public long lastAbandonedMarkerTs() {
            return this.lastAbandonedMarkerTs;
        }

        @Override
        public UUID txCoordinatorId() {
            return this.txCoordinatorId;
        }

        @Override
        public TxState txState() {
            return this.txState;
        }

        @Override
        public TxStateMetaAbandonedMessage build() {
            return new TxStateMetaAbandonedMessageImpl(this.cleanupCompletionTimestamp, this.commitPartitionId, this.commitTimestamp, this.initialVacuumObservationTimestamp, this.lastAbandonedMarkerTs, this.txCoordinatorId, Objects.requireNonNull(this.txState, "txState is not marked @Nullable"));
        }
    }
}

