/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.entity;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.raft.jraft.conf.Configuration;
import org.apache.ignite.raft.jraft.entity.PeerId;

public class Ballot {
    private final List<UnfoundPeerId> peers = new ArrayList<UnfoundPeerId>();
    private int quorum;
    private final List<UnfoundPeerId> oldPeers = new ArrayList<UnfoundPeerId>();
    private int oldQuorum;

    public void init(Configuration conf, Configuration oldConf) {
        this.peers.clear();
        this.oldPeers.clear();
        this.oldQuorum = 0;
        this.quorum = 0;
        int index = 0;
        if (conf != null) {
            for (PeerId peer : conf) {
                this.peers.add(new UnfoundPeerId(peer, index++, false));
            }
        }
        this.quorum = this.peers.size() / 2 + 1;
        if (oldConf == null) {
            return;
        }
        index = 0;
        for (PeerId peer : oldConf) {
            this.oldPeers.add(new UnfoundPeerId(peer, index++, false));
        }
        this.oldQuorum = this.oldPeers.size() / 2 + 1;
    }

    private UnfoundPeerId findPeer(PeerId peerId, List<UnfoundPeerId> peers, int posHint) {
        if (posHint < 0 || posHint >= peers.size() || !peers.get((int)posHint).peerId.equals(peerId)) {
            for (UnfoundPeerId ufp : peers) {
                if (!ufp.peerId.equals(peerId)) continue;
                return ufp;
            }
            return null;
        }
        return peers.get(posHint);
    }

    public PosHint grant(PeerId peerId, PosHint hint) {
        UnfoundPeerId peer = this.findPeer(peerId, this.peers, hint.pos0);
        if (peer != null) {
            if (!peer.found) {
                peer.found = true;
                --this.quorum;
            }
            hint.pos0 = peer.index;
        } else {
            hint.pos0 = -1;
        }
        if (this.oldPeers.isEmpty()) {
            hint.pos1 = -1;
            return hint;
        }
        peer = this.findPeer(peerId, this.oldPeers, hint.pos1);
        if (peer != null) {
            if (!peer.found) {
                peer.found = true;
                --this.oldQuorum;
            }
            hint.pos1 = peer.index;
        } else {
            hint.pos1 = -1;
        }
        return hint;
    }

    public void grant(PeerId peerId) {
        this.grant(peerId, new PosHint());
    }

    public boolean isGranted() {
        return this.quorum <= 0 && this.oldQuorum <= 0;
    }

    public static class UnfoundPeerId {
        PeerId peerId;
        boolean found;
        int index;

        public UnfoundPeerId(PeerId peerId, int index, boolean found) {
            this.peerId = peerId;
            this.index = index;
            this.found = found;
        }
    }

    public static final class PosHint {
        int pos0 = -1;
        int pos1 = -1;
    }
}

