/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.SqlWriterConfig;
import org.apache.calcite.sql.dialect.AnsiSqlDialect;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlParser;
import org.apache.ignite.internal.sql.engine.sql.ParsedResult;
import org.apache.ignite.internal.sql.engine.sql.ParserService;
import org.apache.ignite.internal.sql.engine.sql.ScriptParseResult;
import org.apache.ignite.internal.sql.engine.sql.StatementParseResult;
import org.apache.ignite.internal.sql.engine.util.Commons;

public class ParserServiceImpl
implements ParserService {
    private static final SqlWriterConfig NORMALIZED_SQL_WRITER_CONFIG = SqlPrettyWriter.config().withDialect(AnsiSqlDialect.DEFAULT).withAlwaysUseParentheses(false).withSelectListItemsOnSeparateLines(false).withUpdateSetListNewline(false).withIndentation(0);

    @Override
    public ParsedResult parse(String query) {
        StatementParseResult parsedStatement = IgniteSqlParser.parse(query, StatementParseResult.MODE);
        SqlNode parsedTree = parsedStatement.statement();
        SqlQueryType queryType = Commons.getQueryType(parsedTree);
        SqlPrettyWriter w = new SqlPrettyWriter(NORMALIZED_SQL_WRITER_CONFIG);
        parsedTree.unparse((SqlWriter)w, 0, 0);
        String normalizedQuery = w.toString();
        assert (queryType != null) : normalizedQuery;
        AtomicReference<SqlNode> holder = new AtomicReference<SqlNode>(parsedTree);
        ParsedResultImpl result = new ParsedResultImpl(queryType, query, normalizedQuery, parsedStatement.dynamicParamsCount(), () -> {
            SqlNode ast = holder.getAndSet(null);
            if (ast != null) {
                return ast;
            }
            return IgniteSqlParser.parse(query, StatementParseResult.MODE).statement();
        });
        return result;
    }

    @Override
    public List<ParsedResult> parseScript(String query) {
        ScriptParseResult parsedStatement = IgniteSqlParser.parse(query, ScriptParseResult.MODE);
        ArrayList<ParsedResult> results = new ArrayList<ParsedResult>(parsedStatement.results().size());
        for (StatementParseResult result : parsedStatement.results()) {
            SqlNode parsedTree = result.statement();
            SqlQueryType queryType = Commons.getQueryType(parsedTree);
            String normalizedQuery = parsedTree.toString();
            assert (queryType != null) : normalizedQuery;
            results.add(new ParsedResultImpl(queryType, normalizedQuery, normalizedQuery, result.dynamicParamsCount(), () -> parsedTree));
        }
        return results;
    }

    static class ParsedResultImpl
    implements ParsedResult {
        private final SqlQueryType queryType;
        private final String originalQuery;
        private final String normalizedQuery;
        private final int dynamicParamCount;
        private final Supplier<SqlNode> parsedTreeSupplier;

        private ParsedResultImpl(SqlQueryType queryType, String originalQuery, String normalizedQuery, int dynamicParamCount, Supplier<SqlNode> parsedTreeSupplier) {
            this.queryType = queryType;
            this.originalQuery = originalQuery;
            this.normalizedQuery = normalizedQuery;
            this.dynamicParamCount = dynamicParamCount;
            this.parsedTreeSupplier = parsedTreeSupplier;
        }

        @Override
        public SqlQueryType queryType() {
            return this.queryType;
        }

        @Override
        public String originalQuery() {
            return this.originalQuery;
        }

        @Override
        public String normalizedQuery() {
            return this.normalizedQuery;
        }

        @Override
        public int dynamicParamsCount() {
            return this.dynamicParamCount;
        }

        @Override
        public SqlNode parsedTree() {
            return this.parsedTreeSupplier.get();
        }
    }
}

