/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.server;

import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.server.AbstractSimpleCondition;

public class RevisionCondition
extends AbstractSimpleCondition {
    private final Type type;
    private final long rev;

    public RevisionCondition(Type type, byte[] key, long rev) {
        super(key);
        assert (rev > 0L) : "Revision must be positive.";
        this.type = type;
        this.rev = rev;
    }

    @Override
    public boolean test(Entry e) {
        int res = Long.compare(e.revision(), this.rev);
        return this.type.test(res);
    }

    public static enum Type {
        EQUAL{

            @Override
            public boolean test(long res) {
                return res == 0L;
            }
        }
        ,
        NOT_EQUAL{

            @Override
            public boolean test(long res) {
                return res != 0L;
            }
        }
        ,
        GREATER{

            @Override
            public boolean test(long res) {
                return res > 0L;
            }
        }
        ,
        LESS{

            @Override
            public boolean test(long res) {
                return res < 0L;
            }
        }
        ,
        LESS_OR_EQUAL{

            @Override
            public boolean test(long res) {
                return res <= 0L;
            }
        }
        ,
        GREATER_OR_EQUAL{

            @Override
            public boolean test(long res) {
                return res >= 0L;
            }
        };


        public abstract boolean test(long var1);
    }
}

