/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Deque;
import java.util.List;
import java.util.function.BiPredicate;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.Node;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public abstract class NestedLoopJoinNode<RowT>
extends AbstractNode<RowT> {
    protected static final int NOT_WAITING = -1;
    protected final BiPredicate<RowT, RowT> cond;
    protected final RowHandler<RowT> handler;
    protected int requested;
    protected int waitingLeft;
    protected int waitingRight;
    protected final List<RowT> rightMaterialized = new ArrayList<RowT>(512);
    protected final Deque<RowT> leftInBuf = new ArrayDeque<RowT>(512);
    protected boolean inLoop;

    private NestedLoopJoinNode(ExecutionContext<RowT> ctx, RelDataType rowType, BiPredicate<RowT, RowT> cond) {
        super(ctx, rowType);
        this.cond = cond;
        this.handler = ctx.rowHandler();
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!CollectionUtils.nullOrEmpty(this.sources()) && this.sources().size() == 2);
        assert (rowsCnt > 0 && this.requested == 0);
        this.checkState();
        this.requested = rowsCnt;
        if (!this.inLoop) {
            this.context().execute(this::doJoin, this::onError);
        }
    }

    private void doJoin() throws Exception {
        this.checkState();
        this.join();
    }

    @Override
    protected void rewindInternal() {
        this.requested = 0;
        this.waitingLeft = 0;
        this.waitingRight = 0;
        this.rightMaterialized.clear();
        this.leftInBuf.clear();
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        if (idx == 0) {
            return new Downstream<RowT>(){

                @Override
                public void push(RowT row) throws Exception {
                    NestedLoopJoinNode.this.pushLeft(row);
                }

                @Override
                public void end() throws Exception {
                    NestedLoopJoinNode.this.endLeft();
                }

                @Override
                public void onError(Throwable e) {
                    NestedLoopJoinNode.this.onError(e);
                }
            };
        }
        if (idx == 1) {
            return new Downstream<RowT>(){

                @Override
                public void push(RowT row) throws Exception {
                    NestedLoopJoinNode.this.pushRight(row);
                }

                @Override
                public void end() throws Exception {
                    NestedLoopJoinNode.this.endRight();
                }

                @Override
                public void onError(Throwable e) {
                    NestedLoopJoinNode.this.onError(e);
                }
            };
        }
        throw new IndexOutOfBoundsException();
    }

    private void pushLeft(RowT row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waitingLeft > 0);
        this.checkState();
        --this.waitingLeft;
        this.leftInBuf.add(row);
        this.join();
    }

    private void pushRight(RowT row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waitingRight > 0);
        this.checkState();
        --this.waitingRight;
        this.rightMaterialized.add(row);
        if (this.waitingRight == 0) {
            this.waitingRight = 512;
            this.rightSource().request(512);
        }
    }

    private void endLeft() throws Exception {
        assert (this.downstream() != null);
        assert (this.waitingLeft > 0);
        this.checkState();
        this.waitingLeft = -1;
        this.join();
    }

    private void endRight() throws Exception {
        assert (this.downstream() != null);
        assert (this.waitingRight > 0);
        this.checkState();
        this.waitingRight = -1;
        this.join();
    }

    protected Node<RowT> leftSource() {
        return this.sources().get(0);
    }

    protected Node<RowT> rightSource() {
        return this.sources().get(1);
    }

    protected abstract void join() throws Exception;

    @NotNull
    public static <RowT> NestedLoopJoinNode<RowT> create(ExecutionContext<RowT> ctx, RelDataType outputRowType, RelDataType leftRowType, RelDataType rightRowType, JoinRelType joinType, BiPredicate<RowT, RowT> cond) {
        switch (joinType) {
            case INNER: {
                return new InnerJoin<RowT>(ctx, outputRowType, cond);
            }
            case LEFT: {
                RowHandler.RowFactory<RowT> rightRowFactory = ctx.rowHandler().factory(ctx.getTypeFactory(), rightRowType);
                return new LeftJoin<RowT>(ctx, outputRowType, cond, rightRowFactory);
            }
            case RIGHT: {
                RowHandler.RowFactory<RowT> leftRowFactory = ctx.rowHandler().factory(ctx.getTypeFactory(), leftRowType);
                return new RightJoin<RowT>(ctx, outputRowType, cond, leftRowFactory);
            }
            case FULL: {
                RowHandler.RowFactory<RowT> leftRowFactory = ctx.rowHandler().factory(ctx.getTypeFactory(), leftRowType);
                RowHandler.RowFactory<RowT> rightRowFactory = ctx.rowHandler().factory(ctx.getTypeFactory(), rightRowType);
                return new FullOuterJoin<RowT>(ctx, outputRowType, cond, leftRowFactory, rightRowFactory);
            }
            case SEMI: {
                return new SemiJoin<RowT>(ctx, outputRowType, cond);
            }
            case ANTI: {
                return new AntiJoin<RowT>(ctx, outputRowType, cond);
            }
        }
        throw new IllegalStateException("Join type \"" + joinType + "\" is not supported yet");
    }

    private static class AntiJoin<RowT>
    extends NestedLoopJoinNode<RowT> {
        private RowT left;
        private int rightIdx;

        private AntiJoin(ExecutionContext<RowT> ctx, RelDataType rowType, BiPredicate<RowT, RowT> cond) {
            super(ctx, rowType, cond);
        }

        @Override
        protected void rewindInternal() {
            this.left = null;
            this.rightIdx = 0;
            super.rewindInternal();
        }

        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                this.inLoop = true;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        if (this.left == null) {
                            this.left = this.leftInBuf.remove();
                        }
                        boolean matched = false;
                        while (!matched && this.rightIdx < this.rightMaterialized.size()) {
                            this.checkState();
                            if (!this.cond.test(this.left, this.rightMaterialized.get(this.rightIdx++))) continue;
                            matched = true;
                        }
                        if (!matched) {
                            --this.requested;
                            this.downstream().push(this.left);
                        }
                        this.left = null;
                        this.rightIdx = 0;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            if (this.waitingRight == 0) {
                this.waitingRight = 512;
                this.rightSource().request(512);
            }
            if (this.waitingLeft == 0 && this.leftInBuf.isEmpty()) {
                this.waitingLeft = 512;
                this.leftSource().request(512);
            }
            if (this.requested > 0 && this.waitingLeft == -1 && this.waitingRight == -1 && this.left == null && this.leftInBuf.isEmpty()) {
                this.requested = 0;
                this.downstream().end();
            }
        }
    }

    private static class SemiJoin<RowT>
    extends NestedLoopJoinNode<RowT> {
        private RowT left;
        private int rightIdx;

        private SemiJoin(ExecutionContext<RowT> ctx, RelDataType rowType, BiPredicate<RowT, RowT> cond) {
            super(ctx, rowType, cond);
        }

        @Override
        protected void rewindInternal() {
            this.left = null;
            this.rightIdx = 0;
            super.rewindInternal();
        }

        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                    if (this.left == null) {
                        this.left = this.leftInBuf.remove();
                    }
                    boolean matched = false;
                    while (!matched && this.requested > 0 && this.rightIdx < this.rightMaterialized.size()) {
                        this.checkState();
                        if (!this.cond.test(this.left, this.rightMaterialized.get(this.rightIdx++))) continue;
                        --this.requested;
                        this.downstream().push(this.left);
                        matched = true;
                    }
                    if (!matched && this.rightIdx != this.rightMaterialized.size()) continue;
                    this.left = null;
                    this.rightIdx = 0;
                }
            }
            if (this.waitingRight == 0) {
                this.waitingRight = 512;
                this.rightSource().request(512);
            }
            if (this.waitingLeft == 0 && this.leftInBuf.isEmpty()) {
                this.waitingLeft = 512;
                this.leftSource().request(512);
            }
            if (this.requested > 0 && this.waitingLeft == -1 && this.waitingRight == -1 && this.left == null && this.leftInBuf.isEmpty()) {
                this.downstream().end();
                this.requested = 0;
            }
        }
    }

    private static class FullOuterJoin<RowT>
    extends NestedLoopJoinNode<RowT> {
        private final RowHandler.RowFactory<RowT> leftRowFactory;
        private final RowHandler.RowFactory<RowT> rightRowFactory;
        private boolean leftMatched;
        private BitSet rightNotMatchedIndexes;
        private int lastPushedInd;
        private RowT left;
        private int rightIdx;

        private FullOuterJoin(ExecutionContext<RowT> ctx, RelDataType rowType, BiPredicate<RowT, RowT> cond, RowHandler.RowFactory<RowT> leftRowFactory, RowHandler.RowFactory<RowT> rightRowFactory) {
            super(ctx, rowType, cond);
            this.leftRowFactory = leftRowFactory;
            this.rightRowFactory = rightRowFactory;
        }

        @Override
        protected void rewindInternal() {
            this.left = null;
            this.leftMatched = false;
            this.rightNotMatchedIndexes.clear();
            this.lastPushedInd = 0;
            this.rightIdx = 0;
            super.rewindInternal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                if (this.rightNotMatchedIndexes == null) {
                    this.rightNotMatchedIndexes = new BitSet(this.rightMaterialized.size());
                    this.rightNotMatchedIndexes.set(0, this.rightMaterialized.size());
                }
                this.inLoop = true;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        if (this.left == null) {
                            this.left = this.leftInBuf.remove();
                            this.leftMatched = false;
                        }
                        while (this.requested > 0 && this.rightIdx < this.rightMaterialized.size()) {
                            this.checkState();
                            Object right = this.rightMaterialized.get(this.rightIdx++);
                            if (!this.cond.test(this.left, right)) continue;
                            --this.requested;
                            this.leftMatched = true;
                            this.rightNotMatchedIndexes.clear(this.rightIdx - 1);
                            RowT joined = this.handler.concat(this.left, right);
                            this.downstream().push(joined);
                        }
                        if (this.rightIdx != this.rightMaterialized.size()) continue;
                        boolean wasPushed = false;
                        if (!this.leftMatched && this.requested > 0) {
                            --this.requested;
                            wasPushed = true;
                            this.downstream().push(this.handler.concat(this.left, this.rightRowFactory.create()));
                        }
                        if (!this.leftMatched && !wasPushed) continue;
                        this.left = null;
                        this.rightIdx = 0;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            if (this.waitingLeft == -1 && this.requested > 0 && this.rightNotMatchedIndexes != null && !this.rightNotMatchedIndexes.isEmpty()) {
                assert (this.lastPushedInd >= 0);
                this.inLoop = true;
                try {
                    this.lastPushedInd = this.rightNotMatchedIndexes.nextSetBit(this.lastPushedInd);
                    while (true) {
                        this.checkState();
                        if (this.lastPushedInd < 0) {
                            break;
                        }
                        RowT row = this.handler.concat(this.leftRowFactory.create(), this.rightMaterialized.get(this.lastPushedInd));
                        this.rightNotMatchedIndexes.clear(this.lastPushedInd);
                        --this.requested;
                        this.downstream().push(row);
                        if (this.lastPushedInd == Integer.MAX_VALUE) break;
                        if (this.requested <= 0) {
                            break;
                        }
                        this.lastPushedInd = this.rightNotMatchedIndexes.nextSetBit(this.lastPushedInd + 1);
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            if (this.waitingRight == 0) {
                this.waitingRight = 512;
                this.rightSource().request(512);
            }
            if (this.waitingLeft == 0 && this.leftInBuf.isEmpty()) {
                this.waitingLeft = 512;
                this.leftSource().request(512);
            }
            if (this.requested > 0 && this.waitingLeft == -1 && this.waitingRight == -1 && this.left == null && this.leftInBuf.isEmpty() && this.rightNotMatchedIndexes.isEmpty()) {
                this.requested = 0;
                this.downstream().end();
            }
        }
    }

    private static class RightJoin<RowT>
    extends NestedLoopJoinNode<RowT> {
        private final RowHandler.RowFactory<RowT> leftRowFactory;
        private BitSet rightNotMatchedIndexes;
        private int lastPushedInd;
        private RowT left;
        private int rightIdx;

        private RightJoin(ExecutionContext<RowT> ctx, RelDataType rowType, BiPredicate<RowT, RowT> cond, RowHandler.RowFactory<RowT> leftRowFactory) {
            super(ctx, rowType, cond);
            this.leftRowFactory = leftRowFactory;
        }

        @Override
        protected void rewindInternal() {
            this.left = null;
            this.rightNotMatchedIndexes.clear();
            this.lastPushedInd = 0;
            this.rightIdx = 0;
            super.rewindInternal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                if (this.rightNotMatchedIndexes == null) {
                    this.rightNotMatchedIndexes = new BitSet(this.rightMaterialized.size());
                    this.rightNotMatchedIndexes.set(0, this.rightMaterialized.size());
                }
                this.inLoop = true;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        if (this.left == null) {
                            this.left = this.leftInBuf.remove();
                        }
                        while (this.requested > 0 && this.rightIdx < this.rightMaterialized.size()) {
                            this.checkState();
                            Object right = this.rightMaterialized.get(this.rightIdx++);
                            if (!this.cond.test(this.left, right)) continue;
                            --this.requested;
                            this.rightNotMatchedIndexes.clear(this.rightIdx - 1);
                            RowT joined = this.handler.concat(this.left, right);
                            this.downstream().push(joined);
                        }
                        if (this.rightIdx != this.rightMaterialized.size()) continue;
                        this.left = null;
                        this.rightIdx = 0;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            if (this.waitingLeft == -1 && this.requested > 0 && this.rightNotMatchedIndexes != null && !this.rightNotMatchedIndexes.isEmpty()) {
                assert (this.lastPushedInd >= 0);
                this.inLoop = true;
                try {
                    this.lastPushedInd = this.rightNotMatchedIndexes.nextSetBit(this.lastPushedInd);
                    while (true) {
                        this.checkState();
                        if (this.lastPushedInd < 0) {
                            break;
                        }
                        RowT row = this.handler.concat(this.leftRowFactory.create(), this.rightMaterialized.get(this.lastPushedInd));
                        this.rightNotMatchedIndexes.clear(this.lastPushedInd);
                        --this.requested;
                        this.downstream().push(row);
                        if (this.lastPushedInd == Integer.MAX_VALUE) break;
                        if (this.requested <= 0) {
                            break;
                        }
                        this.lastPushedInd = this.rightNotMatchedIndexes.nextSetBit(this.lastPushedInd + 1);
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            if (this.waitingRight == 0) {
                this.waitingRight = 512;
                this.rightSource().request(512);
            }
            if (this.waitingLeft == 0 && this.leftInBuf.isEmpty()) {
                this.waitingLeft = 512;
                this.leftSource().request(512);
            }
            if (this.requested > 0 && this.waitingLeft == -1 && this.waitingRight == -1 && this.left == null && this.leftInBuf.isEmpty() && this.rightNotMatchedIndexes.isEmpty()) {
                this.requested = 0;
                this.downstream().end();
            }
        }
    }

    private static class LeftJoin<RowT>
    extends NestedLoopJoinNode<RowT> {
        private final RowHandler.RowFactory<RowT> rightRowFactory;
        private boolean matched;
        private RowT left;
        private int rightIdx;

        private LeftJoin(ExecutionContext<RowT> ctx, RelDataType rowType, BiPredicate<RowT, RowT> cond, RowHandler.RowFactory<RowT> rightRowFactory) {
            super(ctx, rowType, cond);
            this.rightRowFactory = rightRowFactory;
        }

        @Override
        protected void rewindInternal() {
            this.matched = false;
            this.left = null;
            this.rightIdx = 0;
            super.rewindInternal();
        }

        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                this.inLoop = true;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        if (this.left == null) {
                            this.left = this.leftInBuf.remove();
                            this.matched = false;
                        }
                        while (this.requested > 0 && this.rightIdx < this.rightMaterialized.size()) {
                            this.checkState();
                            if (!this.cond.test(this.left, this.rightMaterialized.get(this.rightIdx++))) continue;
                            --this.requested;
                            this.matched = true;
                            RowT row = this.handler.concat(this.left, this.rightMaterialized.get(this.rightIdx - 1));
                            this.downstream().push(row);
                        }
                        if (this.rightIdx != this.rightMaterialized.size()) continue;
                        boolean wasPushed = false;
                        if (!this.matched && this.requested > 0) {
                            --this.requested;
                            wasPushed = true;
                            this.downstream().push(this.handler.concat(this.left, this.rightRowFactory.create()));
                        }
                        if (!this.matched && !wasPushed) continue;
                        this.left = null;
                        this.rightIdx = 0;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            if (this.waitingRight == 0) {
                this.waitingRight = 512;
                this.rightSource().request(512);
            }
            if (this.waitingLeft == 0 && this.leftInBuf.isEmpty()) {
                this.waitingLeft = 512;
                this.leftSource().request(512);
            }
            if (this.requested > 0 && this.waitingLeft == -1 && this.waitingRight == -1 && this.left == null && this.leftInBuf.isEmpty()) {
                this.requested = 0;
                this.downstream().end();
            }
        }
    }

    private static class InnerJoin<RowT>
    extends NestedLoopJoinNode<RowT> {
        private RowT left;
        private int rightIdx;

        private InnerJoin(ExecutionContext<RowT> ctx, RelDataType rowType, BiPredicate<RowT, RowT> cond) {
            super(ctx, rowType, cond);
        }

        @Override
        protected void rewindInternal() {
            this.left = null;
            this.rightIdx = 0;
            super.rewindInternal();
        }

        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                this.inLoop = true;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        if (this.left == null) {
                            this.left = this.leftInBuf.remove();
                        }
                        while (this.requested > 0 && this.rightIdx < this.rightMaterialized.size()) {
                            this.checkState();
                            if (!this.cond.test(this.left, this.rightMaterialized.get(this.rightIdx++))) continue;
                            --this.requested;
                            RowT row = this.handler.concat(this.left, this.rightMaterialized.get(this.rightIdx - 1));
                            this.downstream().push(row);
                        }
                        if (this.rightIdx != this.rightMaterialized.size()) continue;
                        this.left = null;
                        this.rightIdx = 0;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            if (this.waitingRight == 0) {
                this.waitingRight = 512;
                this.rightSource().request(512);
            }
            if (this.waitingLeft == 0 && this.leftInBuf.isEmpty()) {
                this.waitingLeft = 512;
                this.leftSource().request(512);
            }
            if (this.requested > 0 && this.waitingLeft == -1 && this.waitingRight == -1 && this.left == null && this.leftInBuf.isEmpty()) {
                this.requested = 0;
                this.downstream().end();
            }
        }
    }
}

