/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.marshaller.schema;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.UUID;
import org.apache.ignite.internal.schema.BitmaskNativeType;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.Columns;
import org.apache.ignite.internal.schema.DecimalNativeType;
import org.apache.ignite.internal.schema.DefaultValueGenerator;
import org.apache.ignite.internal.schema.DefaultValueProvider;
import org.apache.ignite.internal.schema.InvalidTypeException;
import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.schema.NativeTypeSpec;
import org.apache.ignite.internal.schema.NativeTypes;
import org.apache.ignite.internal.schema.NumberNativeType;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.TemporalNativeType;
import org.apache.ignite.internal.schema.VarlenNativeType;
import org.apache.ignite.internal.schema.mapping.ColumnMapper;
import org.apache.ignite.internal.schema.mapping.ColumnMapping;
import org.apache.ignite.internal.schema.marshaller.schema.AbstractSchemaSerializer;

public class SchemaSerializerImpl
extends AbstractSchemaSerializer {
    public static final AbstractSchemaSerializer INSTANCE = new SchemaSerializerImpl();
    private static final int STRING_HEADER = 4;
    private static final int ARRAY_HEADER_LENGTH = 4;
    private static final int BYTE = 1;
    private static final int SHORT = 2;
    private static final int INT = 4;
    private static final int LONG = 8;
    private static final int FLOAT = 4;
    private static final int DOUBLE = 8;
    private static final short SCHEMA_VER = 1;

    public SchemaSerializerImpl() {
        super((short)1);
    }

    @Override
    public void writeTo(SchemaDescriptor desc, ByteBuffer byteBuf) {
        byteBuf.putShort((short)1);
        byteBuf.putInt(desc.version());
        this.appendColumns(desc.keyColumns(), byteBuf);
        this.appendColumns(desc.valueColumns(), byteBuf);
        Column[] colocationCols = desc.colocationColumns();
        byteBuf.putInt(colocationCols.length);
        for (Column column : colocationCols) {
            this.appendString(column.name(), byteBuf);
        }
        this.appendColumnMapping(desc.columnMapping(), desc.length(), byteBuf);
    }

    @Override
    public SchemaDescriptor readFrom(ByteBuffer byteBuf) {
        int ver = byteBuf.getInt();
        Column[] keyCols = this.readColumns(byteBuf);
        Column[] valCols = this.readColumns(byteBuf);
        int colocationColsSize = byteBuf.getInt();
        String[] colocationCols = new String[colocationColsSize];
        for (int i = 0; i < colocationColsSize; ++i) {
            colocationCols[i] = this.readString(byteBuf);
        }
        SchemaDescriptor descriptor = new SchemaDescriptor(ver, keyCols, colocationCols, valCols);
        ColumnMapper mapper = this.readColumnMapping(descriptor, byteBuf);
        descriptor.columnMapping(mapper);
        return descriptor;
    }

    @Override
    public int size(SchemaDescriptor desc) {
        return 6 + this.getColumnsSize(desc.keyColumns()) + this.getColumnsSize(desc.valueColumns()) + 4 + this.getStringArraySize(desc.colocationColumns()) + this.getColumnMappingSize(desc.columnMapping(), desc.length());
    }

    private int getColumnMappingSize(ColumnMapper mapper, int len) {
        int size = 4;
        for (int i = 0; i < len; ++i) {
            if (mapper.map(i) == i) continue;
            size += 4;
            size += 4;
            if (mapper.map(i) != -1) continue;
            size += this.getColumnSize(mapper.mappedColumn(i));
        }
        return size;
    }

    private int getStringArraySize(Column[] cols) {
        int size = 4;
        for (Column column : cols) {
            size += this.getStringSize(column.name());
        }
        return size;
    }

    private int getColumnsSize(Columns cols) {
        int size = 4;
        for (Column column : cols.columns()) {
            size += this.getColumnSize(column);
        }
        return size;
    }

    private int getColumnSize(Column col) {
        int size = 9 + this.getStringSize(col.name()) + this.getNativeTypeSize(col.type()) + 1;
        switch (col.defaultValueProvider().type()) {
            case CONSTANT: {
                size += 1 + this.getDefaultObjectSize(col.type().spec(), col.defaultValue());
                break;
            }
            case FUNCTIONAL: {
                size += this.getStringSize(((DefaultValueProvider.FunctionalValueProvider)col.defaultValueProvider()).name());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown value provider type [type=" + col.defaultValueProvider().type() + "]");
            }
        }
        return size;
    }

    private int getDefaultObjectSize(NativeTypeSpec type, Object val) {
        if (val == null) {
            return 0;
        }
        switch (type) {
            case INT8: {
                return 1;
            }
            case INT16: {
                return 2;
            }
            case INT32: {
                return 4;
            }
            case INT64: {
                return 8;
            }
            case FLOAT: {
                return 4;
            }
            case DOUBLE: {
                return 8;
            }
            case DECIMAL: {
                return 8 + ((BigDecimal)val).unscaledValue().toByteArray().length;
            }
            case UUID: {
                return 16;
            }
            case STRING: {
                return this.getStringSize((String)val);
            }
            case BYTES: {
                return 4 + ((byte[])val).length;
            }
            case BITMASK: {
                return 4 + ((BitSet)val).toByteArray().length;
            }
            case NUMBER: {
                return 4 + ((BigInteger)val).toByteArray().length;
            }
            case DATE: {
                return 6;
            }
            case TIME: {
                return 7;
            }
            case DATETIME: {
                return this.getDefaultObjectSize(NativeTypeSpec.DATE, val) + this.getDefaultObjectSize(NativeTypeSpec.TIME, val);
            }
            case TIMESTAMP: {
                return 12;
            }
        }
        throw new InvalidTypeException("Unexpected type " + type);
    }

    private int getNativeTypeSize(NativeType type) {
        int typeSize = 0;
        switch (type.spec()) {
            case STRING: 
            case BYTES: 
            case BITMASK: 
            case NUMBER: 
            case TIME: 
            case DATETIME: 
            case TIMESTAMP: {
                typeSize += 4;
                break;
            }
            case DECIMAL: {
                typeSize += 4;
                typeSize += 4;
                break;
            }
        }
        return this.getStringSize(type.spec().name()) + typeSize;
    }

    private int getStringSize(String str) {
        return 4 + this.stringBytes(str).length;
    }

    private byte[] stringBytes(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    private void appendColumnMapping(ColumnMapper mapper, int len, ByteBuffer buff) {
        int i;
        int mappingSize = 0;
        for (i = 0; i < len; ++i) {
            if (mapper.map(i) == i) continue;
            ++mappingSize;
        }
        buff.putInt(mappingSize);
        for (i = 0; i < len; ++i) {
            if (mapper.map(i) == i) continue;
            buff.putInt(i);
            buff.putInt(mapper.map(i));
            if (mapper.map(i) != -1) continue;
            this.appendColumn(mapper.mappedColumn(i), buff);
        }
    }

    private void appendColumns(Columns cols, ByteBuffer buf) {
        Column[] colArr = cols.columns();
        buf.putInt(colArr.length);
        for (Column column : colArr) {
            this.appendColumn(column, buf);
        }
    }

    private void appendColumn(Column col, ByteBuffer buf) {
        buf.putInt(col.schemaIndex());
        buf.putInt(col.columnOrder());
        buf.put((byte)(col.nullable() ? 1 : 0));
        this.appendString(col.name(), buf);
        this.appendNativeType(buf, col.type());
        DefaultValueProvider valueProvider = col.defaultValueProvider();
        buf.put(valueProvider.type().id());
        switch (valueProvider.type()) {
            case CONSTANT: {
                this.appendDefaultValue(buf, col.type(), col.defaultValue());
                break;
            }
            case FUNCTIONAL: {
                assert (valueProvider instanceof DefaultValueProvider.FunctionalValueProvider);
                this.appendString(((DefaultValueProvider.FunctionalValueProvider)valueProvider).name(), buf);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown provider type: " + valueProvider.type());
            }
        }
    }

    private void appendDefaultValue(ByteBuffer buf, NativeType type, Object val) {
        boolean isPresent = val != null;
        buf.put((byte)(isPresent ? 1 : 0));
        if (!isPresent) {
            return;
        }
        switch (type.spec()) {
            case INT8: {
                buf.put((Byte)val);
                break;
            }
            case INT16: {
                buf.putShort((Short)val);
                break;
            }
            case INT32: {
                buf.putInt((Integer)val);
                break;
            }
            case INT64: {
                buf.putLong((Long)val);
                break;
            }
            case FLOAT: {
                buf.putFloat(((Float)val).floatValue());
                break;
            }
            case DOUBLE: {
                buf.putDouble((Double)val);
                break;
            }
            case DECIMAL: {
                BigDecimal decimal = (BigDecimal)val;
                buf.putInt(decimal.scale());
                this.appendByteArray(decimal.unscaledValue().toByteArray(), buf);
                break;
            }
            case UUID: {
                UUID uuid = (UUID)val;
                buf.putLong(uuid.getMostSignificantBits());
                buf.putLong(uuid.getLeastSignificantBits());
                break;
            }
            case STRING: {
                this.appendString((String)val, buf);
                break;
            }
            case BYTES: {
                this.appendByteArray((byte[])val, buf);
                break;
            }
            case BITMASK: {
                BitSet bitSet = (BitSet)val;
                this.appendByteArray(bitSet.toByteArray(), buf);
                break;
            }
            case NUMBER: {
                BigInteger bigInt = (BigInteger)val;
                this.appendByteArray(bigInt.toByteArray(), buf);
                break;
            }
            case DATE: {
                this.appendDate((LocalDate)val, buf);
                break;
            }
            case TIME: {
                this.appendTime((LocalTime)val, buf);
                break;
            }
            case DATETIME: {
                LocalDateTime date = (LocalDateTime)val;
                this.appendDate(date.toLocalDate(), buf);
                this.appendTime(date.toLocalTime(), buf);
                break;
            }
            case TIMESTAMP: {
                Instant timeStamp = (Instant)val;
                buf.putLong(timeStamp.getEpochSecond());
                buf.putInt(timeStamp.getNano());
                break;
            }
            default: {
                throw new InvalidTypeException("Unexpected type " + type);
            }
        }
    }

    private void appendNativeType(ByteBuffer buf, NativeType type) {
        this.appendString(type.spec().name(), buf);
        switch (type.spec()) {
            case STRING: 
            case BYTES: {
                int len = ((VarlenNativeType)type).length();
                buf.putInt(len);
                break;
            }
            case BITMASK: {
                int bits = ((BitmaskNativeType)type).bits();
                buf.putInt(bits);
                break;
            }
            case DECIMAL: {
                int precision = ((DecimalNativeType)type).precision();
                int scale = ((DecimalNativeType)type).scale();
                buf.putInt(precision);
                buf.putInt(scale);
                break;
            }
            case TIME: 
            case DATETIME: 
            case TIMESTAMP: {
                int precision = ((TemporalNativeType)type).precision();
                buf.putInt(precision);
                break;
            }
            case NUMBER: {
                int precision = ((NumberNativeType)type).precision();
                buf.putInt(precision);
                break;
            }
        }
    }

    private void appendString(String str, ByteBuffer buf) {
        this.appendByteArray(this.stringBytes(str), buf);
    }

    private void appendByteArray(byte[] bytes, ByteBuffer buf) {
        buf.putInt(bytes.length);
        buf.put(bytes);
    }

    private void appendDate(LocalDate date, ByteBuffer buf) {
        buf.putInt(date.getYear());
        buf.put((byte)date.getMonthValue());
        buf.put((byte)date.getDayOfMonth());
    }

    private void appendTime(LocalTime time, ByteBuffer buf) {
        buf.put((byte)time.getHour());
        buf.put((byte)time.getMinute());
        buf.put((byte)time.getSecond());
        buf.putInt(time.getNano());
    }

    private ColumnMapper readColumnMapping(SchemaDescriptor desc, ByteBuffer buf) {
        int mappingSize = buf.getInt();
        if (mappingSize == 0) {
            return ColumnMapping.identityMapping();
        }
        ColumnMapper mapper = ColumnMapping.createMapper(desc);
        for (int i = 0; i < mappingSize; ++i) {
            int from = buf.getInt();
            int to = buf.getInt();
            if (to == -1) {
                Column col = this.readColumn(buf);
                mapper.add(col);
                continue;
            }
            mapper.add(from, to);
        }
        return mapper;
    }

    private Column[] readColumns(ByteBuffer buf) {
        int size = buf.getInt();
        Column[] colArr = new Column[size];
        for (int i = 0; i < size; ++i) {
            colArr[i] = this.readColumn(buf);
        }
        return colArr;
    }

    private Column readColumn(ByteBuffer buf) {
        int schemaIdx = buf.getInt();
        int columnOrder = buf.getInt();
        boolean nullable = buf.get() == 1;
        String name = this.readString(buf);
        NativeType nativeType = this.fromByteBuffer(buf);
        byte typeId = buf.get();
        DefaultValueProvider.Type type = DefaultValueProvider.Type.byId(typeId);
        if (type == null) {
            throw new IllegalStateException("Unknown default supplier type id: " + typeId);
        }
        switch (type) {
            case CONSTANT: {
                Object object = this.readDefaultValue(buf, nativeType);
                return new Column(columnOrder, name, nativeType, nullable, DefaultValueProvider.constantProvider(object)).copy(schemaIdx);
            }
            case FUNCTIONAL: {
                String generatorName = this.readString(buf);
                return new Column(columnOrder, name, nativeType, nullable, DefaultValueProvider.forValueGenerator(DefaultValueGenerator.valueOf(generatorName))).copy(schemaIdx);
            }
        }
        throw new IllegalStateException("Unknown default supplier type: " + type);
    }

    private Object readDefaultValue(ByteBuffer buf, NativeType type) {
        boolean isPresent;
        boolean bl = isPresent = buf.get() == 1;
        if (!isPresent) {
            return null;
        }
        switch (type.spec()) {
            case INT8: {
                return buf.get();
            }
            case INT16: {
                return buf.getShort();
            }
            case INT32: {
                return buf.getInt();
            }
            case INT64: {
                return buf.getLong();
            }
            case FLOAT: {
                return Float.valueOf(buf.getFloat());
            }
            case DOUBLE: {
                return buf.getDouble();
            }
            case DECIMAL: {
                int scale = buf.getInt();
                byte[] bytes = this.readByteArray(buf);
                return new BigDecimal(new BigInteger(bytes), scale);
            }
            case UUID: {
                return new UUID(buf.getLong(), buf.getLong());
            }
            case STRING: {
                return this.readString(buf);
            }
            case BYTES: {
                return this.readByteArray(buf);
            }
            case BITMASK: {
                return BitSet.valueOf(this.readByteArray(buf));
            }
            case NUMBER: {
                return new BigInteger(this.readByteArray(buf));
            }
            case DATE: {
                return this.readDate(buf);
            }
            case TIME: {
                return this.readTime(buf);
            }
            case DATETIME: {
                return LocalDateTime.of(this.readDate(buf), this.readTime(buf));
            }
            case TIMESTAMP: {
                return this.readTimestamp(buf);
            }
        }
        throw new InvalidTypeException("Unexpected type " + type);
    }

    private NativeType fromByteBuffer(ByteBuffer buf) {
        String nativeTypeSpecName = this.readString(buf);
        NativeTypeSpec spec = NativeTypeSpec.valueOf(nativeTypeSpecName);
        switch (spec) {
            case STRING: {
                int strLen = buf.getInt();
                return NativeTypes.stringOf(strLen);
            }
            case BYTES: {
                int len = buf.getInt();
                return NativeTypes.blobOf(len);
            }
            case BITMASK: {
                int bits = buf.getInt();
                return NativeTypes.bitmaskOf(bits);
            }
            case DECIMAL: {
                int precision = buf.getInt();
                int scale = buf.getInt();
                return NativeTypes.decimalOf(precision, scale);
            }
            case TIME: {
                int precision = buf.getInt();
                return NativeTypes.time(precision);
            }
            case DATETIME: {
                int precision = buf.getInt();
                return NativeTypes.datetime(precision);
            }
            case TIMESTAMP: {
                int precision = buf.getInt();
                return NativeTypes.timestamp(precision);
            }
            case NUMBER: {
                int precision = buf.getInt();
                return NativeTypes.numberOf(precision);
            }
            case INT8: {
                return NativeTypes.INT8;
            }
            case INT16: {
                return NativeTypes.INT16;
            }
            case INT32: {
                return NativeTypes.INT32;
            }
            case INT64: {
                return NativeTypes.INT64;
            }
            case FLOAT: {
                return NativeTypes.FLOAT;
            }
            case DOUBLE: {
                return NativeTypes.DOUBLE;
            }
            case UUID: {
                return NativeTypes.UUID;
            }
            case DATE: {
                return NativeTypes.DATE;
            }
        }
        throw new InvalidTypeException("Unexpected type " + spec);
    }

    private String readString(ByteBuffer buf) {
        return new String(this.readByteArray(buf), StandardCharsets.UTF_8);
    }

    private byte[] readByteArray(ByteBuffer buf) {
        int len = buf.getInt();
        byte[] arr = new byte[len];
        buf.get(arr);
        return arr;
    }

    private LocalDate readDate(ByteBuffer buf) {
        return LocalDate.of(buf.getInt(), buf.get(), (int)buf.get());
    }

    private LocalTime readTime(ByteBuffer buf) {
        return LocalTime.of(buf.get(), buf.get(), buf.get(), buf.getInt());
    }

    private Instant readTimestamp(ByteBuffer buf) {
        return Instant.ofEpochSecond(buf.getLong(), buf.getInt());
    }
}

