/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import java.net.URI;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.HttpRequestWrapper;
import org.apache.hc.core5.net.URIAuthority;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HttpRequestWrapperTest {
    HttpRequestWrapperTest() {
    }

    @Test
    void testRequestBasics() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, "/stuff");
        HttpRequestWrapper httpRequestWrapper = new HttpRequestWrapper((HttpRequest)request);
        Assertions.assertEquals((Object)Method.GET.name(), (Object)httpRequestWrapper.getMethod());
        Assertions.assertEquals((Object)"/stuff", (Object)httpRequestWrapper.getPath());
        Assertions.assertNull((Object)httpRequestWrapper.getAuthority());
        Assertions.assertEquals((Object)new URI("/stuff"), (Object)httpRequestWrapper.getUri());
        httpRequestWrapper.setPath("/another-stuff");
        Assertions.assertEquals((Object)"/another-stuff", (Object)httpRequestWrapper.getPath());
    }

    @Test
    void testDefaultRequestConstructors() {
        BasicHttpRequest request1 = new BasicHttpRequest("WHATEVER", "/");
        HttpRequestWrapper httpRequestWrapper = new HttpRequestWrapper((HttpRequest)request1);
        Assertions.assertEquals((Object)"WHATEVER", (Object)httpRequestWrapper.getMethod());
        Assertions.assertEquals((Object)"/", (Object)httpRequestWrapper.getPath());
        BasicHttpRequest request2 = new BasicHttpRequest(Method.GET, "/");
        HttpRequestWrapper httpRequestWrapper2 = new HttpRequestWrapper((HttpRequest)request2);
        Assertions.assertEquals((Object)Method.GET.name(), (Object)httpRequestWrapper2.getMethod());
        Assertions.assertEquals((Object)"/", (Object)httpRequestWrapper2.getPath());
        Assertions.assertThrows(NullPointerException.class, () -> new BasicHttpRequest(Method.GET, (URI)null));
    }

    @Test
    void testRequestWithRelativeURI() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, new URI("/stuff"));
        HttpRequestWrapper httpRequestWrapper = new HttpRequestWrapper((HttpRequest)request);
        Assertions.assertEquals((Object)Method.GET.name(), (Object)httpRequestWrapper.getMethod());
        Assertions.assertEquals((Object)"/stuff", (Object)httpRequestWrapper.getPath());
        Assertions.assertNull((Object)httpRequestWrapper.getAuthority());
        Assertions.assertEquals((Object)new URI("/stuff"), (Object)httpRequestWrapper.getUri());
    }

    @Test
    void testRequestWithAbsoluteURI() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, new URI("https://host:9443/stuff?param=value"));
        HttpRequestWrapper httpRequestWrapper = new HttpRequestWrapper((HttpRequest)request);
        Assertions.assertEquals((Object)Method.GET.name(), (Object)httpRequestWrapper.getMethod());
        Assertions.assertEquals((Object)"/stuff?param=value", (Object)httpRequestWrapper.getPath());
        Assertions.assertEquals((Object)new URIAuthority("host", 9443), (Object)httpRequestWrapper.getAuthority());
        Assertions.assertEquals((Object)"https", (Object)httpRequestWrapper.getScheme());
        Assertions.assertEquals((Object)new URI("https://host:9443/stuff?param=value"), (Object)httpRequestWrapper.getUri());
        httpRequestWrapper.setScheme(URIScheme.HTTP.id);
        Assertions.assertEquals((Object)"http", (Object)httpRequestWrapper.getScheme());
    }

    @Test
    void testRequestWithAbsoluteURIAsPath() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, "https://host:9443/stuff?param=value");
        HttpRequestWrapper httpRequestWrapper = new HttpRequestWrapper((HttpRequest)request);
        Assertions.assertEquals((Object)Method.GET.name(), (Object)httpRequestWrapper.getMethod());
        Assertions.assertEquals((Object)"/stuff?param=value", (Object)httpRequestWrapper.getPath());
        Assertions.assertEquals((Object)new URIAuthority("host", 9443), (Object)httpRequestWrapper.getAuthority());
        Assertions.assertEquals((Object)"https", (Object)httpRequestWrapper.getScheme());
        Assertions.assertEquals((Object)new URI("https://host:9443/stuff?param=value"), (Object)httpRequestWrapper.getUri());
    }

    @Test
    void testRequestWithNoPath() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, new URI("http://host"));
        HttpRequestWrapper httpRequestWrapper = new HttpRequestWrapper((HttpRequest)request);
        Assertions.assertEquals((Object)Method.GET.name(), (Object)httpRequestWrapper.getMethod());
        Assertions.assertEquals((Object)"/", (Object)httpRequestWrapper.getPath());
        Assertions.assertEquals((Object)new URIAuthority("host"), (Object)httpRequestWrapper.getAuthority());
        Assertions.assertEquals((Object)"http", (Object)httpRequestWrapper.getScheme());
        Assertions.assertEquals((Object)new URI("http://host/"), (Object)httpRequestWrapper.getUri());
    }

    @Test
    void testRequestWithUserInfo() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, new URI("https://user:pwd@host:9443/stuff?param=value"));
        HttpRequestWrapper httpRequestWrapper = new HttpRequestWrapper((HttpRequest)request);
        Assertions.assertEquals((Object)Method.GET.name(), (Object)httpRequestWrapper.getMethod());
        Assertions.assertEquals((Object)"/stuff?param=value", (Object)httpRequestWrapper.getPath());
        Assertions.assertEquals((Object)new URIAuthority("user:pwd", "host", 9443), (Object)httpRequestWrapper.getAuthority());
        Assertions.assertEquals((Object)"https", (Object)httpRequestWrapper.getScheme());
        Assertions.assertEquals((Object)new URI("https://host:9443/stuff?param=value"), (Object)httpRequestWrapper.getUri());
    }

    @Test
    void testRequestWithAuthority() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, new HttpHost("http", "somehost", -1), "/stuff");
        HttpRequestWrapper httpRequestWrapper = new HttpRequestWrapper((HttpRequest)request);
        Assertions.assertEquals((Object)Method.GET.name(), (Object)httpRequestWrapper.getMethod());
        Assertions.assertEquals((Object)"/stuff", (Object)httpRequestWrapper.getPath());
        Assertions.assertEquals((Object)new URIAuthority("somehost"), (Object)httpRequestWrapper.getAuthority());
        Assertions.assertEquals((Object)new URI("http://somehost/stuff"), (Object)httpRequestWrapper.getUri());
        httpRequestWrapper.setAuthority(new URIAuthority("newHost"));
        Assertions.assertEquals((Object)new URIAuthority("newHost"), (Object)httpRequestWrapper.getAuthority());
    }

    @Test
    void testRequestWithAuthorityRelativePath() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, new HttpHost("http", "somehost", -1), "stuff");
        HttpRequestWrapper httpRequestWrapper = new HttpRequestWrapper((HttpRequest)request);
        Assertions.assertEquals((Object)Method.GET.name(), (Object)httpRequestWrapper.getMethod());
        Assertions.assertEquals((Object)"stuff", (Object)httpRequestWrapper.getPath());
        Assertions.assertEquals((Object)"stuff", (Object)httpRequestWrapper.getRequestUri());
        Assertions.assertEquals((Object)new URIAuthority("somehost"), (Object)httpRequestWrapper.getAuthority());
        Assertions.assertEquals((Object)new URI("http://somehost/stuff"), (Object)httpRequestWrapper.getUri());
    }

    @Test
    void testRequestHostWithReservedChars() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, URI.create("http://someuser%21@%21example%21.com/stuff"));
        HttpRequestWrapper httpRequestWrapper = new HttpRequestWrapper((HttpRequest)request);
        Assertions.assertEquals((Object)Method.GET.name(), (Object)httpRequestWrapper.getMethod());
        Assertions.assertEquals((Object)"/stuff", (Object)httpRequestWrapper.getPath());
        Assertions.assertEquals((Object)new URIAuthority("someuser%21", "%21example%21.com", -1), (Object)httpRequestWrapper.getAuthority());
        Assertions.assertEquals((Object)new URI("http://%21example%21.com/stuff"), (Object)httpRequestWrapper.getUri());
    }
}

