/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.WritableByteChannelMock;
import org.apache.hc.core5.http.nio.BasicDataStreamChannel;
import org.apache.hc.core5.http.nio.StreamChannel;
import org.apache.hc.core5.http.nio.entity.AbstractBinAsyncEntityProducer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestAbstractBinAsyncEntityProducer {
    TestAbstractBinAsyncEntityProducer() {
    }

    @Test
    void testProduceDataNoBuffering() throws Exception {
        ChunkByteAsyncEntityProducer producer = new ChunkByteAsyncEntityProducer(0, ContentType.TEXT_PLAIN, {49, 50, 51}, {52, 53, 54});
        Assertions.assertEquals((long)-1L, (long)producer.getContentLength());
        Assertions.assertEquals((Object)ContentType.TEXT_PLAIN.toString(), (Object)producer.getContentType());
        Assertions.assertNull((Object)producer.getContentEncoding());
        WritableByteChannelMock byteChannel = new WritableByteChannelMock(1024);
        BasicDataStreamChannel streamChannel = new BasicDataStreamChannel(byteChannel);
        producer.produce(streamChannel);
        Assertions.assertTrue((boolean)byteChannel.isOpen());
        Assertions.assertEquals((Object)"123", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
        producer.produce(streamChannel);
        Assertions.assertFalse((boolean)byteChannel.isOpen());
        Assertions.assertEquals((Object)"456", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
    }

    @Test
    void testProduceDataWithBuffering1() throws Exception {
        ChunkByteAsyncEntityProducer producer = new ChunkByteAsyncEntityProducer(5, ContentType.TEXT_PLAIN, {49, 50, 51}, {52, 53, 54}, {55, 56}, {57, 48});
        WritableByteChannelMock byteChannel = new WritableByteChannelMock(1024);
        BasicDataStreamChannel streamChannel = new BasicDataStreamChannel(byteChannel);
        producer.produce(streamChannel);
        Assertions.assertTrue((boolean)byteChannel.isOpen());
        Assertions.assertEquals((Object)"", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
        producer.produce(streamChannel);
        Assertions.assertTrue((boolean)byteChannel.isOpen());
        Assertions.assertEquals((Object)"123", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
        producer.produce(streamChannel);
        Assertions.assertTrue((boolean)byteChannel.isOpen());
        Assertions.assertEquals((Object)"45678", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
        producer.produce(streamChannel);
        Assertions.assertFalse((boolean)byteChannel.isOpen());
        Assertions.assertEquals((Object)"90", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
    }

    @Test
    void testProduceDataWithBuffering2() throws Exception {
        ChunkByteAsyncEntityProducer producer = new ChunkByteAsyncEntityProducer(5, ContentType.TEXT_PLAIN, {49}, {50}, {51}, {52, 53}, {54}, {55, 56}, {57, 48});
        WritableByteChannelMock byteChannel = new WritableByteChannelMock(1024);
        BasicDataStreamChannel streamChannel = new BasicDataStreamChannel(byteChannel);
        producer.produce(streamChannel);
        Assertions.assertTrue((boolean)byteChannel.isOpen());
        Assertions.assertEquals((Object)"", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
        producer.produce(streamChannel);
        Assertions.assertTrue((boolean)byteChannel.isOpen());
        Assertions.assertEquals((Object)"", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
        producer.produce(streamChannel);
        Assertions.assertTrue((boolean)byteChannel.isOpen());
        Assertions.assertEquals((Object)"", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
        producer.produce(streamChannel);
        Assertions.assertTrue((boolean)byteChannel.isOpen());
        Assertions.assertEquals((Object)"12345", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
        producer.produce(streamChannel);
        Assertions.assertTrue((boolean)byteChannel.isOpen());
        Assertions.assertEquals((Object)"", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
        producer.produce(streamChannel);
        Assertions.assertTrue((boolean)byteChannel.isOpen());
        Assertions.assertEquals((Object)"", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
        producer.produce(streamChannel);
        Assertions.assertFalse((boolean)byteChannel.isOpen());
        Assertions.assertEquals((Object)"67890", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
    }

    private static class ChunkByteAsyncEntityProducer
    extends AbstractBinAsyncEntityProducer {
        private final byte[][] content;
        private int count = 0;

        public ChunkByteAsyncEntityProducer(int fragmentSizeHint, ContentType contentType, byte[] ... content) {
            super(fragmentSizeHint, contentType);
            this.content = content;
        }

        public boolean isRepeatable() {
            return false;
        }

        protected int availableData() {
            return Integer.MAX_VALUE;
        }

        protected void produceData(StreamChannel<ByteBuffer> channel) throws IOException {
            if (this.count < this.content.length) {
                channel.write((Buffer)ByteBuffer.wrap(this.content[this.count]));
            }
            ++this.count;
            if (this.count >= this.content.length) {
                channel.endStream();
            }
        }

        public void failed(Exception cause) {
        }
    }
}

