/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowBuffer;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.transform.IRowListener;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.GetPipelineStatusServlet;
import org.apache.hop.www.HopServerObjectEntry;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.WebResult;
import org.owasp.encoder.Encode;

@HopServerServlet(id="sniffTransform", name="Sniff test a pipeline transform")
public class SniffTransformServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final Class<?> PKG = GetPipelineStatusServlet.class;
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/hop/sniffTransform";
    public static final String TYPE_INPUT = "input";
    public static final String TYPE_OUTPUT = "output";

    public SniffTransformServlet() {
    }

    public SniffTransformServlet(PipelineMap pipelineMap) {
        super(pipelineMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        IPipelineEngine<PipelineMeta> pipeline;
        HopServerObjectEntry entry;
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"PipelineStatusServlet.Log.SniffTransformRequested", (String[])new String[0]));
        }
        String pipelineName = request.getParameter("pipeline");
        String id = request.getParameter("id");
        String transformName = request.getParameter("transform");
        int copyNr = Const.toInt((String)request.getParameter("copynr"), (int)0);
        final int nrLines = Const.toInt((String)request.getParameter("lines"), (int)0);
        String type = Const.NVL((String)request.getParameter("type"), (String)TYPE_OUTPUT);
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        response.setStatus(200);
        if (useXML) {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
        } else {
            response.setContentType("text/html;charset=UTF-8");
        }
        PrintWriter out = response.getWriter();
        if (Utils.isEmpty((CharSequence)id)) {
            entry = this.getPipelineMap().getFirstServerObjectEntry(pipelineName);
            if (entry == null) {
                pipeline = null;
            } else {
                id = entry.getId();
                pipeline = this.getPipelineMap().getPipeline(entry);
            }
        } else {
            entry = new HopServerObjectEntry(pipelineName, id);
            pipeline = this.getPipelineMap().getPipeline(entry);
        }
        if (pipeline != null) {
            IEngineComponent component = null;
            List<IEngineComponent> componentCopies = pipeline.getComponentCopies(transformName);
            for (IEngineComponent componentCopy : componentCopies) {
                if (componentCopy.getCopyNr() != copyNr) continue;
                component = componentCopy;
            }
            final RowBuffer rowBuffer = new RowBuffer();
            if (component != null) {
                while (!(pipeline.isRunning() || pipeline.isReadyToStart() || pipeline.isStopped())) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException componentCopy) {}
                }
                if (!pipeline.isStopped()) {
                    final boolean read = type.equalsIgnoreCase(TYPE_INPUT);
                    final boolean written = type.equalsIgnoreCase(TYPE_OUTPUT) || !read;
                    IRowListener rowListener = new IRowListener(){

                        @Override
                        public void rowReadEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                            if (read && rowBuffer.getBuffer().size() < nrLines) {
                                rowBuffer.setRowMeta(rowMeta);
                                rowBuffer.getBuffer().add(row);
                            }
                        }

                        @Override
                        public void rowWrittenEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                            if (written && rowBuffer.getBuffer().size() < nrLines) {
                                rowBuffer.setRowMeta(rowMeta);
                                rowBuffer.getBuffer().add(row);
                            }
                        }

                        @Override
                        public void errorRowWrittenEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                        }
                    };
                    component.addRowListener(rowListener);
                    while (rowBuffer.getBuffer().size() < nrLines && component.isRunning() && !pipeline.isFinished() && !pipeline.isStopped()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    component.removeRowListener(rowListener);
                }
                if (useXML) {
                    response.setContentType("text/xml");
                    response.setCharacterEncoding("UTF-8");
                    out.print(XmlHandler.getXmlHeader((String)"UTF-8"));
                    out.println(rowBuffer.getXml());
                } else {
                    response.setContentType("text/html;charset=UTF-8");
                    out.println("<HTML>");
                    out.println("<HEAD>");
                    out.println("<TITLE>" + BaseMessages.getString(PKG, (String)"SniffTransformServlet.SniffResults", (String[])new String[0]) + "</TITLE>");
                    out.println("<META http-equiv=\"Refresh\" content=\"10;url=" + this.convertContextPath(CONTEXT_PATH) + "?name=" + URLEncoder.encode(pipelineName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">");
                    out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
                    out.println("<link rel=\"icon\" type=\"image/svg+xml\" href=\"/static/images/favicon.svg\">");
                    out.println("</HEAD>");
                    out.println("<BODY>");
                    out.println("<H1>" + Encode.forHtml((String)BaseMessages.getString(PKG, (String)"SniffTransformServlet.SniffResultsForTransform", (String[])new String[]{transformName})) + "</H1>");
                    try {
                        out.println("<table border=\"1\">");
                        if (rowBuffer.getRowMeta() != null) {
                            out.print("<tr><th>#</th>");
                            for (IValueMeta valueMeta : rowBuffer.getRowMeta().getValueMetaList()) {
                                out.print("<th>" + valueMeta.getName() + "</th>");
                            }
                            out.println("</tr>");
                            for (int r = 0; r < rowBuffer.getBuffer().size(); ++r) {
                                Object[] rowData = (Object[])rowBuffer.getBuffer().get(r);
                                out.print("<tr>");
                                out.println("<td>" + (r + 1) + "</td>");
                                for (int v = 0; v < rowBuffer.getRowMeta().size(); ++v) {
                                    IValueMeta valueMeta = rowBuffer.getRowMeta().getValueMeta(v);
                                    Object valueData = rowData[v];
                                    out.println("<td>" + valueMeta.getString(valueData) + "</td>");
                                }
                                out.println("</tr>");
                            }
                        }
                        out.println("</table>");
                        out.println("<p>");
                    }
                    catch (Exception ex) {
                        out.println("<p>");
                        out.println("<pre>");
                        out.println(Encode.forHtml((String)Const.getStackTracker((Throwable)ex)));
                        out.println("</pre>");
                    }
                    out.println("<p>");
                    out.println("</BODY>");
                    out.println("</HTML>");
                }
            } else if (useXML) {
                out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"SniffTransformServlet.Log.CoundNotFindSpecTransform", (String[])new String[]{transformName})).getXml());
            } else {
                out.println("<H1>" + Encode.forHtml((String)BaseMessages.getString(PKG, (String)"SniffTransformServlet.Log.CoundNotFindSpecTransform", (String[])new String[]{transformName})) + "</H1>");
                out.println("<a href=\"" + this.convertContextPath("/hop/status") + "\">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
            }
        } else if (useXML) {
            out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"SniffTransformServlet.Log.CoundNotFindSpecPipeline", (String[])new String[]{pipelineName})).getXml());
        } else {
            out.println("<H1>" + Encode.forHtml((String)BaseMessages.getString(PKG, (String)"SniffTransformServlet.Log.CoundNotFindPipeline", (String[])new String[]{pipelineName})) + "</H1>");
            out.println("<a href=\"" + this.convertContextPath("/hop/status") + "\">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
        }
    }

    public String toString() {
        return "Sniff Transform";
    }

    @Override
    public String getService() {
        return "/hop/sniffTransform (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

