/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.sqs;

import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.MessageSystemAttributeName;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class SqsMessageCoder
extends AtomicCoder<Message> {
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized String> STRING_CODER = StringUtf8Coder.of();
    private static final @UnknownKeyFor @NonNull @Initialized NullableCoder<@UnknownKeyFor @NonNull @Initialized String> OPT_STRING_CODER = NullableCoder.of((Coder)StringUtf8Coder.of());
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Message> INSTANCE = new SqsMessageCoder();

    static @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Message> of() {
        return INSTANCE;
    }

    private SqsMessageCoder() {
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized Message value, @UnknownKeyFor @NonNull @Initialized OutputStream out) throws @UnknownKeyFor @NonNull @Initialized IOException {
        STRING_CODER.encode((Object)value.getMessageId(), out);
        STRING_CODER.encode((Object)value.getReceiptHandle(), out);
        OPT_STRING_CODER.encode((Object)value.getBody(), out);
        OPT_STRING_CODER.encode((Object)((String)value.getAttributes().get(MessageSystemAttributeName.SentTimestamp.toString())), out);
        MessageAttributeValue reqTime = (MessageAttributeValue)value.getMessageAttributes().get("requestTimeMsSinceEpoch");
        OPT_STRING_CODER.encode((Object)(reqTime != null ? reqTime.getStringValue() : null), out);
    }

    public @UnknownKeyFor @NonNull @Initialized Message decode(@UnknownKeyFor @NonNull @Initialized InputStream in) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String reqTime;
        Message msg = new Message();
        msg.setMessageId((String)STRING_CODER.decode(in));
        msg.setReceiptHandle((String)STRING_CODER.decode(in));
        @NonNull String body = (String)OPT_STRING_CODER.decode(in);
        msg.setBody(body);
        String sentAt = (String)OPT_STRING_CODER.decode(in);
        if (sentAt != null) {
            msg.addAttributesEntry(MessageSystemAttributeName.SentTimestamp.toString(), sentAt);
        }
        if ((reqTime = (String)OPT_STRING_CODER.decode(in)) != null) {
            msg.addMessageAttributesEntry("requestTimeMsSinceEpoch", new MessageAttributeValue().withStringValue(reqTime));
        }
        return msg;
    }
}

