/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.coders;

import com.amazonaws.ResponseMetadata;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.SdkHttpMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Optional;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class AwsCoders {
    private AwsCoders() {
    }

    public static @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ResponseMetadata> responseMetadata() {
        return ResponseMetadataCoder.of();
    }

    public static @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized SdkHttpMetadata> sdkHttpMetadata() {
        return new SdkHttpMetadataCoder(true);
    }

    public static @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized SdkHttpMetadata> sdkHttpMetadataWithoutHeaders() {
        return new SdkHttpMetadataCoder(false);
    }

    private static class SdkHttpMetadataCoder
    extends CustomCoder<SdkHttpMetadata> {
        private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Integer> STATUS_CODE_CODER = VarIntCoder.of();
        private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> HEADERS_ENCODER = NullableCoder.of((Coder)MapCoder.of((Coder)StringUtf8Coder.of(), (Coder)StringUtf8Coder.of()));
        private final @UnknownKeyFor @NonNull @Initialized boolean includeHeaders;

        protected SdkHttpMetadataCoder(@UnknownKeyFor @NonNull @Initialized boolean includeHeaders) {
            this.includeHeaders = includeHeaders;
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized SdkHttpMetadata value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            STATUS_CODE_CODER.encode((Object)value.getHttpStatusCode(), outStream);
            if (this.includeHeaders) {
                HEADERS_ENCODER.encode((Object)value.getHttpHeaders(), outStream);
            }
        }

        public @UnknownKeyFor @NonNull @Initialized SdkHttpMetadata decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            int httpStatusCode = (Integer)STATUS_CODE_CODER.decode(inStream);
            HttpResponse httpResponse = new HttpResponse(null, null);
            httpResponse.setStatusCode(httpStatusCode);
            if (this.includeHeaders) {
                Optional.ofNullable((Map)HEADERS_ENCODER.decode(inStream)).ifPresent(headers -> headers.keySet().forEach(k -> httpResponse.addHeader(k, (String)headers.get(k))));
            }
            return SdkHttpMetadata.from((HttpResponse)httpResponse);
        }

        public void verifyDeterministic() throws // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            STATUS_CODE_CODER.verifyDeterministic();
            if (this.includeHeaders) {
                HEADERS_ENCODER.verifyDeterministic();
            }
        }
    }

    private static class ResponseMetadataCoder
    extends AtomicCoder<ResponseMetadata> {
        private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> METADATA_ENCODER = NullableCoder.of((Coder)MapCoder.of((Coder)StringUtf8Coder.of(), (Coder)StringUtf8Coder.of()));
        private static final @UnknownKeyFor @NonNull @Initialized ResponseMetadataCoder INSTANCE = new ResponseMetadataCoder();

        private ResponseMetadataCoder() {
        }

        public static @UnknownKeyFor @NonNull @Initialized ResponseMetadataCoder of() {
            return INSTANCE;
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized ResponseMetadata value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            METADATA_ENCODER.encode((Object)ImmutableMap.of((Object)"AWS_REQUEST_ID", (Object)value.getRequestId()), outStream);
        }

        public @UnknownKeyFor @NonNull @Initialized ResponseMetadata decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            return new ResponseMetadata((Map)METADATA_ENCODER.decode(inStream));
        }
    }
}

