/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.pgbulkloader;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.IProvidesDatabaseConnectionInformation;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.pgbulkloader.PGBulkLoader;
import org.apache.hop.pipeline.transforms.pgbulkloader.PGBulkLoaderData;
import org.apache.hop.pipeline.transforms.pgbulkloader.PGBulkLoaderMappingMeta;

@Transform(id="PGBulkLoader", image="PGBulkLoader.svg", description="i18n::PGBulkLoader.Description", name="i18n::PGBulkLoader.Name", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Bulk", keywords={"i18n::PGBulkLoaderMeta.keyword"}, documentationUrl="/pipeline/transforms/postgresbulkloader.html", classLoaderGroup="postgres-db", isIncludeJdbcDrivers=true)
public class PGBulkLoaderMeta
extends BaseTransformMeta<PGBulkLoader, PGBulkLoaderData>
implements IProvidesDatabaseConnectionInformation {
    private static final Class<?> PKG = PGBulkLoaderMeta.class;
    @HopMetadataProperty(key="schema", injectionKeyDescription="PGBulkLoader.Injection.Schema.Label")
    private String schemaName;
    @HopMetadataProperty(key="table", injectionKeyDescription="PGBulkLoader.Injection.Table.Label")
    private String tableName;
    @HopMetadataProperty(key="connection", storeWithName=true, injectionKeyDescription="PGBulkLoader.Injection.Connection.Label")
    private DatabaseMeta databaseMeta;
    @HopMetadataProperty(key="mapping", injectionGroupKey="mapping", injectionGroupDescription="PGBulkLoader.Injection.Mapping.Label")
    private List<PGBulkLoaderMappingMeta> mappings;
    @HopMetadataProperty(key="load_action", injectionKeyDescription="PGBulkLoader.Injection.LoadAction.Label")
    private String loadAction;
    @HopMetadataProperty(key="db_override", injectionKeyDescription="PGBulkLoader.Injection.DBOverride.Label")
    private String dbNameOverride;
    @HopMetadataProperty(key="delimiter", injectionKeyDescription="PGBulkLoader.Injection.Delimiter.Label")
    private String delimiter;
    @HopMetadataProperty(key="enclosure", injectionKeyDescription="PGBulkLoader.Injection.Enclosure.Label")
    private String enclosure;
    @HopMetadataProperty(key="stop_on_error", injectionKeyDescription="PGBulkLoader.Injection.StopOnError.Label")
    private boolean stopOnError;
    public static final String ACTION_INSERT = "INSERT";
    public static final String ACTION_TRUNCATE = "TRUNCATE";
    public static final String DATE_MASK_PASS_THROUGH = "PASS THROUGH";
    public static final String DATE_MASK_DATE = "DATE";
    public static final String DATE_MASK_DATETIME = "DATETIME";
    public static final int NR_DATE_MASK_PASS_THROUGH = 0;
    public static final int NR_DATE_MASK_DATE = 1;
    public static final int NR_DATE_MASK_DATETIME = 2;

    public void setDefault() {
        this.databaseMeta = null;
        this.schemaName = "";
        this.tableName = BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.DefaultTableName", (String[])new String[0]);
        this.dbNameOverride = "";
        this.delimiter = ";";
        this.enclosure = "\"";
        this.stopOnError = false;
        this.mappings = new ArrayList<PGBulkLoaderMappingMeta>();
    }

    public void getFields(IRowMeta rowMeta, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        Object errorMessage = "";
        if (this.databaseMeta != null) {
            Database db = new Database(loggingObject, variables, this.databaseMeta);
            try {
                boolean errorFound;
                boolean first;
                db.connect();
                if (!Utils.isEmpty((CharSequence)this.tableName)) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.TableNameOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    first = true;
                    errorFound = false;
                    errorMessage = "";
                    String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(variables, this.schemaName, this.tableName);
                    IRowMeta r = db.getTableFields(schemaTable);
                    if (r != null) {
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.TableExists", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        first = true;
                        errorFound = false;
                        errorMessage = "";
                        for (int i = 0; i < this.mappings.size(); ++i) {
                            String field = this.mappings.get(i).getFieldTable();
                            IValueMeta v = r.searchValueMeta(field);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.MissingFieldsToLoadInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            errorFound = true;
                            errorMessage = (String)errorMessage + "\t\t" + field + Const.CR;
                        }
                        cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.AllFieldsFoundInTargetTable", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    } else {
                        errorMessage = BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                        cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.TransformReceivingDatas", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    first = true;
                    errorMessage = "";
                    errorFound = false;
                    for (int i = 0; i < this.mappings.size(); ++i) {
                        IValueMeta v = prev.searchValueMeta(this.mappings.get(i).getFieldStream());
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.MissingFieldsInInput", (String[])new String[0]) + Const.CR;
                        }
                        errorFound = true;
                        errorMessage = (String)errorMessage + "\t\t" + this.mappings.get(i).getFieldStream() + Const.CR;
                    }
                    cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.AllFieldsFoundInInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                errorMessage = BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.MissingFieldsInInput3", (String[])new String[0]) + Const.CR;
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            catch (HopException e) {
                errorMessage = BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.DatabaseErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.TransformReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.NoInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public SqlStatement getSqlStatements(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, IHopMetadataProvider metadataProvider) throws HopTransformException {
        SqlStatement retval;
        block11: {
            retval = new SqlStatement(transformMeta.getName(), this.databaseMeta, null);
            if (this.databaseMeta != null) {
                if (prev != null && prev.size() > 0) {
                    RowMeta tableFields = new RowMeta();
                    for (int i = 0; i < this.mappings.size(); ++i) {
                        IValueMeta v = prev.searchValueMeta(this.mappings.get(i).getFieldStream());
                        if (v == null) {
                            throw new HopTransformException("Unable to find field [" + this.mappings.get(i).getFieldStream() + "] in the input rows");
                        }
                        IValueMeta tableField = v.clone();
                        tableField.setName(this.mappings.get(i).getFieldTable());
                        tableFields.addValueMeta(tableField);
                    }
                    if (!Utils.isEmpty((CharSequence)this.tableName)) {
                        Database db = new Database(loggingObject, variables, this.databaseMeta);
                        try {
                            db.connect();
                            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(variables, this.schemaName, this.tableName);
                            String sql = db.getDDL(schemaTable, (IRowMeta)tableFields, null, false, null, true);
                            if (sql.length() == 0) {
                                retval.setSql(null);
                                break block11;
                            }
                            retval.setSql(sql);
                        }
                        catch (HopException e) {
                            retval.setError(BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.GetSQL.ErrorOccurred", (String[])new String[0]) + e.getMessage());
                        }
                    } else {
                        retval.setError(BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.GetSQL.NoTableDefinedOnConnection", (String[])new String[0]));
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.GetSQL.NotReceivingAnyFields", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.GetSQL.NoConnectionDefined", (String[])new String[0]));
            }
        }
        return retval;
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (prev != null) {
            for (int i = 0; i < this.mappings.size(); ++i) {
                IValueMeta v = prev.searchValueMeta(this.mappings.get(i).getFieldStream());
                DatabaseImpact ii = new DatabaseImpact(3, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), variables.resolve(this.tableName), this.mappings.get(i).getFieldTable(), this.mappings.get(i).getFieldStream(), v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRowMeta getRequiredFields(IVariables variables) throws HopException {
        String realTableName = variables.resolve(this.tableName);
        String realSchemaName = variables.resolve(this.schemaName);
        if (this.databaseMeta == null) throw new HopException(BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        Database db = new Database(loggingObject, variables, this.databaseMeta);
        try {
            db.connect();
            if (Utils.isEmpty((CharSequence)realTableName)) throw new HopException(BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.Exception.TableNotSpecified", (String[])new String[0]));
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(variables, realSchemaName, realTableName);
            if (db.checkTableExists(realSchemaName, realTableName)) {
                IRowMeta iRowMeta = db.getTableFields(schemaTable);
                return iRowMeta;
            }
            try {
                throw new HopException(BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new HopException(BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        finally {
            db.disconnect();
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setLoadAction(String action) {
        this.loadAction = action;
    }

    public String getLoadAction() {
        return this.loadAction;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getEnclosure() {
        return this.enclosure;
    }

    public String getDbNameOverride() {
        return this.dbNameOverride;
    }

    public void setDbNameOverride(String dbNameOverride) {
        this.dbNameOverride = dbNameOverride;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    public String getMissingDatabaseConnectionInformationMessage() {
        return null;
    }

    public boolean isStopOnError() {
        return this.stopOnError;
    }

    public void setStopOnError(Boolean value) {
        this.stopOnError = value;
    }

    public void setStopOnError(boolean value) {
        this.stopOnError = value;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<PGBulkLoaderMappingMeta> getMappings() {
        return this.mappings;
    }

    public void setMappings(List<PGBulkLoaderMappingMeta> mappings) {
        this.mappings = mappings;
    }
}

