/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery.providers;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.io.gcp.bigquery.providers.AutoValue_BigQueryStorageWriteApiSchemaTransformProvider_BigQueryStorageWriteApiSchemaTransformConfiguration;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={SchemaTransformProvider.class})
public class BigQueryStorageWriteApiSchemaTransformProvider
extends TypedSchemaTransformProvider<BigQueryStorageWriteApiSchemaTransformConfiguration> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigQueryStorageWriteApiSchemaTransformProvider.class);
    private static final @UnknownKeyFor @NonNull @Initialized Integer DEFAULT_TRIGGER_FREQUENCY_SECS = 5;
    private static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_TRIGGERING_FREQUENCY = Duration.standardSeconds((long)DEFAULT_TRIGGER_FREQUENCY_SECS.intValue());
    private static final @UnknownKeyFor @NonNull @Initialized String INPUT_ROWS_TAG = "input";
    private static final @UnknownKeyFor @NonNull @Initialized String FAILED_ROWS_TAG = "FailedRows";
    private static final @UnknownKeyFor @NonNull @Initialized String FAILED_ROWS_WITH_ERRORS_TAG = "FailedRowsWithErrors";

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized BigQueryStorageWriteApiSchemaTransformConfiguration> configurationClass() {
        return BigQueryStorageWriteApiSchemaTransformConfiguration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized BigQueryStorageWriteApiSchemaTransformConfiguration configuration) {
        return new BigQueryStorageWriteApiSchemaTransform(configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return String.format("beam:schematransform:org.apache.beam:bigquery_storage_write:v1", new Object[0]);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList(INPUT_ROWS_TAG);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Arrays.asList(FAILED_ROWS_TAG, FAILED_ROWS_WITH_ERRORS_TAG, "errors");
    }

    protected static class BigQueryStorageWriteApiSchemaTransform
    extends SchemaTransform {
        private @UnknownKeyFor @NonNull @Initialized BigQueryServices testBigQueryServices = null;
        private final @UnknownKeyFor @NonNull @Initialized BigQueryStorageWriteApiSchemaTransformConfiguration configuration;

        BigQueryStorageWriteApiSchemaTransform(@UnknownKeyFor @NonNull @Initialized BigQueryStorageWriteApiSchemaTransformConfiguration configuration) {
            configuration.validate();
            this.configuration = configuration;
        }

        @VisibleForTesting
        public void setBigQueryServices(@UnknownKeyFor @NonNull @Initialized BigQueryServices testBigQueryServices) {
            this.testBigQueryServices = testBigQueryServices;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            Preconditions.checkArgument((boolean)input.has(BigQueryStorageWriteApiSchemaTransformProvider.INPUT_ROWS_TAG), (String)"Missing expected input tag: %s", (Object)BigQueryStorageWriteApiSchemaTransformProvider.INPUT_ROWS_TAG);
            PCollection inputRows = input.get(BigQueryStorageWriteApiSchemaTransformProvider.INPUT_ROWS_TAG);
            BigQueryIO.Write<Row> write = this.createStorageWriteApiTransform();
            if (inputRows.isBounded() == PCollection.IsBounded.UNBOUNDED) {
                Long triggeringFrequency = this.configuration.getTriggeringFrequencySeconds();
                Boolean autoSharding = this.configuration.getAutoSharding();
                write = write.withTriggeringFrequency(triggeringFrequency == null || triggeringFrequency <= 0L ? DEFAULT_TRIGGERING_FREQUENCY : Duration.standardSeconds((long)triggeringFrequency));
                if (autoSharding == null || autoSharding.booleanValue()) {
                    write = write.withAutoSharding();
                }
            }
            Schema inputSchema = inputRows.getSchema();
            if (write.getTable() != null) {
                TableReference tableRef = (TableReference)write.getTable().get();
                this.validateSchema(input.getPipeline().getOptions(), inputSchema, tableRef);
            }
            WriteResult result = (WriteResult)((PCollection)inputRows.apply("element-count", (PTransform)ParDo.of((DoFn)new ElementCounterFn("BigQuery-write-element-counter")))).setRowSchema(inputSchema).apply(write);
            Schema rowSchema = inputRows.getSchema();
            Schema errorSchema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"failed_row", (Schema.FieldType)Schema.FieldType.row((Schema)rowSchema)), Schema.Field.of((String)"error_message", (Schema.FieldType)Schema.FieldType.STRING)});
            PCollection failedRows = ((PCollection)result.getFailedStorageApiInserts().apply("Construct failed rows", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.rows()).via((SerializableFunction & Serializable)storageError -> BigQueryUtils.toBeamRow(rowSchema, storageError.getRow())))).setRowSchema(rowSchema);
            PCollection failedRowsWithErrors = ((PCollection)result.getFailedStorageApiInserts().apply("Construct failed rows and errors", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.rows()).via((SerializableFunction & Serializable)storageError -> Row.withSchema((Schema)errorSchema).withFieldValue("error_message", (Object)storageError.getErrorMessage()).withFieldValue("failed_row", (Object)BigQueryUtils.toBeamRow(rowSchema, storageError.getRow())).build()))).setRowSchema(errorSchema);
            PCollection failedRowsOutput = ((PCollection)failedRows.apply("error-count", (PTransform)ParDo.of((DoFn)new ElementCounterFn("BigQuery-write-error-counter")))).setRowSchema(rowSchema);
            return PCollectionRowTuple.of((String)BigQueryStorageWriteApiSchemaTransformProvider.FAILED_ROWS_TAG, (PCollection)failedRowsOutput).and(BigQueryStorageWriteApiSchemaTransformProvider.FAILED_ROWS_WITH_ERRORS_TAG, failedRowsWithErrors).and("errors", failedRowsWithErrors);
        }

        @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write<@UnknownKeyFor @NonNull @Initialized Row> createStorageWriteApiTransform() {
            BigQueryIO.Write.Method writeMethod = this.configuration.getUseAtLeastOnceSemantics() != null && this.configuration.getUseAtLeastOnceSemantics() != false ? BigQueryIO.Write.Method.STORAGE_API_AT_LEAST_ONCE : BigQueryIO.Write.Method.STORAGE_WRITE_API;
            BigQueryIO.Write<Row> write = BigQueryIO.write().to(this.configuration.getTable()).withMethod(writeMethod).useBeamSchema().withFormatFunction(BigQueryUtils.toTableRow()).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND);
            if (!Strings.isNullOrEmpty((String)this.configuration.getCreateDisposition())) {
                BigQueryIO.Write.CreateDisposition createDisposition = BigQueryStorageWriteApiSchemaTransformConfiguration.CREATE_DISPOSITIONS.get(this.configuration.getCreateDisposition().toUpperCase());
                write = write.withCreateDisposition(createDisposition);
            }
            if (!Strings.isNullOrEmpty((String)this.configuration.getWriteDisposition())) {
                BigQueryIO.Write.WriteDisposition writeDisposition = BigQueryStorageWriteApiSchemaTransformConfiguration.WRITE_DISPOSITIONS.get(this.configuration.getWriteDisposition().toUpperCase());
                write = write.withWriteDisposition(writeDisposition);
            }
            if (this.testBigQueryServices != null) {
                write = write.withTestServices(this.testBigQueryServices);
            }
            return write;
        }

        private void validateSchema(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, @UnknownKeyFor @NonNull @Initialized Schema inputSchema, @UnknownKeyFor @NonNull @Initialized TableReference tableRef) {
            LOG.info("Validating schema ...");
            BigQueryOptions options = (BigQueryOptions)pipelineOptions.as(BigQueryOptions.class);
            try {
                Table table = null;
                if (this.testBigQueryServices != null) {
                    BigQueryServices.DatasetService datasetService = this.testBigQueryServices.getDatasetService(options);
                    if (datasetService != null) {
                        table = datasetService.getTable(tableRef);
                    }
                } else {
                    table = BigQueryHelpers.getTable(options, tableRef);
                }
                if (table == null) {
                    LOG.info("Table [{}] not found, skipping schema validation.", (Object)tableRef.getTableId());
                    return;
                }
                Schema outputSchema = BigQueryUtils.fromTableSchema(table.getSchema());
                if (!inputSchema.assignableToIgnoreNullable(outputSchema)) {
                    throw new IllegalArgumentException("Input schema is not assignable to output schema. Input schema=" + inputSchema + ", Output schema=" + outputSchema);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private static class ElementCounterFn
        extends DoFn<Row, Row> {
            private @UnknownKeyFor @NonNull @Initialized Counter bqGenericElementCounter;
            private @UnknownKeyFor @NonNull @Initialized Long elementsInBundle = 0L;

            ElementCounterFn(@UnknownKeyFor @NonNull @Initialized String name) {
                this.bqGenericElementCounter = Metrics.counter(BigQueryStorageWriteApiSchemaTransform.class, (String)name);
            }

            @DoFn.ProcessElement
            public void process(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                this.elementsInBundle = this.elementsInBundle + 1L;
                c.output((Object)((Row)c.element()));
            }

            @DoFn.FinishBundle
            public void finish(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c) {
                this.bqGenericElementCounter.inc(this.elementsInBundle.longValue());
                this.elementsInBundle = 0L;
            }
        }
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class BigQueryStorageWriteApiSchemaTransformConfiguration {
        static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition> CREATE_DISPOSITIONS = ImmutableMap.builder().put((Object)BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED.name(), (Object)BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).put((Object)BigQueryIO.Write.CreateDisposition.CREATE_NEVER.name(), (Object)BigQueryIO.Write.CreateDisposition.CREATE_NEVER).build();
        static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.WriteDisposition> WRITE_DISPOSITIONS = ImmutableMap.builder().put((Object)BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE.name(), (Object)BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE).put((Object)BigQueryIO.Write.WriteDisposition.WRITE_EMPTY.name(), (Object)BigQueryIO.Write.WriteDisposition.WRITE_EMPTY).put((Object)BigQueryIO.Write.WriteDisposition.WRITE_APPEND.name(), (Object)BigQueryIO.Write.WriteDisposition.WRITE_APPEND).build();

        public void validate() {
            String invalidConfigMessage = "Invalid BigQuery Storage Write configuration: ";
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getTable()) ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Table spec for a BigQuery Write must be specified."));
            Preconditions.checkNotNull((Object)BigQueryHelpers.parseTableSpec(this.getTable()));
            if (!Strings.isNullOrEmpty((String)this.getCreateDisposition())) {
                Preconditions.checkNotNull((Object)((Object)CREATE_DISPOSITIONS.get(this.getCreateDisposition().toUpperCase())), (String)(invalidConfigMessage + "Invalid create disposition (%s) was specified. Available dispositions are: %s"), (Object)this.getCreateDisposition(), CREATE_DISPOSITIONS.keySet());
            }
            if (!Strings.isNullOrEmpty((String)this.getWriteDisposition())) {
                Preconditions.checkNotNull((Object)((Object)WRITE_DISPOSITIONS.get(this.getWriteDisposition().toUpperCase())), (String)(invalidConfigMessage + "Invalid write disposition (%s) was specified. Available dispositions are: %s"), (Object)this.getWriteDisposition(), WRITE_DISPOSITIONS.keySet());
            }
        }

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_BigQueryStorageWriteApiSchemaTransformProvider_BigQueryStorageWriteApiSchemaTransformConfiguration.Builder();
        }

        @SchemaFieldDescription(value="The bigquery table to write to. Format: [${PROJECT}:]${DATASET}.${TABLE}")
        public abstract @UnknownKeyFor @NonNull @Initialized String getTable();

        @SchemaFieldDescription(value="Optional field that specifies whether the job is allowed to create new tables. The following values are supported: CREATE_IF_NEEDED (the job may create the table), CREATE_NEVER (the job must fail if the table does not exist already).")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String getCreateDisposition();

        @SchemaFieldDescription(value="Specifies the action that occurs if the destination table already exists. The following values are supported: WRITE_TRUNCATE (overwrites the table data), WRITE_APPEND (append the data to the table), WRITE_EMPTY (job must fail if the table is not empty).")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String getWriteDisposition();

        @SchemaFieldDescription(value="Determines how often to 'commit' progress into BigQuery. Default is every 5 seconds.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized Long getTriggeringFrequencySeconds();

        @SchemaFieldDescription(value="This option enables lower latency for insertions to BigQuery but may ocassionally duplicate data elements.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized Boolean getUseAtLeastOnceSemantics();

        @SchemaFieldDescription(value="This option enables using a dynamically determined number of shards to write to BigQuery. Only applicable to unbounded data.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized Boolean getAutoSharding();

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setTable(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setCreateDisposition(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setWriteDisposition(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setTriggeringFrequencySeconds(@UnknownKeyFor @NonNull @Initialized Long var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setUseAtLeastOnceSemantics(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setAutoSharding(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            public abstract @UnknownKeyFor @NonNull @Initialized BigQueryStorageWriteApiSchemaTransformConfiguration build();
        }
    }
}

