/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.cloud.bigquery.storage.v1.TableFieldSchema;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.apache.beam.sdk.io.gcp.bigquery.BeamRowToStorageApiProto;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiCDC;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Functions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Days;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class AvroGenericRecordToStorageApiProto {
    static final @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Type, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Type> PRIMITIVE_TYPES = ImmutableMap.builder().put((Object)Schema.Type.INT, (Object)TableFieldSchema.Type.INT64).put((Object)Schema.Type.FIXED, (Object)TableFieldSchema.Type.BYTES).put((Object)Schema.Type.LONG, (Object)TableFieldSchema.Type.INT64).put((Object)Schema.Type.FLOAT, (Object)TableFieldSchema.Type.DOUBLE).put((Object)Schema.Type.DOUBLE, (Object)TableFieldSchema.Type.DOUBLE).put((Object)Schema.Type.STRING, (Object)TableFieldSchema.Type.STRING).put((Object)Schema.Type.BOOLEAN, (Object)TableFieldSchema.Type.BOOL).put((Object)Schema.Type.ENUM, (Object)TableFieldSchema.Type.STRING).put((Object)Schema.Type.BYTES, (Object)TableFieldSchema.Type.BYTES).build();
    static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Type> LOGICAL_TYPES = ImmutableMap.builder().put((Object)LogicalTypes.date().getName(), (Object)TableFieldSchema.Type.DATE).put((Object)LogicalTypes.decimal((int)1).getName(), (Object)TableFieldSchema.Type.BIGNUMERIC).put((Object)LogicalTypes.timestampMicros().getName(), (Object)TableFieldSchema.Type.TIMESTAMP).put((Object)LogicalTypes.timestampMillis().getName(), (Object)TableFieldSchema.Type.TIMESTAMP).put((Object)LogicalTypes.uuid().getName(), (Object)TableFieldSchema.Type.STRING).build();
    static final @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Type, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> PRIMITIVE_ENCODERS = ImmutableMap.builder().put((Object)Schema.Type.INT, o -> (long)((Integer)o).intValue()).put((Object)Schema.Type.FIXED, o -> ByteString.copyFrom((byte[])((GenericData.Fixed)o).bytes())).put((Object)Schema.Type.LONG, (Object)Functions.identity()).put((Object)Schema.Type.FLOAT, o -> Double.parseDouble(Float.valueOf(((Float)o).floatValue()).toString())).put((Object)Schema.Type.DOUBLE, Function.identity()).put((Object)Schema.Type.STRING, Object::toString).put((Object)Schema.Type.BOOLEAN, Function.identity()).put((Object)Schema.Type.ENUM, o -> o.toString()).put((Object)Schema.Type.BYTES, o -> ByteString.copyFrom((byte[])((byte[])o))).build();
    static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BiFunction<@UnknownKeyFor @NonNull @Initialized LogicalType, @UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> LOGICAL_TYPE_ENCODERS = ImmutableMap.builder().put((Object)LogicalTypes.date().getName(), (logicalType, value) -> AvroGenericRecordToStorageApiProto.convertDate(value)).put((Object)LogicalTypes.decimal((int)1).getName(), AvroGenericRecordToStorageApiProto::convertDecimal).put((Object)LogicalTypes.timestampMicros().getName(), (logicalType, value) -> AvroGenericRecordToStorageApiProto.convertTimestamp(value, true)).put((Object)LogicalTypes.timestampMillis().getName(), (logicalType, value) -> AvroGenericRecordToStorageApiProto.convertTimestamp(value, false)).put((Object)LogicalTypes.uuid().getName(), (logicalType, value) -> AvroGenericRecordToStorageApiProto.convertUUID(value)).build();

    static @UnknownKeyFor @NonNull @Initialized String convertUUID(@UnknownKeyFor @NonNull @Initialized Object value) {
        if (value instanceof UUID) {
            return ((UUID)value).toString();
        }
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)(value instanceof String), (Object)"Expecting a value as String type.");
        UUID.fromString((String)value);
        return (String)value;
    }

    static @UnknownKeyFor @NonNull @Initialized Long convertTimestamp(@UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized boolean micros) {
        if (value instanceof ReadableInstant) {
            return ((ReadableInstant)value).getMillis() * (long)(micros ? 1000 : 1);
        }
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)(value instanceof Long), (Object)"Expecting a value as Long type (millis).");
        return (Long)value;
    }

    static @UnknownKeyFor @NonNull @Initialized Integer convertDate(@UnknownKeyFor @NonNull @Initialized Object value) {
        if (value instanceof ReadableInstant) {
            return Days.daysBetween((ReadableInstant)Instant.EPOCH, (ReadableInstant)((ReadableInstant)value)).getDays();
        }
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)(value instanceof Integer), (Object)"Expecting a value as Integer type (days).");
        return (Integer)value;
    }

    static @UnknownKeyFor @NonNull @Initialized ByteString convertDecimal(@UnknownKeyFor @NonNull @Initialized LogicalType logicalType, @UnknownKeyFor @NonNull @Initialized Object value) {
        ByteBuffer byteBuffer = (ByteBuffer)value;
        BigDecimal bigDecimal = new Conversions.DecimalConversion().fromBytes(byteBuffer.duplicate(), Schema.create((Schema.Type)Schema.Type.NULL), logicalType);
        return BeamRowToStorageApiProto.serializeBigDecimalToNumeric(bigDecimal);
    }

    public static @UnknownKeyFor @NonNull @Initialized TableSchema protoTableSchemaFromAvroSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((!schema.getFields().isEmpty() ? 1 : 0) != 0);
        TableSchema.Builder builder = TableSchema.newBuilder();
        for (Schema.Field field : schema.getFields()) {
            builder.addFields(AvroGenericRecordToStorageApiProto.fieldDescriptorFromAvroField(field));
        }
        return builder.build();
    }

    public static @UnknownKeyFor @NonNull @Initialized DynamicMessage messageFromGenericRecord(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor, @UnknownKeyFor @NonNull @Initialized GenericRecord record, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized String changeType, @UnknownKeyFor @NonNull @Initialized long changeSequenceNum) {
        Schema schema = record.getSchema();
        DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        for (Schema.Field field : schema.getFields()) {
            Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)descriptor.findFieldByName(field.name().toLowerCase()));
            Object value = AvroGenericRecordToStorageApiProto.messageValueFromGenericRecordValue(fieldDescriptor, field, field.name(), record);
            if (value == null) continue;
            builder.setField(fieldDescriptor, value);
        }
        if (changeType != null) {
            builder.setField((Descriptors.FieldDescriptor)Preconditions.checkStateNotNull((Object)descriptor.findFieldByName("_CHANGE_TYPE")), (Object)changeType);
            builder.setField((Descriptors.FieldDescriptor)Preconditions.checkStateNotNull((Object)descriptor.findFieldByName("_CHANGE_SEQUENCE_NUMBER")), (Object)changeSequenceNum);
        }
        return builder.build();
    }

    private static @UnknownKeyFor @NonNull @Initialized TableFieldSchema fieldDescriptorFromAvroField(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field field) {
        Schema schema = field.schema();
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)schema, (Object)"Unexpected null schema!");
        if (StorageApiCDC.COLUMNS.contains(field.name())) {
            throw new RuntimeException("Reserved field name " + field.name() + " in user schema.");
        }
        TableFieldSchema.Builder builder = TableFieldSchema.newBuilder().setName(field.name().toLowerCase());
        Schema elementType = null;
        switch (schema.getType()) {
            case RECORD: {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((!schema.getFields().isEmpty() ? 1 : 0) != 0);
                builder = builder.setType(TableFieldSchema.Type.STRUCT);
                for (Schema.Field recordField : schema.getFields()) {
                    builder = builder.addFields(AvroGenericRecordToStorageApiProto.fieldDescriptorFromAvroField(recordField));
                }
                break;
            }
            case ARRAY: {
                elementType = AvroUtils.TypeWithNullability.create((Schema)schema.getElementType()).getType();
                if (elementType == null) {
                    throw new RuntimeException("Unexpected null element type!");
                }
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((elementType.getType() != Schema.Type.ARRAY ? 1 : 0) != 0, (Object)"Nested arrays not supported by BigQuery.");
                TableFieldSchema elementFieldSchema = AvroGenericRecordToStorageApiProto.fieldDescriptorFromAvroField(new Schema.Field(field.name(), elementType, field.doc(), field.defaultVal()));
                builder = builder.setType(elementFieldSchema.getType());
                builder.addAllFields((Iterable)elementFieldSchema.getFieldsList());
                builder = builder.setMode(TableFieldSchema.Mode.REPEATED);
                break;
            }
            case MAP: {
                Schema keyType = Schema.create((Schema.Type)Schema.Type.STRING);
                Schema valueType = AvroUtils.TypeWithNullability.create((Schema)schema.getElementType()).getType();
                if (valueType == null) {
                    throw new RuntimeException("Unexpected null element type!");
                }
                TableFieldSchema keyFieldSchema = AvroGenericRecordToStorageApiProto.fieldDescriptorFromAvroField(new Schema.Field("key", keyType, "key of the map entry", (Object)Schema.Field.NULL_VALUE));
                TableFieldSchema valueFieldSchema = AvroGenericRecordToStorageApiProto.fieldDescriptorFromAvroField(new Schema.Field("value", valueType, "value of the map entry", (Object)Schema.Field.NULL_VALUE));
                builder = builder.setType(TableFieldSchema.Type.STRUCT).addFields(keyFieldSchema).addFields(valueFieldSchema).setMode(TableFieldSchema.Mode.REPEATED);
                break;
            }
            case UNION: {
                elementType = AvroUtils.TypeWithNullability.create((Schema)schema).getType();
                if (elementType == null) {
                    throw new RuntimeException("Unexpected null element type!");
                }
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((elementType.getType() != Schema.Type.UNION ? 1 : 0) != 0, (Object)"Multiple non-null union types are not supported.");
                TableFieldSchema unionFieldSchema = AvroGenericRecordToStorageApiProto.fieldDescriptorFromAvroField(new Schema.Field(field.name(), elementType, field.doc(), field.defaultVal()));
                builder = builder.setType(unionFieldSchema.getType()).addAllFields((Iterable)unionFieldSchema.getFieldsList());
                break;
            }
            default: {
                elementType = AvroUtils.TypeWithNullability.create((Schema)schema).getType();
                TableFieldSchema.Type primitiveType = Optional.ofNullable(LogicalTypes.fromSchema((Schema)elementType)).map(logicalType -> LOGICAL_TYPES.get(logicalType.getName())).orElse(PRIMITIVE_TYPES.get(elementType.getType()));
                if (primitiveType == null) {
                    throw new RuntimeException("Unsupported type " + elementType.getType());
                }
                builder = builder.setType(primitiveType);
            }
        }
        if (builder.getMode() != TableFieldSchema.Mode.REPEATED) {
            builder = AvroUtils.TypeWithNullability.create((Schema)schema).isNullable() != false ? builder.setMode(TableFieldSchema.Mode.NULLABLE) : builder.setMode(TableFieldSchema.Mode.REQUIRED);
        }
        if (field.doc() != null) {
            builder = builder.setDescription(field.doc());
        }
        return builder.build();
    }

    @javax.annotation.Nullable
    private static @UnknownKeyFor @Nullable @Initialized Object messageValueFromGenericRecordValue(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field avroField, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized GenericRecord record) {
        Object value = record.get(name);
        if (value == null) {
            if (fieldDescriptor.isOptional()) {
                return null;
            }
            throw new IllegalArgumentException("Received null value for non-nullable field " + fieldDescriptor.getName());
        }
        return AvroGenericRecordToStorageApiProto.toProtoValue(fieldDescriptor, avroField.schema(), value);
    }

    private static @UnknownKeyFor @NonNull @Initialized Object toProtoValue(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, @UnknownKeyFor @NonNull @Initialized Schema avroSchema, @UnknownKeyFor @NonNull @Initialized Object value) {
        switch (avroSchema.getType()) {
            case RECORD: {
                return AvroGenericRecordToStorageApiProto.messageFromGenericRecord(fieldDescriptor.getMessageType(), (GenericRecord)value, null, -1L);
            }
            case ARRAY: {
                Iterable iterable = (Iterable)value;
                Schema arrayElementType = avroSchema.getElementType();
                if (arrayElementType == null) {
                    throw new RuntimeException("Unexpected null element type!");
                }
                return StreamSupport.stream(iterable.spliterator(), false).map(v -> AvroGenericRecordToStorageApiProto.toProtoValue(fieldDescriptor, arrayElementType, v)).collect(Collectors.toList());
            }
            case UNION: {
                AvroUtils.TypeWithNullability type = AvroUtils.TypeWithNullability.create((Schema)avroSchema);
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((type.getType().getType() != Schema.Type.UNION ? 1 : 0) != 0, (Object)"Multiple non-null union types are not supported.");
                return AvroGenericRecordToStorageApiProto.toProtoValue(fieldDescriptor, type.getType(), value);
            }
            case MAP: {
                Map map = (Map)value;
                Schema valueType = AvroUtils.TypeWithNullability.create((Schema)avroSchema.getElementType()).getType();
                if (valueType == null) {
                    throw new RuntimeException("Unexpected null element type!");
                }
                return map.entrySet().stream().map(entry -> AvroGenericRecordToStorageApiProto.mapEntryToProtoValue(fieldDescriptor.getMessageType(), valueType, entry)).collect(Collectors.toList());
            }
        }
        return AvroGenericRecordToStorageApiProto.scalarToProtoValue(avroSchema, value);
    }

    static @UnknownKeyFor @NonNull @Initialized Object mapEntryToProtoValue(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor, @UnknownKeyFor @NonNull @Initialized Schema valueFieldType, @UnknownKeyFor @NonNull @Initialized Map.Entry<@UnknownKeyFor @NonNull @Initialized CharSequence, @UnknownKeyFor @NonNull @Initialized Object> entryValue) {
        Descriptors.FieldDescriptor valueFieldDescriptor;
        Object value;
        DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        Descriptors.FieldDescriptor keyFieldDescriptor = (Descriptors.FieldDescriptor)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)descriptor.findFieldByName("key"));
        Object key = AvroGenericRecordToStorageApiProto.toProtoValue(keyFieldDescriptor, Schema.create((Schema.Type)Schema.Type.STRING), entryValue.getKey());
        if (key != null) {
            builder.setField(keyFieldDescriptor, key);
        }
        if ((value = AvroGenericRecordToStorageApiProto.toProtoValue(valueFieldDescriptor = (Descriptors.FieldDescriptor)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)descriptor.findFieldByName("value")), valueFieldType, entryValue.getValue())) != null) {
            builder.setField(valueFieldDescriptor, value);
        }
        return builder.build();
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized Object scalarToProtoValue(@UnknownKeyFor @NonNull @Initialized Schema fieldSchema, @UnknownKeyFor @NonNull @Initialized Object value) {
        AvroUtils.TypeWithNullability type = AvroUtils.TypeWithNullability.create((Schema)fieldSchema);
        LogicalType logicalType = LogicalTypes.fromSchema((Schema)type.getType());
        if (logicalType != null) {
            BiFunction<LogicalType, Object, Object> logicalTypeEncoder = LOGICAL_TYPE_ENCODERS.get(logicalType.getName());
            if (logicalTypeEncoder == null) {
                throw new IllegalArgumentException("Unsupported logical type " + logicalType.getName());
            }
            return logicalTypeEncoder.apply(logicalType, value);
        }
        Function<Object, Object> encoder = PRIMITIVE_ENCODERS.get(type.getType().getType());
        if (encoder == null) {
            throw new RuntimeException("Unexpected beam type " + fieldSchema);
        }
        return encoder.apply(value);
    }
}

