/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.util.servlet.RowMetaData;
import com.ibm.as400.util.servlet.RowMetaDataType;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class ListMetaData
implements RowMetaData,
Serializable {
    static final long serialVersionUID = -230291530342866669L;
    private int columnCount_ = 0;
    private String[] columnName_;
    private String[] columnLabel_;
    private int[] columnType_;
    private int[] columnSize_;
    private String[] columnAlignment_;
    private String[] columnDirection_;
    private transient PropertyChangeSupport changes_;
    private transient VetoableChangeSupport vetos_;

    public ListMetaData() {
    }

    public ListMetaData(int columns) {
        this();
        try {
            this.setColumns(columns);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    @Override
    public int getColumnCount() {
        return this.columnCount_;
    }

    @Override
    public int getColumnDisplaySize(int columnIndex) {
        this.validateColumnIndex(columnIndex);
        return this.columnSize_[columnIndex];
    }

    @Override
    public String getColumnLabel(int columnIndex) {
        this.validateColumnIndex(columnIndex);
        return this.columnLabel_[columnIndex];
    }

    @Override
    public String getColumnName(int columnIndex) {
        this.validateColumnIndex(columnIndex);
        return this.columnName_[columnIndex];
    }

    @Override
    public int getColumnType(int columnIndex) {
        this.validateColumnIndex(columnIndex);
        return this.columnType_[columnIndex];
    }

    @Override
    public String getColumnAlignment(int columnIndex) {
        this.validateColumnIndex(columnIndex);
        return this.columnAlignment_[columnIndex];
    }

    @Override
    public String getColumnDirection(int columnIndex) {
        this.validateColumnIndex(columnIndex);
        return this.columnDirection_[columnIndex];
    }

    @Override
    public String getColumnTypeName(int columnIndex) {
        this.validateColumnIndex(columnIndex);
        if (this.columnType_[columnIndex] != 0) {
            return RowMetaDataType.getDataTypeName(this.columnType_[columnIndex]);
        }
        return null;
    }

    @Override
    public int getPrecision(int columnIndex) {
        this.validateColumnIndex(columnIndex);
        return 0;
    }

    @Override
    public int getScale(int columnIndex) {
        this.validateColumnIndex(columnIndex);
        return 0;
    }

    @Override
    public boolean isNumericData(int columnIndex) {
        return RowMetaDataType.isNumericData(this.getColumnType(columnIndex));
    }

    @Override
    public boolean isTextData(int columnIndex) {
        return RowMetaDataType.isTextData(this.getColumnType(columnIndex));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(listener);
        }
    }

    @Override
    public void setColumnAlignment(int columnIndex, String alignment) {
        this.validateColumnIndex(columnIndex);
        if (alignment == null) {
            throw new NullPointerException("alignment");
        }
        if (!(alignment.equals("left") || alignment.equals("right") || alignment.equals("center") || alignment.equals("justify"))) {
            throw new ExtendedIllegalArgumentException("alignment", 2);
        }
        this.columnAlignment_[columnIndex] = alignment;
    }

    @Override
    public void setColumnDirection(int columnIndex, String dir) {
        this.validateColumnIndex(columnIndex);
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        this.columnDirection_[columnIndex] = dir;
    }

    public void setColumnDisplaySize(int columnIndex, int displaySize) {
        this.validateColumnIndex(columnIndex);
        if (displaySize < 1) {
            throw new ExtendedIllegalArgumentException("displaySize", 4);
        }
        this.columnSize_[columnIndex] = displaySize;
    }

    @Override
    public void setColumnLabel(int columnIndex, String label) {
        this.validateColumnIndex(columnIndex);
        if (label == null) {
            throw new NullPointerException("label");
        }
        this.columnLabel_[columnIndex] = label;
    }

    public void setColumnName(int columnIndex, String name) {
        this.validateColumnIndex(columnIndex);
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.columnName_[columnIndex] = name;
        if (this.columnLabel_[columnIndex] == null) {
            this.columnLabel_[columnIndex] = name;
        }
    }

    public void setColumns(int columns) throws PropertyVetoException {
        if (columns <= 0) {
            throw new ExtendedIllegalArgumentException("columns", 4);
        }
        int oldInt = this.columnCount_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("columns", (Object)oldInt, (Object)columns);
        }
        this.columnCount_ = columns;
        this.columnName_ = new String[this.columnCount_];
        this.columnLabel_ = new String[this.columnCount_];
        this.columnType_ = new int[this.columnCount_];
        this.columnSize_ = new int[this.columnCount_];
        this.columnAlignment_ = new String[this.columnCount_];
        this.columnDirection_ = new String[this.columnCount_];
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("columns", (Object)oldInt, (Object)columns);
        }
    }

    public void setColumnType(int columnIndex, int type) {
        this.validateColumnIndex(columnIndex);
        if (!RowMetaDataType.isDataTypeValid(type)) {
            throw new ExtendedIllegalArgumentException("type", 2);
        }
        this.columnType_[columnIndex] = type;
    }

    private void validateColumnIndex(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnCount_) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
    }
}

