/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLListItem;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.HTMLTagElement;
import com.ibm.as400.util.html.OrderedListItem;
import com.ibm.as400.util.html.UnorderedListItem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public abstract class HTMLList
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -3017041765887905594L;
    private boolean compact_ = false;
    private Vector listItems_;
    private String lang_;
    private String dir_;
    private boolean useFO_ = false;
    private int value_ = -1;
    private transient Vector elementListeners;

    public HTMLList() {
        this.listItems_ = new Vector();
    }

    public HTMLList(Vector itemList) {
        this.setItems(itemList);
    }

    public void addListItem(HTMLListItem item) {
        if (item == null) {
            throw new NullPointerException("item");
        }
        this.listItems_.addElement(item);
        this.fireElementEvent(0);
    }

    public void addList(HTMLList list) {
        if (list == null) {
            throw new NullPointerException("list");
        }
        this.listItems_.addElement(list);
        this.fireElementEvent(0);
    }

    public void addListItemElementListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners == null) {
            this.elementListeners = new Vector();
        }
        this.elementListeners.addElement(listener);
    }

    private void fireElementEvent(int evt) {
        if (this.elementListeners == null) {
            return;
        }
        Vector targets = (Vector)this.elementListeners.clone();
        ElementEvent elementEvt = new ElementEvent(this, evt);
        for (int i = 0; i < targets.size(); ++i) {
            ElementListener target = (ElementListener)targets.elementAt(i);
            if (evt == 0) {
                target.elementAdded(elementEvt);
                continue;
            }
            if (evt != 2) continue;
            target.elementRemoved(elementEvt);
        }
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.useFO_) {
            if (this.dir_ != null && this.dir_.length() > 0) {
                if (this.dir_.equals("rtl")) {
                    return " writing-mode='rl'";
                }
                return " writing-mode='lr'";
            }
            return "";
        }
        if (this.dir_ != null && this.dir_.length() > 0) {
            StringBuffer buffer = new StringBuffer(" dir=\"");
            buffer.append(this.dir_);
            buffer.append("\"");
            return buffer.toString();
        }
        return "";
    }

    public int getItemCount() {
        return this.listItems_.size();
    }

    public Vector getItems() {
        return this.listItems_;
    }

    String getItemAttributeTag() {
        StringBuffer s = new StringBuffer("");
        for (int i = 0; i < this.listItems_.size(); ++i) {
            HTMLTagElement item = (HTMLTagElement)this.listItems_.elementAt(i);
            s.append(item.getTag());
        }
        return s.toString();
    }

    String getItemAttributeFOTag(String type) {
        String itemType = null;
        int listItemCounter = 0;
        StringBuffer s = new StringBuffer("");
        int size = this.listItems_.size();
        for (int i = 0; i < size; ++i) {
            s.append("<fo:list-item>\n<fo:list-item-label>");
            HTMLTagElement item = (HTMLTagElement)this.listItems_.elementAt(i);
            if (this.listItems_.elementAt(i) instanceof HTMLListItem) {
                HTMLListItem listItem;
                ++listItemCounter;
                if (this.listItems_.elementAt(i) instanceof OrderedListItem) {
                    listItem = (OrderedListItem)this.listItems_.elementAt(i);
                    this.value_ = ((OrderedListItem)listItem).getValue();
                    if (this.value_ > 0) {
                        listItemCounter = this.value_;
                    }
                    itemType = ((OrderedListItem)listItem).getType();
                } else {
                    listItem = (UnorderedListItem)this.listItems_.elementAt(i);
                    itemType = ((UnorderedListItem)listItem).getType();
                }
                if (itemType == null) {
                    itemType = type;
                }
                listItem = (HTMLListItem)this.listItems_.elementAt(i);
                s.append(listItem.getTypeAttributeFO(itemType, listItemCounter));
            }
            s.append("</fo:list-item-label>\n<fo:list-item-body>");
            s.append(item.getFOTag());
            s.append("</fo:list-item-body>\n</fo:list-item>\n");
        }
        return s.toString();
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            StringBuffer buffer = new StringBuffer(" lang=\"");
            buffer.append(this.lang_);
            buffer.append("\"");
            return buffer.toString();
        }
        return "";
    }

    public boolean isCompact() {
        return this.compact_;
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void removeListItem(HTMLListItem item) {
        if (item == null) {
            throw new NullPointerException("item");
        }
        if (this.listItems_.removeElement(item)) {
            this.fireElementEvent(2);
        }
    }

    public void removeList(HTMLList list) {
        if (list == null) {
            throw new NullPointerException("list");
        }
        if (this.listItems_.removeElement(list)) {
            this.fireElementEvent(2);
        }
    }

    public void removeListItemElementListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners != null) {
            this.elementListeners.removeElement(listener);
        }
    }

    public void setCompact(boolean compact) {
        boolean old = this.compact_;
        this.compact_ = compact;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("compact", (Object)old, (Object)compact);
        }
    }

    public void setDirection(String dir) {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String old = this.dir_;
        this.dir_ = dir;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", old, dir);
        }
    }

    public void setItems(Vector itemList) {
        if (itemList == null) {
            throw new NullPointerException("items");
        }
        Vector old = this.listItems_;
        this.listItems_ = itemList;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("items", old, itemList);
        }
    }

    public void setLanguage(String lang) {
        if (lang == null) {
            throw new NullPointerException("lang");
        }
        String old = this.lang_;
        this.lang_ = lang;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", old, lang);
        }
    }

    public void setUseFO(boolean useFO) {
        boolean old = this.useFO_;
        this.useFO_ = useFO;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", old, useFO);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

