/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLTagElement;
import com.ibm.as400.util.html.LayoutFormPanel;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;

public class GridLayoutFormPanel
extends LayoutFormPanel {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private int columns_;
    private String lang_;
    private String dir_;
    private String[] columnDir_;
    private String[] columnAlign_;
    private String align_;

    public GridLayoutFormPanel() {
        this.columns_ = 1;
        this.columnDir_ = new String[this.columns_];
        this.columnAlign_ = new String[this.columns_];
    }

    public GridLayoutFormPanel(int columns) {
        try {
            this.setColumns(columns);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    public String getAlignment() {
        return this.align_;
    }

    String getAlignmentAttributeTag() {
        if (this.align_ != null && this.align_.length() > 0) {
            return " align=\"" + this.align_ + "\"";
        }
        return "";
    }

    String getCellAlignmentAttributeTag(int column) {
        if (this.columnAlign_[column] != null && this.columnAlign_[column].length() > 0) {
            return " align=\"" + this.columnAlign_[column] + "\"";
        }
        return "";
    }

    String getCellDirectionAttributeTag(int column) {
        if (this.columnDir_[column] != null && this.columnDir_[column].length() > 0) {
            return " dir=\"" + this.columnDir_[column] + "\"";
        }
        return "";
    }

    public String getColumnAlignment(int column) {
        if (column < 0 || column >= this.columns_) {
            throw new ExtendedIllegalArgumentException("column", 4);
        }
        return this.columnAlign_[column];
    }

    public String getColumnDirection(int column) {
        if (column < 0 || column >= this.columns_) {
            throw new ExtendedIllegalArgumentException("column", 4);
        }
        return this.columnDir_[column];
    }

    public int getColumns() {
        return this.columns_;
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.dir_ != null && this.dir_.length() > 0) {
            return " dir=\"" + this.dir_ + "\"";
        }
        return "";
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            return " lang=\"" + this.lang_ + "\"";
        }
        return "";
    }

    @Override
    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- A GridLayoutFormPanel was here -->";
    }

    @Override
    public String getTag() {
        StringBuffer s = new StringBuffer("<table border=\"0\"");
        s.append(this.getLanguageAttributeTag());
        s.append(this.getDirectionAttributeTag());
        s.append(">\n");
        int index = 0;
        for (int i = 0; i < this.getSize(); ++i) {
            if (index == 0) {
                s.append("<tr>\n");
            }
            HTMLTagElement e = this.getElement(i);
            s.append("<td");
            s.append(this.getCellDirectionAttributeTag(index));
            s.append(this.getCellAlignmentAttributeTag(index));
            s.append(">");
            s.append(e.getTag());
            s.append("</td>\n");
            if (++index < this.columns_) continue;
            s.append("</tr>\n");
            index = 0;
        }
        if (index != 0) {
            s.append("</tr>\n");
        }
        s.append("</table>\n");
        return s.toString();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(listener);
        }
    }

    public void setAlignment(String align) {
        if (align == null) {
            throw new NullPointerException("align");
        }
        if (!(align.equals("left") || align.equals("right") || align.equals("center"))) {
            throw new ExtendedIllegalArgumentException("align", 2);
        }
        this.align_ = align;
    }

    public void setColumnAlignment(int column, String align) {
        if (align == null) {
            throw new NullPointerException("align");
        }
        if (column < 0 || column >= this.columns_) {
            throw new ExtendedIllegalArgumentException("column", 4);
        }
        if (!(align.equals("left") || align.equals("right") || align.equals("center"))) {
            throw new ExtendedIllegalArgumentException("align", 2);
        }
        this.columnAlign_[column] = align;
    }

    public void setColumnDirection(int column, String dir) {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        if (column < 0 || column >= this.columns_) {
            throw new ExtendedIllegalArgumentException("column", 4);
        }
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        this.columnDir_[column] = dir;
    }

    public void setColumns(int columns) throws PropertyVetoException {
        if (columns < 0) {
            throw new ExtendedIllegalArgumentException("columns", 4);
        }
        int old = this.columns_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("columns", (Object)old, (Object)columns);
        }
        this.columns_ = columns;
        this.columnDir_ = new String[this.columns_];
        this.columnAlign_ = new String[this.columns_];
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("columns", (Object)old, (Object)columns);
        }
    }

    public void setDirection(String dir) throws PropertyVetoException {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String old = this.dir_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("dir", old, dir);
        }
        this.dir_ = dir;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", old, dir);
        }
    }

    public void setLanguage(String lang) throws PropertyVetoException {
        if (lang == null) {
            throw new NullPointerException("lang");
        }
        String old = this.lang_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("lang", old, lang);
        }
        this.lang_ = lang;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", old, lang);
        }
    }
}

