/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ToggleFormInput;
import java.beans.PropertyVetoException;

public class CheckboxFormInput
extends ToggleFormInput {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";

    public CheckboxFormInput() {
    }

    public CheckboxFormInput(String label, boolean checked) {
        super(label, checked);
    }

    public CheckboxFormInput(String name, String value, String label, boolean checked) {
        super(label, checked);
        try {
            this.setName(name);
            this.setValue(value);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- A CheckboxFormInput was here -->";
    }

    @Override
    public String getTag() {
        if (this.getName() == null) {
            Trace.log(2, "Attempting to get tag before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (this.getValue() == null) {
            Trace.log(2, "Attempting to get tag before setting value.");
            throw new ExtendedIllegalStateException("value", 4);
        }
        if (this.getLabel() == null) {
            Trace.log(2, "Attempting to get tag before setting label.");
            throw new ExtendedIllegalStateException("label", 4);
        }
        StringBuffer s = new StringBuffer("<input type=\"checkbox\"");
        s.append(this.getNameAttributeTag());
        s.append(this.getValueAttributeTag(false));
        s.append(this.getSizeAttributeTag());
        s.append(this.getLanguageAttributeTag());
        s.append(this.getDirectionAttributeTag());
        s.append(this.getAttributeString());
        s.append(this.getCheckedAttributeTag());
        s.append(" /> ");
        s.append(this.getLabel());
        return s.toString();
    }
}

