/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.HTMLTagElement;
import com.ibm.as400.util.html.HTMLText;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class BidiOrdering
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 367063750196907253L;
    private String lang_;
    private String dir_;
    private boolean useFO_ = false;
    private Vector list_ = new Vector();
    private transient Vector elementListeners;

    public BidiOrdering() {
    }

    public BidiOrdering(String dir) {
        this();
        this.setDirection(dir);
    }

    public BidiOrdering(String lang, String dir) {
        this(dir);
        this.setLanguage(lang);
    }

    public void addItem(HTMLTagElement data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.list_.addElement(data);
        this.fireElementEvent(0);
    }

    public void addItem(String data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.list_.addElement(new HTMLText(data));
        this.fireElementEvent(0);
    }

    public void addItemElementListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners == null) {
            this.elementListeners = new Vector();
        }
        this.elementListeners.addElement(listener);
    }

    void clear() {
        this.list_.removeAllElements();
    }

    private void fireElementEvent(int evt) {
        if (this.elementListeners == null) {
            return;
        }
        Vector targets = (Vector)this.elementListeners.clone();
        ElementEvent elementEvt = new ElementEvent(this, evt);
        for (int i = 0; i < targets.size(); ++i) {
            ElementListener target = (ElementListener)targets.elementAt(i);
            if (evt == 0) {
                target.elementAdded(elementEvt);
                continue;
            }
            if (evt != 2) continue;
            target.elementRemoved(elementEvt);
        }
    }

    public String getDirection() {
        return this.dir_;
    }

    public String getLanguage() {
        return this.lang_;
    }

    public Vector getItems() {
        return this.list_;
    }

    @Override
    public String getTag() {
        if (this.useFO_) {
            return this.getFOTag();
        }
        if (this.dir_ == null) {
            Trace.log(2, "Attempting to get tag before setting direction.");
            throw new ExtendedIllegalStateException("dir", 4);
        }
        if (this.list_.isEmpty()) {
            Trace.log(2, "Attempting to get tag before adding items to list.");
            throw new ExtendedIllegalStateException("data", 4);
        }
        StringBuffer s = new StringBuffer("\n<bdo");
        if (this.lang_ != null) {
            s.append(" lang=\"" + this.lang_ + "\"");
        }
        s.append(" dir=\"" + this.dir_ + "\"");
        s.append(this.getAttributeString());
        s.append(">\n");
        for (int i = 0; i < this.list_.size(); ++i) {
            HTMLTagElement data = (HTMLTagElement)this.list_.elementAt(i);
            s.append(data.getTag());
        }
        s.append("\n</bdo>\n");
        return s.toString();
    }

    @Override
    public String getFOTag() {
        if (this.dir_ == null) {
            Trace.log(2, "Attempting to get XSL-FO tag before setting direction.");
            throw new ExtendedIllegalStateException("dir", 4);
        }
        if (this.list_.isEmpty()) {
            Trace.log(2, "Attempting to get XSL-FO tag before adding items to list.");
            throw new ExtendedIllegalStateException("data", 4);
        }
        StringBuffer s = new StringBuffer("\n<fo:block-container");
        s.append(" writing-mode='");
        if (this.dir_.equals("rtl")) {
            s.append("rl'");
        } else {
            s.append("lr'");
        }
        s.append(">\n");
        for (int i = 0; i < this.list_.size(); ++i) {
            HTMLTagElement data = (HTMLTagElement)this.list_.elementAt(i);
            s.append(data.getFOTag());
        }
        s.append("</fo:block-container>\n");
        return s.toString();
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    public void removeItem(HTMLTagElement data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (this.list_.removeElement(data)) {
            this.fireElementEvent(2);
        }
    }

    public void removeItemElementListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners != null) {
            this.elementListeners.removeElement(listener);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void setDirection(String dir) {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String old = this.dir_;
        this.dir_ = dir;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", old, dir);
        }
    }

    public void setLanguage(String lang) {
        if (lang == null) {
            throw new NullPointerException("lang");
        }
        String old = this.lang_;
        this.lang_ = lang;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", old, lang);
        }
    }

    public void setUseFO(boolean useFO) {
        boolean old = this.useFO_;
        this.useFO_ = useFO;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", old, useFO);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

