/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;

class AuthenticationSystem {
    private static AS400 system_ = null;
    private static boolean onAS400_ = false;

    private AuthenticationSystem() {
    }

    static void handleUnexpectedException(Throwable t) {
        Trace.log(2, "Unexpected Exception:", t);
        if (t instanceof AS400Exception) {
            AS400Message[] messageList = ((AS400Exception)t).getAS400MessageList();
            for (int msg = 0; msg < messageList.length; ++msg) {
                Trace.log(2, messageList[msg].toString());
            }
        }
        InternalErrorException iee = new InternalErrorException(10);
        iee.initCause(t);
        throw iee;
    }

    static boolean isLocal(AS400 system) {
        return system.isLocal() && system.getUserId().trim().equalsIgnoreCase(new AS400().getUserId());
    }

    static AS400 localHost() {
        return system_;
    }

    static void resetLocalHost() {
        if (!onAS400_) {
            return;
        }
        try {
            system_.resetAllServices();
            system_.setUserId("");
            system_.setPassword("");
            system_.getServicePort(7);
        }
        catch (PropertyVetoException e) {
            AuthenticationSystem.handleUnexpectedException(e);
        }
    }

    static {
        try {
            system_ = new AS400();
            system_.setGuiAvailable(false);
        }
        catch (PropertyVetoException e) {
            AuthenticationSystem.handleUnexpectedException(e);
        }
        try {
            String osName = System.getProperty("os.name");
            Trace.log(1, "Detected os.name: " + osName);
            if (osName != null && osName.equalsIgnoreCase("OS/400")) {
                onAS400_ = true;
            }
        }
        catch (SecurityException e) {
            Trace.log(4, "Error retrieving os.name:", (Throwable)e);
        }
    }
}

