/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCSQLXML;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableMixedMap;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import com.ibm.as400.access.SQLDate;
import com.ibm.as400.access.SQLTime;
import com.ibm.as400.access.SQLTimestamp;
import java.io.CharConversionException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

final class SQLChar
extends SQLDataBase {
    static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private int maxLength_;
    private String value_;

    SQLChar(int maxLength, SQLConversionSettings settings) {
        super(settings);
        this.maxLength_ = maxLength;
        this.value_ = "";
    }

    @Override
    public Object clone() {
        return new SQLChar(this.maxLength_, this.settings_);
    }

    @Override
    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter, boolean ignoreConversionErrors) throws SQLException {
        int bidiStringType = this.settings_.getBidiStringType();
        if (bidiStringType == -1) {
            bidiStringType = ccsidConverter.bidiStringType_;
        }
        BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(bidiStringType);
        bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
        bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
        try {
            this.value_ = ccsidConverter.byteArrayToString(rawBytes, offset, this.maxLength_, bidiConversionProperties);
        }
        catch (Exception e) {
            JDError.throwSQLException("22524", e);
        }
    }

    @Override
    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        int bidiStringType = this.settings_.getBidiStringType();
        if (bidiStringType == -1) {
            bidiStringType = ccsidConverter.bidiStringType_;
        }
        BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(bidiStringType);
        bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
        bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
        try {
            this.truncated_ = ccsidConverter.stringToByteArray(this.value_, rawBytes, offset, this.maxLength_, bidiConversionProperties);
        }
        catch (CharConversionException e) {
            this.maxLength_ = ccsidConverter.stringToByteArray(this.value_, bidiConversionProperties).length;
            JDError.throwSQLException((Object)this, "HY000", e, "Change Descriptor");
        }
    }

    @Override
    public void validateRawTruncatedData(byte[] rawBytes, int offset, ConvTable ccsidConverter) {
        if (ccsidConverter instanceof ConvTableMixedMap) {
            ccsidConverter.validateData(rawBytes, offset, this.maxLength_);
        }
    }

    @Override
    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        int exactLength;
        String value = null;
        if (object instanceof String) {
            value = (String)object;
        } else if (object instanceof Character) {
            value = object.toString();
        } else if (object instanceof Number) {
            value = object.toString();
        } else if (object instanceof Boolean) {
            value = this.settings_.getTranslateBoolean() ? object.toString() : ((Boolean)object == true ? "1" : "0");
        } else if (object instanceof Time) {
            value = SQLTime.timeToString((Time)object, this.settings_, calendar);
        } else if (object instanceof Timestamp) {
            value = SQLTimestamp.timestampToStringTrimTrailingZeros((Timestamp)object, calendar, this.settings_);
        } else if (object instanceof Date) {
            value = SQLDate.dateToString((Date)object, this.settings_, calendar);
        } else if (object instanceof URL) {
            value = object.toString();
        } else if (object instanceof Reader) {
            value = SQLChar.getStringFromReader((Reader)object, -2, this);
        } else if (object instanceof Clob) {
            Clob clob = (Clob)object;
            value = clob.getSubString(1L, (int)clob.length());
        } else if (object instanceof SQLXML) {
            SQLXML xml = (SQLXML)object;
            value = xml.getString();
        }
        if (value == null) {
            if (JDTrace.isTraceOn()) {
                if (object == null) {
                    JDTrace.logInformation(this, "Unable to assign null object");
                } else {
                    JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                }
            }
            JDError.throwSQLException((Object)this, "07006");
        }
        this.value_ = value;
        int valueLength = this.value_.length();
        if (valueLength < (exactLength = this.getDisplaySize())) {
            StringBuffer buffer = new StringBuffer(this.value_);
            char c = ' ';
            for (int i = valueLength; i < exactLength; ++i) {
                buffer.append(c);
            }
            this.value_ = buffer.toString();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
        } else if (valueLength > exactLength) {
            this.value_ = this.value_.substring(0, exactLength);
            this.truncated_ = valueLength - exactLength;
            this.outOfBounds_ = false;
        } else {
            this.truncated_ = 0;
        }
        this.outOfBounds_ = false;
    }

    @Override
    public int getSQLType() {
        return 5;
    }

    @Override
    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH", null);
    }

    @Override
    public int getDisplaySize() {
        return this.maxLength_;
    }

    @Override
    public String getJavaClassName() {
        return "java.lang.String";
    }

    @Override
    public String getLiteralPrefix() {
        return "'";
    }

    @Override
    public String getLiteralSuffix() {
        return "'";
    }

    @Override
    public String getLocalName() {
        return "CHAR";
    }

    @Override
    public int getMaximumPrecision() {
        return 32765;
    }

    @Override
    public int getMaximumScale() {
        return 0;
    }

    @Override
    public int getMinimumScale() {
        return 0;
    }

    @Override
    public int getNativeType() {
        return 452;
    }

    @Override
    public int getPrecision() {
        return this.maxLength_;
    }

    @Override
    public int getRadix() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getTypeName() {
        return "CHAR";
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public boolean isText() {
        return true;
    }

    @Override
    public int getActualSize() {
        return this.value_.length();
    }

    @Override
    public int getTruncated() {
        return this.truncated_;
    }

    @Override
    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new HexReaderInputStream(new StringReader(this.getString()));
    }

    @Override
    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new AS400JDBCBlob(BinaryConverter.stringToBytes(this.getString()), this.maxLength_);
        }
        catch (NumberFormatException nfe) {
            JDError.throwSQLException((Object)this, "07006", nfe);
            return null;
        }
    }

    @Override
    public byte getByte() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            Double doubleValue = Double.valueOf(this.value_.trim());
            double d = doubleValue;
            if (d > 127.0 || d < -128.0) {
                this.truncated_ = 1;
                this.outOfBounds_ = true;
            }
            return doubleValue.byteValue();
        }
        catch (NumberFormatException e) {
            JDError.throwSQLException((Object)this, "07006", e);
            return -1;
        }
    }

    @Override
    public byte[] getBytes() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return BinaryConverter.stringToBytes(this.getString());
        }
        catch (NumberFormatException nfe) {
            JDError.throwSQLException((Object)this, "07006", nfe);
            return null;
        }
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getString();
    }

    @Override
    public String getString() throws SQLException {
        int maxFieldSize = this.settings_.getMaxFieldSize();
        if (this.value_.length() > maxFieldSize && maxFieldSize > 0) {
            return this.value_.substring(0, maxFieldSize);
        }
        return this.value_;
    }

    public void trim() {
        this.value_ = this.value_.trim();
    }

    @Override
    public String getNString() throws SQLException {
        int maxFieldSize = this.settings_.getMaxFieldSize();
        if (this.value_.length() > maxFieldSize && maxFieldSize > 0) {
            return this.value_.substring(0, maxFieldSize);
        }
        return this.value_;
    }

    @Override
    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public SQLXML getSQLXML() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCSQLXML(this.getString());
    }

    @Override
    public void saveValue() {
        this.savedValue_ = this.value_;
    }
}

