/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SignonDialogAdapter;
import com.ibm.as400.access.AS400SignonTextField;
import com.ibm.as400.access.ResourceBundleLoader;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;

public class PasswordDialog
extends Dialog {
    static final long serialVersionUID = 4L;
    private AS400SignonDialogAdapter listener_ = new AS400SignonDialogAdapter(this);
    private TextField systemNameTextField_;
    private TextField userIdTextField_;
    private TextField passwordTextField_;
    private Checkbox defaultUserCheckbox_;
    private Checkbox cachePasswordCheckbox_;
    private Button okButton_;
    private Button cancelButton_;

    public PasswordDialog(Frame parent, String titleText) {
        this(parent, titleText, false);
    }

    PasswordDialog(Frame parent, String titleText, boolean showCheckbox) {
        super(parent, titleText, true);
        Panel centeringPanel;
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.insets = new Insets(8, 8, 0, 8);
        this.setLayout(layout);
        this.setResizable(false);
        this.setBackground(Color.lightGray);
        Label label = new Label(ResourceBundleLoader.getCoreText("DLG_SYSTEM_LABEL"), 0);
        this.add(label, layout, constraints, 0, 0, 1, 1);
        this.systemNameTextField_ = new TextField(10);
        this.systemNameTextField_.addFocusListener(this.listener_);
        this.systemNameTextField_.addKeyListener(this.listener_);
        this.add(this.systemNameTextField_, layout, constraints, 1, 0, 1, 1);
        label = new Label(ResourceBundleLoader.getCoreText("DLG_USER_ID_LABEL"), 0);
        this.add(label, layout, constraints, 0, 1, 1, 1);
        this.userIdTextField_ = new AS400SignonTextField();
        this.userIdTextField_.addFocusListener(this.listener_);
        this.userIdTextField_.addKeyListener(this.listener_);
        this.add(this.userIdTextField_, layout, constraints, 1, 1, 1, 1);
        label = new Label(ResourceBundleLoader.getCoreText("DLG_PASSWORD_LABEL"), 0);
        this.add(label, layout, constraints, 0, 2, 1, 1);
        this.passwordTextField_ = new TextField(10);
        this.passwordTextField_.setEchoChar('*');
        this.passwordTextField_.addFocusListener(this.listener_);
        this.passwordTextField_.addKeyListener(this.listener_);
        this.add(this.passwordTextField_, layout, constraints, 1, 2, 1, 1);
        this.defaultUserCheckbox_ = new Checkbox(ResourceBundleLoader.getCoreText("DLG_DEFAULT_PASSWORD_CHECK_BOX"));
        this.defaultUserCheckbox_.addFocusListener(this.listener_);
        this.defaultUserCheckbox_.addKeyListener(this.listener_);
        this.cachePasswordCheckbox_ = new Checkbox(ResourceBundleLoader.getCoreText("DLG_CACHE_PASSWORD_CHECK_BOX"));
        this.cachePasswordCheckbox_.addFocusListener(this.listener_);
        this.cachePasswordCheckbox_.addKeyListener(this.listener_);
        if (showCheckbox) {
            centeringPanel = new Panel();
            centeringPanel.setLayout(new FlowLayout(1));
            this.add(centeringPanel, layout, constraints, 0, 3, 2, 2);
            Panel checkboxPanel = new Panel();
            checkboxPanel.setLayout(new GridLayout(2, 1, 2, 2));
            centeringPanel.add(checkboxPanel);
            checkboxPanel.add(this.defaultUserCheckbox_);
            checkboxPanel.add(this.cachePasswordCheckbox_);
        }
        centeringPanel = new Panel();
        centeringPanel.setLayout(new FlowLayout(1));
        constraints.insets = new Insets(8, 8, 8, 8);
        this.add(centeringPanel, layout, constraints, 0, 5, 2, 1);
        Panel buttonPanel = new Panel();
        buttonPanel.setLayout(new GridLayout(1, 2, 8, 0));
        centeringPanel.add(buttonPanel);
        this.okButton_ = new Button(ResourceBundleLoader.getCoreText("DLG_OK_BUTTON"));
        this.okButton_.addActionListener(this.listener_);
        this.okButton_.addFocusListener(this.listener_);
        this.okButton_.addKeyListener(this.listener_);
        buttonPanel.add(this.okButton_);
        this.cancelButton_ = new Button(ResourceBundleLoader.getCoreText("DLG_CANCEL_BUTTON"));
        this.cancelButton_.addActionListener(this.listener_);
        this.cancelButton_.addFocusListener(this.listener_);
        this.cancelButton_.addKeyListener(this.listener_);
        buttonPanel.add(this.cancelButton_);
        this.pack();
        this.addWindowListener(this.listener_);
        this.addFocusListener(this.listener_);
    }

    private void add(Component component, GridBagLayout layout, GridBagConstraints constraints, int x, int y, int width, int height) {
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.gridwidth = width;
        constraints.gridheight = height;
        layout.setConstraints(component, constraints);
        this.add(component);
    }

    void disableDefaultUserCheckbox() {
        this.defaultUserCheckbox_.setEnabled(false);
    }

    void disablePasswordCacheCheckbox() {
        this.cachePasswordCheckbox_.setEnabled(false);
    }

    void enableDefaultUserCheckbox() {
        this.defaultUserCheckbox_.setEnabled(true);
    }

    void enablePasswordCacheCheckbox() {
        this.cachePasswordCheckbox_.setEnabled(true);
    }

    void enableSystemNameField() {
        this.systemNameTextField_.setEnabled(true);
    }

    boolean getDefaultState() {
        return this.defaultUserCheckbox_.getState();
    }

    String getPassword() {
        return this.passwordTextField_.getText();
    }

    boolean getPasswordCacheState() {
        return this.cachePasswordCheckbox_.getState();
    }

    public String getSystemName() {
        return this.systemNameTextField_.getText();
    }

    public String getUserId() {
        return this.userIdTextField_.getText();
    }

    void setDefaultUserState(boolean state) {
        this.defaultUserCheckbox_.setState(state);
    }

    void setPasswordCacheState(boolean state) {
        this.cachePasswordCheckbox_.setState(state);
    }

    public void setSystemName(String systemName) {
        this.systemNameTextField_.setText(systemName);
        this.systemNameTextField_.setEnabled(false);
    }

    public void setUserId(String userId) {
        this.userIdTextField_.setText(userId);
    }

    boolean prompt() {
        this.passwordTextField_.setText("");
        if (this.getSystemName().length() == 0) {
            this.listener_.setFocalPoint(this.systemNameTextField_);
        } else if (this.getUserId().length() == 0) {
            this.listener_.setFocalPoint(this.userIdTextField_);
        } else {
            this.listener_.setFocalPoint(this.passwordTextField_);
        }
        super.show();
        return this.listener_.getFocalPoint() != this.cancelButton_;
    }
}

