/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming.io.source;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.beam.runners.flink.translation.utils.SerdeUtils;
import org.apache.beam.sdk.io.Source;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class FlinkSourceSplit<@UnknownKeyFor T>
implements SourceSplit,
Serializable {
    private final @UnknownKeyFor @NonNull @Initialized int splitIndex;
    private final @UnknownKeyFor @NonNull @Initialized Source<T> beamSplitSource;
    @Nullable
    private final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized [] splitState;

    public FlinkSourceSplit(@UnknownKeyFor @NonNull @Initialized int splitIndex, @UnknownKeyFor @NonNull @Initialized Source<T> beamSplitSource) {
        this(splitIndex, beamSplitSource, null);
    }

    public FlinkSourceSplit(@UnknownKeyFor @NonNull @Initialized int splitIndex, @UnknownKeyFor @NonNull @Initialized Source<T> beamSplitSource, @Nullable @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized [] splitState) {
        this.splitIndex = splitIndex;
        this.beamSplitSource = beamSplitSource;
        this.splitState = splitState;
    }

    public @UnknownKeyFor @NonNull @Initialized int splitIndex() {
        return this.splitIndex;
    }

    @Nullable
    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized [] getSplitState() {
        return this.splitState;
    }

    public @UnknownKeyFor @NonNull @Initialized Source<T> getBeamSplitSource() {
        return this.beamSplitSource;
    }

    public @UnknownKeyFor @NonNull @Initialized String splitId() {
        return Integer.toString(this.splitIndex);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return String.format("[SplitIndex: %d, BeamSource: %s]", this.splitIndex, this.beamSplitSource);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SimpleVersionedSerializer<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>> serializer() {
        return SerdeUtils.getNaiveObjectSerializer();
    }
}

