/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.InternalTimeServiceManager;
import org.apache.flink.streaming.api.operators.InternalTimeServiceManagerImpl;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class AbstractStreamOperatorCompat<@UnknownKeyFor OutputT>
extends AbstractStreamOperator<OutputT> {
    protected /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized InternalTimeServiceManager<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getTimeServiceManagerCompat() {
        return (InternalTimeServiceManager)this.getTimeServiceManager().orElseThrow(() -> new IllegalStateException("Time service manager is not set."));
    }

    protected @UnknownKeyFor @NonNull @Initialized int numProcessingTimeTimers() {
        return this.getTimeServiceManager().map(manager -> {
            InternalTimeServiceManagerImpl cast = (InternalTimeServiceManagerImpl)this.getTimeServiceManagerCompat();
            return cast.numProcessingTimeTimers();
        }).orElse(0);
    }

    abstract void cleanUp() throws @UnknownKeyFor @NonNull @Initialized Exception;

    abstract void flushData() throws @UnknownKeyFor @NonNull @Initialized Exception;

    public void finish() throws @UnknownKeyFor @NonNull @Initialized Exception {
        try {
            this.flushData();
        }
        finally {
            super.finish();
        }
    }

    public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
        try {
            this.cleanUp();
        }
        finally {
            super.close();
        }
    }
}

