/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.PeriodicShardSyncManager;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncStrategy;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncStrategyType;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncTaskManager;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskResult;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import com.amazonaws.services.kinesis.model.Shard;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ShardEndShardSyncStrategy
implements ShardSyncStrategy {
    private static final Log LOG = LogFactory.getLog(Worker.class);
    private ShardSyncTaskManager shardSyncTaskManager;
    private PeriodicShardSyncManager periodicShardSyncManager;

    ShardEndShardSyncStrategy(ShardSyncTaskManager shardSyncTaskManager, PeriodicShardSyncManager periodicShardSyncManager) {
        this.shardSyncTaskManager = shardSyncTaskManager;
        this.periodicShardSyncManager = periodicShardSyncManager;
    }

    @Override
    public ShardSyncStrategyType getStrategyType() {
        return ShardSyncStrategyType.SHARD_END;
    }

    @Override
    public TaskResult syncShards() {
        Future<TaskResult> taskResultFuture = null;
        TaskResult result = null;
        while (taskResultFuture == null) {
            taskResultFuture = this.shardSyncTaskManager.syncShardAndLeaseInfo(null);
        }
        try {
            result = (TaskResult)taskResultFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn((Object)"ShardEndShardSyncStrategy syncShards encountered exception.", (Throwable)e);
        }
        return result;
    }

    @Override
    public TaskResult onWorkerInitialization() {
        LOG.info((Object)"Starting periodic shard sync background process for SHARD_END shard sync strategy.");
        return this.periodicShardSyncManager.start();
    }

    @Override
    public TaskResult onFoundCompletedShard() {
        this.shardSyncTaskManager.syncShardAndLeaseInfo(null);
        return new TaskResult(null);
    }

    @Override
    public TaskResult onShardConsumerShutDown() {
        return this.onFoundCompletedShard();
    }

    @Override
    public TaskResult onShardConsumerShutDown(List<Shard> latestShards) {
        this.shardSyncTaskManager.syncShardAndLeaseInfo(latestShards);
        return new TaskResult(null);
    }

    @Override
    public void onWorkerShutDown() {
        LOG.info((Object)"Stopping periodic shard sync background process for SHARD_END shard sync strategy.");
        this.periodicShardSyncManager.stop();
    }
}

