/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p54p0.io.opencensus.stats;

import javax.annotation.concurrent.Immutable;
import org.apache.beam.vendor.grpc.v1p54p0.io.opencensus.common.Function;
import org.apache.beam.vendor.grpc.v1p54p0.io.opencensus.internal.Utils;
import org.apache.beam.vendor.grpc.v1p54p0.io.opencensus.stats.AutoValue_Aggregation_Count;
import org.apache.beam.vendor.grpc.v1p54p0.io.opencensus.stats.AutoValue_Aggregation_Distribution;
import org.apache.beam.vendor.grpc.v1p54p0.io.opencensus.stats.AutoValue_Aggregation_LastValue;
import org.apache.beam.vendor.grpc.v1p54p0.io.opencensus.stats.AutoValue_Aggregation_Mean;
import org.apache.beam.vendor.grpc.v1p54p0.io.opencensus.stats.AutoValue_Aggregation_Sum;
import org.apache.beam.vendor.grpc.v1p54p0.io.opencensus.stats.BucketBoundaries;

@Immutable
public abstract class Aggregation {
    private Aggregation() {
    }

    public abstract <T> T match(Function<? super Sum, T> var1, Function<? super Count, T> var2, Function<? super Distribution, T> var3, Function<? super LastValue, T> var4, Function<? super Aggregation, T> var5);

    @Immutable
    public static abstract class LastValue
    extends Aggregation {
        private static final LastValue INSTANCE = new AutoValue_Aggregation_LastValue();

        LastValue() {
        }

        public static LastValue create() {
            return INSTANCE;
        }

        @Override
        public final <T> T match(Function<? super Sum, T> p0, Function<? super Count, T> p1, Function<? super Distribution, T> p2, Function<? super LastValue, T> p3, Function<? super Aggregation, T> defaultFunction) {
            return p3.apply(this);
        }
    }

    @Immutable
    public static abstract class Distribution
    extends Aggregation {
        Distribution() {
        }

        public static Distribution create(BucketBoundaries bucketBoundaries) {
            Utils.checkNotNull(bucketBoundaries, "bucketBoundaries");
            return new AutoValue_Aggregation_Distribution(bucketBoundaries);
        }

        public abstract BucketBoundaries getBucketBoundaries();

        @Override
        public final <T> T match(Function<? super Sum, T> p0, Function<? super Count, T> p1, Function<? super Distribution, T> p2, Function<? super LastValue, T> p3, Function<? super Aggregation, T> defaultFunction) {
            return p2.apply(this);
        }
    }

    @Deprecated
    @Immutable
    public static abstract class Mean
    extends Aggregation {
        private static final Mean INSTANCE = new AutoValue_Aggregation_Mean();

        Mean() {
        }

        public static Mean create() {
            return INSTANCE;
        }

        @Override
        public final <T> T match(Function<? super Sum, T> p0, Function<? super Count, T> p1, Function<? super Distribution, T> p2, Function<? super LastValue, T> p3, Function<? super Aggregation, T> defaultFunction) {
            return defaultFunction.apply(this);
        }
    }

    @Immutable
    public static abstract class Count
    extends Aggregation {
        private static final Count INSTANCE = new AutoValue_Aggregation_Count();

        Count() {
        }

        public static Count create() {
            return INSTANCE;
        }

        @Override
        public final <T> T match(Function<? super Sum, T> p0, Function<? super Count, T> p1, Function<? super Distribution, T> p2, Function<? super LastValue, T> p3, Function<? super Aggregation, T> defaultFunction) {
            return p1.apply(this);
        }
    }

    @Immutable
    public static abstract class Sum
    extends Aggregation {
        private static final Sum INSTANCE = new AutoValue_Aggregation_Sum();

        Sum() {
        }

        public static Sum create() {
            return INSTANCE;
        }

        @Override
        public final <T> T match(Function<? super Sum, T> p0, Function<? super Count, T> p1, Function<? super Distribution, T> p2, Function<? super LastValue, T> p3, Function<? super Aggregation, T> defaultFunction) {
            return p0.apply(this);
        }
    }
}

