/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.apache.beam.runners.core.construction.PTransformReplacements;
import org.apache.beam.runners.core.construction.ReplacementOutputs;
import org.apache.beam.runners.dataflow.DataflowRunner;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.GroupIntoBatches;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.util.ShardedKey;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class GroupIntoBatchesOverride {
    private static final @UnknownKeyFor @NonNull @Initialized UUID workerUuid = UUID.randomUUID();

    private static <K, V> @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<K>, V>> shardKeys(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
        KvCoder inputCoder = (KvCoder)input.getCoder();
        Coder keyCoder = (Coder)inputCoder.getCoderArguments().get(0);
        Coder valueCoder = (Coder)inputCoder.getCoderArguments().get(1);
        return ((PCollection)input.apply("Shard Keys", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<KV<K, V>, KV<ShardedKey<K>, V>>(){

            public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<K>, V> apply(@UnknownKeyFor @NonNull @Initialized KV<K, V> input) {
                long tid = Thread.currentThread().getId();
                ByteBuffer buffer = ByteBuffer.allocate(24);
                buffer.putLong(workerUuid.getMostSignificantBits());
                buffer.putLong(workerUuid.getLeastSignificantBits());
                buffer.putLong(tid);
                return KV.of((Object)ShardedKey.of((Object)input.getKey(), (byte[])buffer.array()), (Object)input.getValue());
            }
        }))).setCoder((Coder)KvCoder.of((Coder)ShardedKey.Coder.of((Coder)keyCoder), (Coder)valueCoder));
    }

    static class StreamingGroupIntoBatchesWithShardedKey<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<ShardedKey<K>, Iterable<V>>>> {
        private final transient @UnknownKeyFor @NonNull @Initialized DataflowRunner runner;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized GroupIntoBatches. @UnknownKeyFor @NonNull @Initialized WithShardedKey originalTransform;
        private final transient @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<K>, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> originalOutput;

        public StreamingGroupIntoBatchesWithShardedKey(@UnknownKeyFor @NonNull @Initialized DataflowRunner runner, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized GroupIntoBatches. @UnknownKeyFor @NonNull @Initialized WithShardedKey original, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<K>, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> output) {
            this.runner = runner;
            this.originalTransform = original;
            this.originalOutput = output;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<K>, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            this.runner.maybeRecordPCollectionWithAutoSharding(this.originalOutput);
            return (PCollection)input.apply((PTransform)this.originalTransform);
        }
    }

    static class StreamingGroupIntoBatchesWithShardedKeyOverrideFactory<@UnknownKeyFor K, @UnknownKeyFor V>
    implements PTransformOverrideFactory<PCollection<KV<K, V>>, PCollection<KV<ShardedKey<K>, Iterable<V>>>, GroupIntoBatches.WithShardedKey> {
        private final @UnknownKeyFor @NonNull @Initialized DataflowRunner runner;

        StreamingGroupIntoBatchesWithShardedKeyOverrideFactory(@UnknownKeyFor @NonNull @Initialized DataflowRunner runner) {
            this.runner = runner;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<K>, @UnknownKeyFor @NonNull @Initialized Iterable<V>>>> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<K>, @UnknownKeyFor @NonNull @Initialized Iterable<V>>>, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized GroupIntoBatches. @UnknownKeyFor @NonNull @Initialized WithShardedKey> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), new StreamingGroupIntoBatchesWithShardedKey(this.runner, (GroupIntoBatches.WithShardedKey)transform.getTransform(), PTransformReplacements.getSingletonMainOutput(transform)));
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> mapOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<K>, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    static class StreamingGroupIntoBatches<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> {
        private final transient @UnknownKeyFor @NonNull @Initialized DataflowRunner runner;
        private final @UnknownKeyFor @NonNull @Initialized GroupIntoBatches<K, V> originalTransform;
        private final transient @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> originalOutput;

        public StreamingGroupIntoBatches(@UnknownKeyFor @NonNull @Initialized DataflowRunner runner, @UnknownKeyFor @NonNull @Initialized GroupIntoBatches<K, V> original, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> output) {
            this.runner = runner;
            this.originalTransform = original;
            this.originalOutput = output;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            this.runner.maybeRecordPCollectionPreservedKeys(this.originalOutput);
            return (PCollection)input.apply(this.originalTransform);
        }
    }

    static class StreamingGroupIntoBatchesOverrideFactory<@UnknownKeyFor K, @UnknownKeyFor V>
    implements PTransformOverrideFactory<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>, GroupIntoBatches<K, V>> {
        private final @UnknownKeyFor @NonNull @Initialized DataflowRunner runner;

        StreamingGroupIntoBatchesOverrideFactory(@UnknownKeyFor @NonNull @Initialized DataflowRunner runner) {
            this.runner = runner;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>>> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>>, @UnknownKeyFor @NonNull @Initialized GroupIntoBatches<K, V>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), new StreamingGroupIntoBatches(this.runner, (GroupIntoBatches)transform.getTransform(), PTransformReplacements.getSingletonMainOutput(transform)));
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> mapOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    static class BatchGroupIntoBatchesWithShardedKey<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<ShardedKey<K>, Iterable<V>>>> {
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized GroupIntoBatches.BatchingParams<V> batchingParams;
        private final transient @UnknownKeyFor @NonNull @Initialized DataflowRunner runner;
        private final transient @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<K>, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> originalOutput;

        private BatchGroupIntoBatchesWithShardedKey(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized GroupIntoBatches.BatchingParams<V> batchingParams, @UnknownKeyFor @NonNull @Initialized DataflowRunner runner, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<K>, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> originalOutput) {
            this.batchingParams = batchingParams;
            this.runner = runner;
            this.originalOutput = originalOutput;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<K>, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            return (PCollection)GroupIntoBatchesOverride.shardKeys(input).apply(new BatchGroupIntoBatches(this.batchingParams, this.runner, this.originalOutput));
        }
    }

    static class BatchGroupIntoBatchesWithShardedKeyOverrideFactory<@UnknownKeyFor K, @UnknownKeyFor V>
    implements PTransformOverrideFactory<PCollection<KV<K, V>>, PCollection<KV<ShardedKey<K>, Iterable<V>>>, GroupIntoBatches.WithShardedKey> {
        private final @UnknownKeyFor @NonNull @Initialized DataflowRunner runner;

        BatchGroupIntoBatchesWithShardedKeyOverrideFactory(@UnknownKeyFor @NonNull @Initialized DataflowRunner runner) {
            this.runner = runner;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<K>, @UnknownKeyFor @NonNull @Initialized Iterable<V>>>> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<K>, @UnknownKeyFor @NonNull @Initialized Iterable<V>>>, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized GroupIntoBatches. @UnknownKeyFor @NonNull @Initialized WithShardedKey> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), new BatchGroupIntoBatchesWithShardedKey(((GroupIntoBatches.WithShardedKey)transform.getTransform()).getBatchingParams(), this.runner, PTransformReplacements.getSingletonMainOutput(transform)));
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> mapOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<K>, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    static class BatchGroupIntoBatches<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> {
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized GroupIntoBatches.BatchingParams<V> batchingParams;
        private final transient @UnknownKeyFor @NonNull @Initialized DataflowRunner runner;
        private final transient @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> originalOutput;

        private BatchGroupIntoBatches(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized GroupIntoBatches.BatchingParams<V> batchingParams, @UnknownKeyFor @NonNull @Initialized DataflowRunner runner, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> originalOutput) {
            this.batchingParams = batchingParams;
            this.runner = runner;
            this.originalOutput = originalOutput;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            this.runner.maybeRecordPCollectionPreservedKeys(this.originalOutput);
            KvCoder inputCoder = (KvCoder)input.getCoder();
            Coder valueCoder = (Coder)inputCoder.getCoderArguments().get(1);
            final SerializableFunction weigher = this.batchingParams.getWeigher(valueCoder);
            final long maxBatchSizeElements = this.batchingParams.getBatchSize();
            final long maxBatchSizeBytes = this.batchingParams.getBatchSizeBytes();
            return (PCollection)((PCollection)input.apply("GroupAll", (PTransform)GroupByKey.create())).apply("SplitIntoBatches", (PTransform)ParDo.of((DoFn)new DoFn<KV<K, Iterable<V>>, KV<K, Iterable<V>>>(){

                @DoFn.ProcessElement
                public void process(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    ArrayList currentBatch = Lists.newArrayList();
                    long batchSizeBytes = 0L;
                    for (Object element : (Iterable)((KV)c.element()).getValue()) {
                        long currentSizeBytes = 0L;
                        if (weigher != null && (currentSizeBytes += ((Long)weigher.apply(element)).longValue()) + batchSizeBytes > maxBatchSizeBytes && !currentBatch.isEmpty()) {
                            c.output((Object)KV.of((Object)((KV)c.element()).getKey(), (Object)currentBatch));
                            currentBatch = Lists.newArrayList();
                            batchSizeBytes = 0L;
                        }
                        currentBatch.add(element);
                        if ((long)currentBatch.size() != maxBatchSizeElements && (maxBatchSizeBytes == Long.MAX_VALUE || (batchSizeBytes += currentSizeBytes) < maxBatchSizeBytes)) continue;
                        c.output((Object)KV.of((Object)((KV)c.element()).getKey(), (Object)currentBatch));
                        currentBatch = Lists.newArrayList();
                        batchSizeBytes = 0L;
                    }
                    if (!currentBatch.isEmpty()) {
                        c.output((Object)KV.of((Object)((KV)c.element()).getKey(), (Object)currentBatch));
                    }
                }
            }));
        }
    }

    static class BatchGroupIntoBatchesOverrideFactory<@UnknownKeyFor K, @UnknownKeyFor V>
    implements PTransformOverrideFactory<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>, GroupIntoBatches<K, V>> {
        private final @UnknownKeyFor @NonNull @Initialized DataflowRunner runner;

        BatchGroupIntoBatchesOverrideFactory(@UnknownKeyFor @NonNull @Initialized DataflowRunner runner) {
            this.runner = runner;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>>> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>>, @UnknownKeyFor @NonNull @Initialized GroupIntoBatches<K, V>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), new BatchGroupIntoBatches(((GroupIntoBatches)transform.getTransform()).getBatchingParams(), this.runner, PTransformReplacements.getSingletonMainOutput(transform)));
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> mapOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }
}

