/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.testing.SerializableMatcher;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;

public class SerializableMatchers
implements Serializable {
    private SerializableMatchers() {
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> allOf(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @Nullable @Initialized ? super T>> serializableMatchers) {
        Iterable matchers = serializableMatchers;
        return SerializableMatchers.fromSupplier(() -> Matchers.allOf((Iterable)matchers));
    }

    @SafeVarargs
    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> allOf(SerializableMatcher<T> ... matchers) {
        return SerializableMatchers.fromSupplier(() -> Matchers.allOf((Matcher[])matchers));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> anyOf(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @Nullable @Initialized ? super T>> serializableMatchers) {
        Iterable matchers = serializableMatchers;
        return SerializableMatchers.fromSupplier(() -> Matchers.anyOf((Iterable)matchers));
    }

    @SafeVarargs
    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> anyOf(SerializableMatcher<T> ... matchers) {
        return SerializableMatchers.fromSupplier(() -> Matchers.anyOf((Matcher[])matchers));
    }

    public static @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized Object> anything() {
        return SerializableMatchers.fromSupplier(Matchers::anything);
    }

    @SafeVarargs
    public static <T extends Serializable> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T @UnknownKeyFor @NonNull @Initialized []> arrayContaining(T ... items) {
        return SerializableMatchers.fromSupplier(() -> Matchers.arrayContaining((Object[])items));
    }

    @SafeVarargs
    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T @UnknownKeyFor @NonNull @Initialized []> arrayContaining(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T ... items) {
        SerializableArrayViaCoder itemsSupplier = new SerializableArrayViaCoder(coder, items);
        return SerializableMatchers.fromSupplier(() -> Matchers.arrayContaining((Object[])((Object[])itemsSupplier.get())));
    }

    @SafeVarargs
    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T @UnknownKeyFor @NonNull @Initialized []> arrayContaining(SerializableMatcher<? super T> ... matchers) {
        return SerializableMatchers.fromSupplier(() -> Matchers.arrayContaining((Matcher[])matchers));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T @UnknownKeyFor @NonNull @Initialized []> arrayContaining(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @Nullable @Initialized ? super T>> serializableMatchers) {
        List matchers = serializableMatchers;
        return SerializableMatchers.fromSupplier(() -> Matchers.arrayContaining((List)matchers));
    }

    @SafeVarargs
    public static <T extends Serializable> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T @UnknownKeyFor @NonNull @Initialized []> arrayContainingInAnyOrder(T ... items) {
        return SerializableMatchers.fromSupplier(() -> Matchers.arrayContainingInAnyOrder((Object[])items));
    }

    @SafeVarargs
    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T @UnknownKeyFor @NonNull @Initialized []> arrayContainingInAnyOrder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T ... items) {
        SerializableArrayViaCoder itemsSupplier = new SerializableArrayViaCoder(coder, items);
        return SerializableMatchers.fromSupplier(() -> Matchers.arrayContaining((Object[])((Object[])itemsSupplier.get())));
    }

    @SafeVarargs
    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T @UnknownKeyFor @NonNull @Initialized []> arrayContainingInAnyOrder(SerializableMatcher<? super T> ... matchers) {
        return SerializableMatchers.fromSupplier(() -> Matchers.arrayContainingInAnyOrder((Matcher[])matchers));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T @UnknownKeyFor @NonNull @Initialized []> arrayContainingInAnyOrder(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @Nullable @Initialized ? super T>> serializableMatchers) {
        Collection matchers = serializableMatchers;
        return SerializableMatchers.fromSupplier(() -> Matchers.arrayContainingInAnyOrder((Collection)matchers));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T @UnknownKeyFor @NonNull @Initialized []> arrayWithSize(@UnknownKeyFor @NonNull @Initialized int size) {
        return SerializableMatchers.fromSupplier(() -> Matchers.arrayWithSize((int)size));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T @UnknownKeyFor @NonNull @Initialized []> arrayWithSize(@UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @Nullable @Initialized ? super @UnknownKeyFor @NonNull @Initialized Integer> sizeMatcher) {
        return SerializableMatchers.fromSupplier(() -> Matchers.arrayWithSize((Matcher)sizeMatcher));
    }

    public static @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized Double> closeTo(@UnknownKeyFor @NonNull @Initialized double target, @UnknownKeyFor @NonNull @Initialized double error) {
        return SerializableMatchers.fromSupplier(() -> Matchers.closeTo((double)target, (double)error));
    }

    @SafeVarargs
    public static <T extends Serializable> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends T>> contains(T ... items) {
        return SerializableMatchers.fromSupplier(() -> Matchers.contains((Object[])items));
    }

    @SafeVarargs
    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends T>> contains(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T ... items) {
        SerializableArrayViaCoder itemsSupplier = new SerializableArrayViaCoder(coder, items);
        return SerializableMatchers.fromSupplier(() -> Matchers.containsInAnyOrder((Object[])((Object[])itemsSupplier.get())));
    }

    @SafeVarargs
    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends T>> contains(SerializableMatcher<? super T> ... matchers) {
        return SerializableMatchers.fromSupplier(() -> Matchers.contains((Matcher[])matchers));
    }

    public static <T extends Serializable> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends T>> contains(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @Nullable @Initialized ? super T>> serializableMatchers) {
        List matchers = serializableMatchers;
        return SerializableMatchers.fromSupplier(() -> Matchers.contains((List)matchers));
    }

    @SafeVarargs
    public static <T extends Serializable> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends T>> containsInAnyOrder(T ... items) {
        return SerializableMatchers.fromSupplier(() -> Matchers.containsInAnyOrder((Object[])items));
    }

    @SafeVarargs
    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends T>> containsInAnyOrder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T ... items) {
        SerializableArrayViaCoder itemsSupplier = new SerializableArrayViaCoder(coder, items);
        return SerializableMatchers.fromSupplier(() -> Matchers.containsInAnyOrder((Object[])((Object[])itemsSupplier.get())));
    }

    @SafeVarargs
    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends T>> containsInAnyOrder(SerializableMatcher<? super T> ... matchers) {
        return SerializableMatchers.fromSupplier(() -> Matchers.containsInAnyOrder((Matcher[])matchers));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends T>> containsInAnyOrder(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @Nullable @Initialized ? super T>> serializableMatchers) {
        Collection matchers = serializableMatchers;
        return SerializableMatchers.fromSupplier(() -> Matchers.containsInAnyOrder((Collection)matchers));
    }

    public static @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized String> containsString(@UnknownKeyFor @NonNull @Initialized String substring) {
        return SerializableMatchers.fromSupplier(() -> Matchers.containsString((String)substring));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends T>> empty() {
        return SerializableMatchers.fromSupplier(Matchers::empty);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T @UnknownKeyFor @NonNull @Initialized []> emptyArray() {
        return SerializableMatchers.fromSupplier(Matchers::emptyArray);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends T>> emptyIterable() {
        return SerializableMatchers.fromSupplier(Matchers::emptyIterable);
    }

    public static @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized String> endsWith(@UnknownKeyFor @NonNull @Initialized String substring) {
        return SerializableMatchers.fromSupplier(() -> Matchers.endsWith((String)substring));
    }

    public static <T extends Serializable> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> equalTo(T expected) {
        return SerializableMatchers.fromSupplier(() -> Matchers.equalTo((Object)expected));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> equalTo(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T expected) {
        SerializableViaCoder expectedSupplier = new SerializableViaCoder(coder, expected);
        return SerializableMatchers.fromSupplier(() -> Matchers.equalTo(expectedSupplier.get()));
    }

    public static <T extends Comparable<T> & Serializable> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> greaterThan(T target) {
        return SerializableMatchers.fromSupplier(() -> Matchers.greaterThan((Comparable)target));
    }

    public static <T extends Comparable<T> & Serializable> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> greaterThan(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T target) {
        SerializableViaCoder targetSupplier = new SerializableViaCoder(coder, target);
        return SerializableMatchers.fromSupplier(() -> Matchers.greaterThan((Comparable)((Comparable)targetSupplier.get())));
    }

    public static <T extends Comparable<T>> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> greaterThanOrEqualTo(T target) {
        return SerializableMatchers.fromSupplier(() -> Matchers.greaterThanOrEqualTo((Comparable)target));
    }

    public static <T extends Comparable<T> & Serializable> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> greaterThanOrEqualTo(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T target) {
        SerializableViaCoder targetSupplier = new SerializableViaCoder(coder, target);
        return SerializableMatchers.fromSupplier(() -> Matchers.greaterThanOrEqualTo((Comparable)((Comparable)targetSupplier.get())));
    }

    public static <T extends Serializable> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @Nullable @Initialized ? super T>> hasItem(T target) {
        return SerializableMatchers.fromSupplier(() -> Matchers.hasItem((Object)target));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @Nullable @Initialized ? super T>> hasItem(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T target) {
        SerializableViaCoder targetSupplier = new SerializableViaCoder(coder, target);
        return SerializableMatchers.fromSupplier(() -> Matchers.hasItem(targetSupplier.get()));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @Nullable @Initialized ? super T>> hasItem(@UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @Nullable @Initialized ? super T> matcher) {
        return SerializableMatchers.fromSupplier(() -> Matchers.hasItem((Matcher)matcher));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends T>> hasSize(@UnknownKeyFor @NonNull @Initialized int size) {
        return SerializableMatchers.fromSupplier(() -> Matchers.hasSize((int)size));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends T>> hasSize(@UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @Nullable @Initialized ? super @UnknownKeyFor @NonNull @Initialized Integer> sizeMatcher) {
        return SerializableMatchers.fromSupplier(() -> Matchers.hasSize((Matcher)sizeMatcher));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized Iterable<T>> iterableWithSize(@UnknownKeyFor @NonNull @Initialized int size) {
        return SerializableMatchers.fromSupplier(() -> Matchers.iterableWithSize((int)size));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized Iterable<T>> iterableWithSize(@UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @Nullable @Initialized ? super @UnknownKeyFor @NonNull @Initialized Integer> sizeMatcher) {
        return SerializableMatchers.fromSupplier(() -> Matchers.iterableWithSize((Matcher)sizeMatcher));
    }

    public static <T extends Serializable> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> isIn(@UnknownKeyFor @NonNull @Initialized Collection<T> collection) {
        return SerializableMatchers.fromSupplier(() -> Is.is((Matcher)Matchers.in((Collection)collection)));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> isIn(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized Collection<T> collection) {
        Object[] items = collection.toArray();
        SerializableArrayViaCoder<Object> itemsSupplier = new SerializableArrayViaCoder<Object>(coder, items);
        return SerializableMatchers.fromSupplier(() -> Is.is((Matcher)Matchers.in((Object[])((Object[])itemsSupplier.get()))));
    }

    public static <T extends Serializable> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> isIn(T @UnknownKeyFor @NonNull @Initialized [] items) {
        return SerializableMatchers.fromSupplier(() -> Is.is((Matcher)Matchers.in((Object[])items)));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> isIn(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T @UnknownKeyFor @NonNull @Initialized [] items) {
        SerializableArrayViaCoder itemsSupplier = new SerializableArrayViaCoder(coder, items);
        return SerializableMatchers.fromSupplier(() -> Is.is((Matcher)Matchers.in((Object[])((Object[])itemsSupplier.get()))));
    }

    @SafeVarargs
    public static <T extends Serializable> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> isOneOf(T ... elems) {
        return SerializableMatchers.fromSupplier(() -> Matchers.isOneOf((Object[])elems));
    }

    @SafeVarargs
    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> isOneOf(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T ... items) {
        SerializableArrayViaCoder itemsSupplier = new SerializableArrayViaCoder(coder, items);
        return SerializableMatchers.fromSupplier(() -> Matchers.isOneOf((Object[])((Object[])itemsSupplier.get())));
    }

    public static <K extends Serializable, V> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ? extends K, @UnknownKeyFor @NonNull @Initialized ? extends V>> kvWithKey(K key) {
        return new KvKeyMatcher(SerializableMatchers.equalTo(key));
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ? extends K, @UnknownKeyFor @NonNull @Initialized ? extends V>> kvWithKey(@UnknownKeyFor @NonNull @Initialized Coder<K> coder, K key) {
        return new KvKeyMatcher(SerializableMatchers.equalTo(coder, key));
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ? extends K, @UnknownKeyFor @NonNull @Initialized ? extends V>> kvWithKey(@UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @Nullable @Initialized ? super K> keyMatcher) {
        return new KvKeyMatcher(keyMatcher);
    }

    public static <K, V extends Serializable> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ? extends K, @UnknownKeyFor @NonNull @Initialized ? extends V>> kvWithValue(V value) {
        return new KvValueMatcher(SerializableMatchers.equalTo(value));
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ? extends K, @UnknownKeyFor @NonNull @Initialized ? extends V>> kvWithValue(@UnknownKeyFor @NonNull @Initialized Coder<V> coder, V value) {
        return new KvValueMatcher(SerializableMatchers.equalTo(coder, value));
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ? extends K, @UnknownKeyFor @NonNull @Initialized ? extends V>> kvWithValue(@UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @Nullable @Initialized ? super V> valueMatcher) {
        return new KvValueMatcher(valueMatcher);
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ? extends K, @UnknownKeyFor @NonNull @Initialized ? extends V>> kv(@UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @Nullable @Initialized ? super K> keyMatcher, @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @Nullable @Initialized ? super V> valueMatcher) {
        return SerializableMatchers.allOf(SerializableMatchers.kvWithKey(keyMatcher), SerializableMatchers.kvWithValue(valueMatcher));
    }

    public static <T extends Comparable<T> & Serializable> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> lessThan(T target) {
        return SerializableMatchers.fromSupplier(() -> Matchers.lessThan((Comparable)target));
    }

    public static <T extends Comparable<T>> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> lessThan(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T target) {
        SerializableViaCoder targetSupplier = new SerializableViaCoder(coder, target);
        return SerializableMatchers.fromSupplier(() -> Matchers.lessThan((Comparable)((Comparable)targetSupplier.get())));
    }

    public static <T extends Comparable<T> & Serializable> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> lessThanOrEqualTo(T target) {
        return SerializableMatchers.fromSupplier(() -> Matchers.lessThanOrEqualTo((Comparable)target));
    }

    public static <T extends Comparable<T>> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> lessThanOrEqualTo(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T target) {
        SerializableViaCoder targetSupplier = new SerializableViaCoder(coder, target);
        return SerializableMatchers.fromSupplier(() -> Matchers.lessThanOrEqualTo((Comparable)((Comparable)targetSupplier.get())));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> not(@UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> matcher) {
        return SerializableMatchers.fromSupplier(() -> Matchers.not((Matcher)matcher));
    }

    public static @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized Object> nullValue() {
        return SerializableMatchers.fromSupplier(Matchers::nullValue);
    }

    public static @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized String> startsWith(@UnknownKeyFor @NonNull @Initialized String substring) {
        return SerializableMatchers.fromSupplier(() -> Matchers.startsWith((String)substring));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> fromSupplier(@UnknownKeyFor @NonNull @Initialized SerializableSupplier<@UnknownKeyFor @NonNull @Initialized Matcher<T>> supplier) {
        return new SerializableMatcherFromSupplier<T>(supplier);
    }

    private static class SerializableArrayViaCoder<@UnknownKeyFor T>
    implements SerializableSupplier<T[]> {
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
        private transient T @Nullable @UnknownKeyFor @Initialized [] value;
        private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] encodedValue;
        private @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized List<T>> coder;

        public SerializableArrayViaCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> elementCoder, T @UnknownKeyFor @NonNull @Initialized [] value) {
            this.coder = ListCoder.of(elementCoder);
            this.value = value;
            try {
                this.encodedValue = CoderUtils.encodeToByteArray(this.coder, Arrays.asList(value));
            }
            catch (CoderException exc) {
                throw UserCodeException.wrap(exc);
            }
        }

        @Override
        public T @UnknownKeyFor @NonNull @Initialized [] get() {
            if (this.value == null) {
                try {
                    Object[] decoded = CoderUtils.decodeFromByteArray(this.coder, this.encodedValue).toArray();
                    this.value = decoded;
                }
                catch (CoderException exc) {
                    throw new RuntimeException("Error deserializing via Coder", exc);
                }
            }
            return this.value;
        }
    }

    private static class SerializableViaCoder<@UnknownKeyFor T>
    implements SerializableSupplier<T> {
        private transient @Nullable T value;
        private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] encodedValue;
        private @UnknownKeyFor @NonNull @Initialized Coder<T> coder;

        public SerializableViaCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T value) {
            this.coder = coder;
            this.value = value;
            try {
                this.encodedValue = CoderUtils.encodeToByteArray(coder, value);
            }
            catch (CoderException exc) {
                throw new RuntimeException("Error serializing via Coder", exc);
            }
        }

        @Override
        public T get() {
            if (this.value == null) {
                try {
                    this.value = CoderUtils.decodeFromByteArray(this.coder, this.encodedValue);
                }
                catch (CoderException exc) {
                    throw new RuntimeException("Error deserializing via Coder", exc);
                }
            }
            return this.value;
        }
    }

    private static class SerializableMatcherFromSupplier<@UnknownKeyFor T>
    extends BaseMatcher<T>
    implements SerializableMatcher<T> {
        private @UnknownKeyFor @NonNull @Initialized SerializableSupplier<@UnknownKeyFor @NonNull @Initialized Matcher<T>> supplier;

        public SerializableMatcherFromSupplier(@UnknownKeyFor @NonNull @Initialized SerializableSupplier<@UnknownKeyFor @NonNull @Initialized Matcher<T>> supplier) {
            this.supplier = supplier;
        }

        public void describeTo(@UnknownKeyFor @NonNull @Initialized Description description) {
            this.supplier.get().describeTo(description);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean matches(@UnknownKeyFor @NonNull @Initialized Object item) {
            return this.supplier.get().matches(item);
        }

        public void describeMismatch(@UnknownKeyFor @NonNull @Initialized Object item, @UnknownKeyFor @NonNull @Initialized Description mismatchDescription) {
            this.supplier.get().describeMismatch(item, mismatchDescription);
        }
    }

    public static interface SerializableSupplier<@UnknownKeyFor T>
    extends Serializable {
        public T get();
    }

    private static class KvValueMatcher<@UnknownKeyFor K, @UnknownKeyFor V>
    extends BaseMatcher<KV<? extends K, ? extends V>>
    implements SerializableMatcher<KV<? extends K, ? extends V>> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @Nullable @Initialized ? super V> valueMatcher;

        public KvValueMatcher(@UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @Nullable @Initialized ? super V> valueMatcher) {
            this.valueMatcher = valueMatcher;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean matches(@UnknownKeyFor @NonNull @Initialized Object item) {
            KV kvItem = (KV)item;
            return this.valueMatcher.matches(kvItem.getValue());
        }

        public void describeMismatch(@UnknownKeyFor @NonNull @Initialized Object item, @UnknownKeyFor @NonNull @Initialized Description mismatchDescription) {
            KV kvItem = (KV)item;
            if (!this.valueMatcher.matches(kvItem.getValue())) {
                mismatchDescription.appendText("value did not match: ");
                this.valueMatcher.describeMismatch(kvItem.getValue(), mismatchDescription);
            }
        }

        public void describeTo(@UnknownKeyFor @NonNull @Initialized Description description) {
            description.appendText("KV with value matching ");
            this.valueMatcher.describeTo(description);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper((Object)this).addValue(this.valueMatcher).toString();
        }
    }

    private static class KvKeyMatcher<@UnknownKeyFor K, @UnknownKeyFor V>
    extends BaseMatcher<KV<? extends K, ? extends V>>
    implements SerializableMatcher<KV<? extends K, ? extends V>> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @Nullable @Initialized ? super K> keyMatcher;

        public KvKeyMatcher(@UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @Nullable @Initialized ? super K> keyMatcher) {
            this.keyMatcher = keyMatcher;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean matches(@UnknownKeyFor @NonNull @Initialized Object item) {
            KV kvItem = (KV)item;
            return this.keyMatcher.matches(kvItem.getKey());
        }

        public void describeMismatch(@UnknownKeyFor @NonNull @Initialized Object item, @UnknownKeyFor @NonNull @Initialized Description mismatchDescription) {
            KV kvItem = (KV)item;
            if (!this.keyMatcher.matches(kvItem.getKey())) {
                mismatchDescription.appendText("key did not match: ");
                this.keyMatcher.describeMismatch(kvItem.getKey(), mismatchDescription);
            }
        }

        public void describeTo(@UnknownKeyFor @NonNull @Initialized Description description) {
            description.appendText("KV with key matching ");
            this.keyMatcher.describeTo(description);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper((Object)this).addValue(this.keyMatcher).toString();
        }
    }
}

