/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import java.util.List;
import java.util.Optional;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public abstract class TypedSchemaTransformProvider<@UnknownKeyFor ConfigT>
implements SchemaTransformProvider {
    protected abstract @UnknownKeyFor @NonNull @Initialized Class<ConfigT> configurationClass();

    protected abstract @UnknownKeyFor @NonNull @Initialized SchemaTransform from(ConfigT var1);

    @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> dependencies(ConfigT configuration, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return Optional.empty();
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized Schema configurationSchema() {
        try {
            return SchemaRegistry.createDefault().getSchema(this.configurationClass()).sorted();
        }
        catch (NoSuchSchemaException e) {
            throw new RuntimeException("Unable to find schema for " + this.identifier() + " SchemaTransformProvider's configuration.");
        }
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized Row configuration) {
        return this.from(this.configFromRow(configuration));
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> dependencies(@UnknownKeyFor @NonNull @Initialized Row configuration, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return this.dependencies(this.configFromRow(configuration), options);
    }

    private ConfigT configFromRow(@UnknownKeyFor @NonNull @Initialized Row configuration) {
        try {
            return SchemaRegistry.createDefault().getFromRowFunction(this.configurationClass()).apply(configuration);
        }
        catch (NoSuchSchemaException e) {
            throw new RuntimeException("Unable to find schema for " + this.identifier() + "SchemaTransformProvider's config");
        }
    }
}

