/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.avro.transforms.avrodecode;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.avro.transforms.avrodecode.AvroDecode;
import org.apache.hop.avro.transforms.avrodecode.AvroDecodeData;
import org.apache.hop.avro.transforms.avrodecode.TargetField;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

@Transform(id="AvroDecode", name="Avro Decode", description="Decodes Avro data types into Hop fields", image="avro_decode.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", documentationUrl="/pipeline/transforms/avro-decode.html", keywords={"i18n::AvroDecodeMeta.keyword"})
public class AvroDecodeMeta
extends BaseTransformMeta<AvroDecode, AvroDecodeData> {
    private static final Class<?> PKG = AvroDecodeMeta.class;
    @HopMetadataProperty(key="source_field")
    private String sourceFieldName = "avro";
    @HopMetadataProperty(key="remove_source_field")
    private boolean removingSourceField = true;
    @HopMetadataProperty(key="ignore_missing")
    private boolean ignoringMissingPaths = true;
    @HopMetadataProperty(groupKey="fields", key="field")
    private List<TargetField> targetFields = new ArrayList<TargetField>();

    public void getFields(IRowMeta rowMeta, String transformName, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (TargetField targetField : this.targetFields) {
            try {
                IValueMeta valueMeta = targetField.createTargetValueMeta(variables);
                rowMeta.addValueMeta(valueMeta);
            }
            catch (HopException e) {
                throw new HopTransformException("Error creating target field with name " + targetField.getTargetFieldName(), (Throwable)e);
            }
        }
    }

    public String getSourceFieldName() {
        return this.sourceFieldName;
    }

    public void setSourceFieldName(String sourceFieldName) {
        this.sourceFieldName = sourceFieldName;
    }

    public boolean isRemovingSourceField() {
        return this.removingSourceField;
    }

    public void setRemovingSourceField(boolean removingSourceField) {
        this.removingSourceField = removingSourceField;
    }

    public boolean isIgnoringMissingPaths() {
        return this.ignoringMissingPaths;
    }

    public void setIgnoringMissingPaths(boolean ignoringMissingPaths) {
        this.ignoringMissingPaths = ignoringMissingPaths;
    }

    public List<TargetField> getTargetFields() {
        return this.targetFields;
    }

    public void setTargetFields(List<TargetField> targetFields) {
        this.targetFields = targetFields;
    }
}

