/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.amazonaws.regions.Regions;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.google.auto.service.AutoService;
import java.util.Map;
import java.util.Properties;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.expansion.ExternalTransformRegistrar;
import org.apache.beam.sdk.io.kinesis.KinesisIO;
import org.apache.beam.sdk.transforms.ExternalTransformBuilder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.PORTABILITY)
@AutoService(value={ExternalTransformRegistrar.class})
public class KinesisTransformRegistrar
implements ExternalTransformRegistrar {
    public static final @UnknownKeyFor @NonNull @Initialized String WRITE_URN = "beam:transform:org.apache.beam:kinesis_write:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String READ_DATA_URN = "beam:transform:org.apache.beam:kinesis_read_data:v1";

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ExternalTransformBuilder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> knownBuilderInstances() {
        return ImmutableMap.of((Object)WRITE_URN, (Object)new WriteBuilder(), (Object)READ_DATA_URN, (Object)new ReadDataBuilder());
    }

    public static class ReadDataBuilder
    implements ExternalTransformBuilder<Configuration, PBegin, PCollection<byte[]>> {
        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> buildExternal(@UnknownKeyFor @NonNull @Initialized Configuration configuration) {
            KinesisIO.Read<byte[]> readTransform = KinesisIO.readData().withStreamName(configuration.streamName).withAWSClientsProvider(configuration.awsAccessKey, configuration.awsSecretKey, configuration.region, configuration.serviceEndpoint, configuration.verifyCertificate);
            if (configuration.maxNumRecords != null) {
                readTransform = readTransform.withMaxNumRecords(configuration.maxNumRecords);
            }
            if (configuration.upToDateThreshold != null) {
                readTransform = readTransform.withUpToDateThreshold(configuration.upToDateThreshold);
            }
            if (configuration.maxCapacityPerShard != null) {
                readTransform = readTransform.withMaxCapacityPerShard(configuration.maxCapacityPerShard.intValue());
            }
            if (configuration.watermarkPolicy != null) {
                switch (configuration.watermarkPolicy) {
                    case ARRIVAL_TIME: {
                        readTransform = configuration.watermarkIdleDurationThreshold != null ? readTransform.withArrivalTimeWatermarkPolicy(configuration.watermarkIdleDurationThreshold) : readTransform.withArrivalTimeWatermarkPolicy();
                        break;
                    }
                    case PROCESSING_TIME: {
                        readTransform = readTransform.withProcessingTimeWatermarkPolicy();
                        break;
                    }
                    default: {
                        throw new RuntimeException(String.format("Unsupported watermark policy type: %s", new Object[]{configuration.watermarkPolicy}));
                    }
                }
            }
            if (configuration.rateLimit != null) {
                readTransform = readTransform.withFixedDelayRateLimitPolicy(configuration.rateLimit);
            }
            if (configuration.maxReadTime != null) {
                readTransform = readTransform.withMaxReadTime(configuration.maxReadTime);
            }
            if (configuration.initialPositionInStream != null) {
                readTransform = readTransform.withInitialPositionInStream(configuration.initialPositionInStream);
            }
            if (configuration.requestRecordsLimit != null) {
                readTransform = readTransform.withRequestRecordsLimit(configuration.requestRecordsLimit);
            }
            if (configuration.initialTimestampInStream != null) {
                readTransform = readTransform.withInitialTimestampInStream(configuration.initialTimestampInStream);
            }
            return readTransform;
        }

        private static enum WatermarkPolicy {
            ARRIVAL_TIME,
            PROCESSING_TIME;

        }

        public static class Configuration
        extends CrossLanguageConfiguration {
            private @Nullable @UnknownKeyFor @Initialized Long maxNumRecords;
            private @Nullable @UnknownKeyFor @Initialized Duration maxReadTime;
            private @Nullable @UnknownKeyFor @Initialized InitialPositionInStream initialPositionInStream;
            private @Nullable @UnknownKeyFor @Initialized Instant initialTimestampInStream;
            private @Nullable @UnknownKeyFor @Initialized Integer requestRecordsLimit;
            private @Nullable @UnknownKeyFor @Initialized Duration upToDateThreshold;
            private @Nullable @UnknownKeyFor @Initialized Long maxCapacityPerShard;
            private @Nullable @UnknownKeyFor @Initialized WatermarkPolicy watermarkPolicy;
            private @Nullable @UnknownKeyFor @Initialized Duration watermarkIdleDurationThreshold;
            private @Nullable @UnknownKeyFor @Initialized Duration rateLimit;

            public void setMaxNumRecords(@Nullable @UnknownKeyFor @Initialized Long maxNumRecords) {
                this.maxNumRecords = maxNumRecords;
            }

            public void setMaxReadTime(@Nullable @UnknownKeyFor @Initialized Long maxReadTime) {
                if (maxReadTime != null) {
                    this.maxReadTime = Duration.millis((long)maxReadTime);
                }
            }

            public void setInitialPositionInStream(@Nullable @UnknownKeyFor @Initialized String initialPositionInStream) {
                if (initialPositionInStream != null) {
                    this.initialPositionInStream = InitialPositionInStream.valueOf((String)initialPositionInStream);
                }
            }

            public void setInitialTimestampInStream(@Nullable @UnknownKeyFor @Initialized Long initialTimestampInStream) {
                if (initialTimestampInStream != null) {
                    this.initialTimestampInStream = Instant.ofEpochMilli((long)initialTimestampInStream);
                }
            }

            public void setRequestRecordsLimit(@Nullable @UnknownKeyFor @Initialized Long requestRecordsLimit) {
                if (requestRecordsLimit != null) {
                    this.requestRecordsLimit = requestRecordsLimit.intValue();
                }
            }

            public void setUpToDateThreshold(@Nullable @UnknownKeyFor @Initialized Long upToDateThreshold) {
                if (upToDateThreshold != null) {
                    this.upToDateThreshold = Duration.millis((long)upToDateThreshold);
                }
            }

            public void setMaxCapacityPerShard(@Nullable @UnknownKeyFor @Initialized Long maxCapacityPerShard) {
                this.maxCapacityPerShard = maxCapacityPerShard;
            }

            public void setWatermarkPolicy(@Nullable @UnknownKeyFor @Initialized String watermarkPolicy) {
                if (watermarkPolicy != null) {
                    this.watermarkPolicy = WatermarkPolicy.valueOf(watermarkPolicy);
                }
            }

            public void setWatermarkIdleDurationThreshold(@Nullable @UnknownKeyFor @Initialized Long watermarkIdleDurationThreshold) {
                if (watermarkIdleDurationThreshold != null) {
                    this.watermarkIdleDurationThreshold = Duration.millis((long)watermarkIdleDurationThreshold);
                }
            }

            public void setRateLimit(@Nullable @UnknownKeyFor @Initialized Long rateLimit) {
                if (rateLimit != null) {
                    this.rateLimit = Duration.millis((long)rateLimit);
                }
            }
        }
    }

    public static class WriteBuilder
    implements ExternalTransformBuilder<Configuration, PCollection<byte[]>, PDone> {
        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>, @UnknownKeyFor @NonNull @Initialized PDone> buildExternal(@UnknownKeyFor @NonNull @Initialized Configuration configuration) {
            KinesisIO.Write writeTransform = KinesisIO.write().withStreamName(configuration.streamName).withAWSClientsProvider(configuration.awsAccessKey, configuration.awsSecretKey, configuration.region, configuration.serviceEndpoint, configuration.verifyCertificate).withPartitionKey(configuration.partitionKey);
            if (configuration.producerProperties != null) {
                writeTransform = writeTransform.withProducerProperties(configuration.producerProperties);
            }
            return writeTransform;
        }

        public static class Configuration
        extends CrossLanguageConfiguration {
            private @UnknownKeyFor @NonNull @Initialized Properties producerProperties;
            private @UnknownKeyFor @NonNull @Initialized String partitionKey;

            public void setProducerProperties(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> producerProperties) {
                if (producerProperties != null) {
                    Properties properties = new Properties();
                    producerProperties.forEach(properties::setProperty);
                    this.producerProperties = properties;
                }
            }

            public void setPartitionKey(@UnknownKeyFor @NonNull @Initialized String partitionKey) {
                this.partitionKey = partitionKey;
            }
        }
    }

    private static abstract class CrossLanguageConfiguration {
        @UnknownKeyFor @NonNull @Initialized String streamName;
        @UnknownKeyFor @NonNull @Initialized String awsAccessKey;
        @UnknownKeyFor @NonNull @Initialized String awsSecretKey;
        @UnknownKeyFor @NonNull @Initialized Regions region;
        @Nullable @UnknownKeyFor @Initialized String serviceEndpoint;
        @UnknownKeyFor @NonNull @Initialized boolean verifyCertificate;

        private CrossLanguageConfiguration() {
        }

        public void setStreamName(@UnknownKeyFor @NonNull @Initialized String streamName) {
            this.streamName = streamName;
        }

        public void setAwsAccessKey(@UnknownKeyFor @NonNull @Initialized String awsAccessKey) {
            this.awsAccessKey = awsAccessKey;
        }

        public void setAwsSecretKey(@UnknownKeyFor @NonNull @Initialized String awsSecretKey) {
            this.awsSecretKey = awsSecretKey;
        }

        public void setRegion(@UnknownKeyFor @NonNull @Initialized String region) {
            this.region = Regions.fromName((String)region);
        }

        public void setServiceEndpoint(@Nullable @UnknownKeyFor @Initialized String serviceEndpoint) {
            this.serviceEndpoint = serviceEndpoint;
        }

        public void setVerifyCertificate(@Nullable @UnknownKeyFor @Initialized Boolean verifyCertificate) {
            this.verifyCertificate = verifyCertificate == null || verifyCertificate != false;
        }
    }
}

