/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.scanner;

import com.google.api.core.InternalApi;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.cloud.bigtable.grpc.scanner.FlatRow;
import com.google.cloud.bigtable.grpc.scanner.ResultQueueEntry;
import com.google.cloud.bigtable.metrics.BigtableClientMetrics;
import com.google.cloud.bigtable.metrics.Timer;
import com.google.common.base.Preconditions;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

@InternalApi(value="For internal usage only")
public class ResponseQueueReader
implements StreamObserver<FlatRow>,
ClientResponseObserver<ReadRowsRequest, FlatRow> {
    private static Timer firstResponseTimer;
    private final BlockingQueue<ResultQueueEntry<FlatRow>> resultQueue = new LinkedBlockingQueue<ResultQueueEntry<FlatRow>>();
    private final AtomicBoolean completionMarkerFound = new AtomicBoolean(false);
    private boolean lastResponseProcessed = false;
    private Long startTime;
    private ClientCallStreamObserver<ReadRowsRequest> requestStream;
    private AtomicInteger markerCounter = new AtomicInteger();

    private static synchronized Timer getFirstResponseTimer() {
        if (firstResponseTimer == null) {
            firstResponseTimer = BigtableClientMetrics.timer((BigtableClientMetrics.MetricLevel)BigtableClientMetrics.MetricLevel.Info, (String)"grpc.method.ReadRows.firstResponse.latency");
        }
        return firstResponseTimer;
    }

    public ResponseQueueReader() {
        if (BigtableClientMetrics.isEnabled((BigtableClientMetrics.MetricLevel)BigtableClientMetrics.MetricLevel.Info)) {
            this.startTime = System.nanoTime();
        }
    }

    public void beforeStart(ClientCallStreamObserver<ReadRowsRequest> requestStream) {
        requestStream.disableAutoInboundFlowControl();
        this.requestStream = requestStream;
    }

    public void close() {
        this.requestStream.cancel("Closing ResponseQueueReader", null);
    }

    public synchronized FlatRow getNextMergedRow() throws IOException {
        ResultQueueEntry<FlatRow> queueEntry = this.getNext();
        switch (queueEntry.getType()) {
            case CompletionMarker: {
                this.lastResponseProcessed = true;
                this.markerCounter.decrementAndGet();
                break;
            }
            case Data: {
                if (this.startTime != null) {
                    ResponseQueueReader.getFirstResponseTimer().update(System.nanoTime() - this.startTime, TimeUnit.NANOSECONDS);
                    this.startTime = null;
                }
                return queueEntry.getResponseOrThrow();
            }
            case Exception: {
                this.markerCounter.decrementAndGet();
                return queueEntry.getResponseOrThrow();
            }
            case RequestResultMarker: {
                this.markerCounter.decrementAndGet();
                if (!this.completionMarkerFound.get()) {
                    this.requestStream.request(1);
                }
                return this.getNextMergedRow();
            }
            default: {
                throw new IllegalStateException("Cannot process type: " + (Object)((Object)queueEntry.getType()));
            }
        }
        Preconditions.checkState((boolean)this.lastResponseProcessed, (Object)"Should only exit merge loop with by returning a complete FlatRow or hitting end of stream.");
        return null;
    }

    protected ResultQueueEntry<FlatRow> getNext() throws IOException {
        ResultQueueEntry<FlatRow> queueEntry;
        try {
            queueEntry = this.resultQueue.take();
            if (queueEntry == null) {
                throw new IllegalStateException("Timed out awaiting next sync rows");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while waiting for next result", e);
        }
        return queueEntry;
    }

    public int available() {
        return this.resultQueue.size() - this.markerCounter.get();
    }

    public void onNext(FlatRow row) {
        this.addEntry("adding a data ResultQueueEntry", ResultQueueEntry.fromResponse(row));
    }

    public void onError(Throwable t) {
        this.addEntry("adding an error ResultQueueEntry", ResultQueueEntry.fromThrowable(t));
        this.markerCounter.incrementAndGet();
    }

    public void onCompleted() {
        this.completionMarkerFound.set(true);
        this.addEntry("setting completion", ResultQueueEntry.completionMarker());
        this.markerCounter.incrementAndGet();
    }

    public void addRequestResultMarker() {
        this.addEntry("setting request result marker", ResultQueueEntry.requestResultMarker());
        this.markerCounter.incrementAndGet();
    }

    private void addEntry(String message, ResultQueueEntry<FlatRow> entry) {
        try {
            this.resultQueue.put(entry);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while " + message, e);
        }
    }
}

