/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.folderscompare;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.w3c.dom.Node;

@Action(id="FOLDERS_COMPARE", name="i18n::ActionFoldersCompare.Name", description="i18n::ActionFoldersCompare.Description", image="FoldersCompare.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", keywords={"i18n::ActionFoldersCompare.keyword"}, documentationUrl="/workflow/actions/folderscompare.html")
public class ActionFoldersCompare
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionFoldersCompare.class;
    private String filename1 = null;
    private String filename2 = null;
    private String wildcard = null;
    private String compareonly = "all";
    private boolean includesubfolders = false;
    private boolean comparefilecontent = false;
    private boolean comparefilesize = false;

    public ActionFoldersCompare(String n) {
        super(n, "");
    }

    public void setCompareOnly(String comparevalue) {
        this.compareonly = comparevalue;
    }

    public String getCompareOnly() {
        return this.compareonly;
    }

    public ActionFoldersCompare() {
        this("");
    }

    public Object clone() {
        ActionFoldersCompare je = (ActionFoldersCompare)super.clone();
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(200);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"include_subfolders", (boolean)this.includesubfolders));
        retval.append("      ").append(XmlHandler.addTagValue((String)"compare_filecontent", (boolean)this.comparefilecontent));
        retval.append("      ").append(XmlHandler.addTagValue((String)"compare_filesize", (boolean)this.comparefilesize));
        retval.append("      ").append(XmlHandler.addTagValue((String)"compareonly", (String)this.compareonly));
        retval.append("      ").append(XmlHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XmlHandler.addTagValue((String)"filename1", (String)this.filename1));
        retval.append("      ").append(XmlHandler.addTagValue((String)"filename2", (String)this.filename2));
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.includesubfolders = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            this.comparefilecontent = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"compare_filecontent"));
            this.comparefilesize = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"compare_filesize"));
            this.compareonly = XmlHandler.getTagValue((Node)entrynode, (String)"compareonly");
            this.wildcard = XmlHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.filename1 = XmlHandler.getTagValue((Node)entrynode, (String)"filename1");
            this.filename2 = XmlHandler.getTagValue((Node)entrynode, (String)"filename2");
        }
        catch (HopXmlException xe) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Meta.UnableLoadXML", (String[])new String[]{xe.getMessage()}));
        }
    }

    public void setIncludeSubfolders(boolean includeSubfolders) {
        this.includesubfolders = includeSubfolders;
    }

    public boolean isIncludeSubfolders() {
        return this.includesubfolders;
    }

    public void setCompareFileContent(boolean comparefilecontent) {
        this.comparefilecontent = comparefilecontent;
    }

    public boolean isCompareFileContent() {
        return this.comparefilecontent;
    }

    public void setCompareFileSize(boolean comparefilesize) {
        this.comparefilesize = comparefilesize;
    }

    public boolean isCompareFileSize() {
        return this.comparefilesize;
    }

    public String getRealWildcard() {
        return this.resolve(this.getWildcard());
    }

    public String getRealFilename1() {
        return this.resolve(this.getFilename1());
    }

    public String getRealFilename2() {
        return this.resolve(this.getFilename2());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean equalFileContents(FileObject file1, FileObject file2) throws HopFileException {
        FilterInputStream in1 = null;
        FilterInputStream in2 = null;
        try {
            in1 = new DataInputStream(new BufferedInputStream(HopVfs.getInputStream((String)HopVfs.getFilename((FileObject)file1))));
            in2 = new DataInputStream(new BufferedInputStream(HopVfs.getInputStream((String)HopVfs.getFilename((FileObject)file2))));
            while (in1.available() != 0 && in2.available() != 0) {
                char ch2;
                char ch1 = (char)((DataInputStream)in1).readByte();
                if (ch1 == (ch2 = (char)((DataInputStream)in2).readByte())) continue;
                boolean bl = false;
                return bl;
            }
            if (in1.available() != in2.available()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new HopFileException((Throwable)e);
        }
        finally {
            if (in1 != null) {
                try {
                    in1.close();
                }
                catch (IOException iOException) {}
            }
            if (in2 != null) {
                try {
                    in2.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        boolean ok = true;
        String realFilename1 = this.getRealFilename1();
        String realFilename2 = this.getRealFilename2();
        FileObject folder1 = null;
        FileObject folder2 = null;
        FileObject filefolder1 = null;
        FileObject filefolder2 = null;
        try {
            if (this.filename1 != null && this.filename2 != null) {
                folder1 = HopVfs.getFileObject((String)realFilename1);
                folder2 = HopVfs.getFileObject((String)realFilename2);
                if (folder1.exists() && folder2.exists()) {
                    if (!folder1.getType().equals((Object)folder2.getType())) {
                        this.logError(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.CanNotCompareFilesFolders", (String[])new String[0]));
                        if (folder1.getType() == FileType.FILE) {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.IsAFile", (String[])new String[]{realFilename1}));
                        } else if (folder1.getType() == FileType.FOLDER) {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.IsAFolder", (String[])new String[]{realFilename1}));
                        } else {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.IsUnknownFileType", (String[])new String[]{realFilename1}));
                        }
                        if (folder2.getType() == FileType.FILE) {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.IsAFile", (String[])new String[]{realFilename2}));
                        } else if (folder2.getType() == FileType.FOLDER) {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.IsAFolder", (String[])new String[]{realFilename2}));
                        } else {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.IsUnknownFileType", (String[])new String[]{realFilename2}));
                        }
                    } else if (folder1.getType() == FileType.FILE) {
                        if (this.equalFileContents(folder1, folder2)) {
                            result.setResult(true);
                        } else {
                            result.setResult(false);
                        }
                    } else if (folder1.getType() == FileType.FOLDER) {
                        FileObject[] list1 = folder1.findFiles((FileSelector)new TextFileSelector(folder1.toString()));
                        FileObject[] list2 = folder2.findFiles((FileSelector)new TextFileSelector(folder2.toString()));
                        int lenList1 = list1.length;
                        int lenList2 = list2.length;
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.FolderContains", (String[])new String[]{realFilename1, "" + lenList1}));
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.FolderContains", (String[])new String[]{realFilename2, "" + lenList2}));
                        }
                        if (lenList1 == lenList2) {
                            int i;
                            HashMap<String, String> collection1 = new HashMap<String, String>();
                            HashMap<String, String> collection2 = new HashMap<String, String>();
                            for (i = 0; i < list1.length; ++i) {
                                collection1.put(list1[i].getName().getBaseName(), list1[i].toString());
                            }
                            for (i = 0; i < list2.length; ++i) {
                                collection2.put(list2[i].getName().getBaseName(), list2[i].toString());
                            }
                            Set entrees = collection1.entrySet();
                            for (Map.Entry entree : entrees) {
                                long filefolder2Size;
                                long filefolder1Size;
                                if (!collection2.containsKey(entree.getKey())) {
                                    ok = false;
                                    if (!this.log.isDetailed()) continue;
                                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.FileCanNotBeFoundIn", (String[])new String[]{((String)entree.getKey()).toString(), realFilename2}));
                                    continue;
                                }
                                if (this.log.isDebug()) {
                                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.FileIsFoundIn", (String[])new String[]{((String)entree.getKey()).toString(), realFilename2}));
                                }
                                filefolder1 = HopVfs.getFileObject((String)((String)entree.getValue()));
                                filefolder2 = HopVfs.getFileObject((String)((String)collection2.get(entree.getKey())));
                                if (!filefolder2.getType().equals((Object)filefolder1.getType())) {
                                    ok = false;
                                    if (this.log.isDetailed()) {
                                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.FilesNotSameType", (String[])new String[]{filefolder1.toString(), filefolder2.toString()}));
                                    }
                                    if (filefolder1.getType() == FileType.FILE) {
                                        this.logError(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.IsAFile", (String[])new String[]{filefolder1.toString()}));
                                    } else if (filefolder1.getType() == FileType.FOLDER) {
                                        this.logError(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.IsAFolder", (String[])new String[]{filefolder1.toString()}));
                                    } else {
                                        this.logError(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.IsUnknownFileType", (String[])new String[]{filefolder1.toString()}));
                                    }
                                    if (filefolder2.getType() == FileType.FILE) {
                                        this.logError(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.IsAFile", (String[])new String[]{filefolder2.toString()}));
                                        continue;
                                    }
                                    if (filefolder2.getType() == FileType.FOLDER) {
                                        this.logError(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.IsAFolder", (String[])new String[]{filefolder2.toString()}));
                                        continue;
                                    }
                                    this.logError(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.IsUnknownFileType", (String[])new String[]{filefolder2.toString()}));
                                    continue;
                                }
                                if (filefolder2.getType() != FileType.FILE) continue;
                                if (this.comparefilesize && (filefolder1Size = filefolder1.getContent().getSize()) != (filefolder2Size = filefolder2.getContent().getSize())) {
                                    ok = false;
                                    if (this.log.isDetailed()) {
                                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.FilesNotSameSize", (String[])new String[]{filefolder1.toString(), filefolder2.toString()}));
                                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.SizeFileIs", (String[])new String[]{filefolder1.toString(), "" + filefolder1Size}));
                                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.SizeFileIs", (String[])new String[]{filefolder2.toString(), "" + filefolder2Size}));
                                    }
                                }
                                if (!ok || !this.comparefilecontent || this.equalFileContents(filefolder1, filefolder2)) continue;
                                ok = false;
                                if (!this.log.isDetailed()) continue;
                                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.FilesNotSameContent", (String[])new String[]{filefolder1.toString(), filefolder2.toString()}));
                            }
                            result.setResult(ok);
                        } else if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.FoldersDifferentFiles", (String[])new String[]{realFilename1.toString(), realFilename2.toString()}));
                        }
                    }
                } else {
                    if (!folder1.exists()) {
                        this.logError(BaseMessages.getString(PKG, (String)"ActionFileCompare.Log.FileNotExist", (String[])new String[]{realFilename1}));
                    }
                    if (!folder2.exists()) {
                        this.logError(BaseMessages.getString(PKG, (String)"ActionFileCompare.Log.FileNotExist", (String[])new String[]{realFilename2}));
                    }
                    result.setResult(false);
                    result.setNrErrors(1L);
                }
            } else {
                this.logError(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.Need2Files", (String[])new String[0]));
            }
        }
        catch (Exception e) {
            result.setResult(false);
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(PKG, (String)"ActionFoldersCompare.Log.ErrorComparing", (String[])new String[]{realFilename2, realFilename2, e.getMessage()}));
        }
        finally {
            try {
                if (folder1 != null) {
                    folder1.close();
                    folder1 = null;
                }
                if (folder2 != null) {
                    folder2.close();
                    folder2 = null;
                }
                if (filefolder1 != null) {
                    filefolder1.close();
                    filefolder1 = null;
                }
                if (filefolder2 != null) {
                    filefolder2.close();
                    filefolder2 = null;
                }
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    private boolean GetFileWildcard(String selectedfile) {
        Pattern pattern = null;
        boolean getIt = true;
        if (!Utils.isEmpty((CharSequence)this.wildcard) && (pattern = Pattern.compile(this.wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    public boolean isEvaluation() {
        return true;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public void setFilename1(String filename) {
        this.filename1 = filename;
    }

    public String getFilename1() {
        return this.filename1;
    }

    public void setFilename2(String filename) {
        this.filename2 = filename;
    }

    public String getFilename2() {
        return this.filename2;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator(), ActionValidatorUtils.fileExistsValidator()});
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "filename1", remarks, ctx);
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "filename2", remarks, ctx);
    }

    private class TextFileSelector
    implements FileSelector {
        String sourceFolder = null;

        public TextFileSelector(String sourcefolderin) {
            if (!Utils.isEmpty((CharSequence)sourcefolderin)) {
                this.sourceFolder = sourcefolderin;
            }
        }

        public boolean includeFile(FileSelectInfo info) {
            boolean returncode = false;
            try {
                if (!info.getFile().toString().equals(this.sourceFolder)) {
                    String shortFilename = info.getFile().getName().getBaseName();
                    if (info.getFile().getParent().equals(info.getBaseFolder())) {
                        if (info.getFile().getType() == FileType.FILE && ActionFoldersCompare.this.compareonly.equals("only_files") || info.getFile().getType() == FileType.FOLDER && ActionFoldersCompare.this.compareonly.equals("only_folders") || ActionFoldersCompare.this.GetFileWildcard(shortFilename) && ActionFoldersCompare.this.compareonly.equals("specify") || ActionFoldersCompare.this.compareonly.equals("all")) {
                            returncode = true;
                        }
                    } else if (ActionFoldersCompare.this.includesubfolders && (info.getFile().getType() == FileType.FILE && ActionFoldersCompare.this.compareonly.equals("only_files") || info.getFile().getType() == FileType.FOLDER && ActionFoldersCompare.this.compareonly.equals("only_folders") || ActionFoldersCompare.this.GetFileWildcard(shortFilename) && ActionFoldersCompare.this.compareonly.equals("specify") || ActionFoldersCompare.this.compareonly.equals("all"))) {
                        returncode = true;
                    }
                }
            }
            catch (Exception e) {
                ActionFoldersCompare.this.logError("Error while finding files ... in [" + info.getFile().toString() + "]. Exception :" + e.getMessage());
                returncode = false;
            }
            return returncode;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return true;
        }
    }
}

